/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.ProjectReportGenerator;
import org.gradle.api.tasks.diagnostics.internal.ReportGenerator;
import org.gradle.api.tasks.diagnostics.internal.dependencies.AsciiDependencyReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.logging.StyledTextOutputFactory;

@Incubating
public class BuildEnvironmentReportTask
extends DefaultTask {
    public static final String TASK_NAME = "buildEnvironment";
    private DependencyReportRenderer renderer = new AsciiDependencyReportRenderer();

    public BuildEnvironmentReportTask() {
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return false;
            }
        });
    }

    @Inject
    protected BuildClientMetaData getClientMetaData() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void generate() {
        ProjectReportGenerator projectReportGenerator = new ProjectReportGenerator(){

            public void generateReport(Project project) throws IOException {
                Configuration configuration = BuildEnvironmentReportTask.this.getProject().getBuildscript().getConfigurations().getByName("classpath");
                BuildEnvironmentReportTask.this.renderer.startConfiguration(configuration);
                BuildEnvironmentReportTask.this.renderer.render(configuration);
                BuildEnvironmentReportTask.this.renderer.completeConfiguration(configuration);
            }
        };
        ReportGenerator reportGenerator = new ReportGenerator(this.renderer, this.getClientMetaData(), null, this.getTextOutputFactory(), projectReportGenerator);
        reportGenerator.generateReport(Collections.singleton(this.getProject()));
    }

    @VisibleForTesting
    protected void setRenderer(DependencyReportRenderer dependencyReportRenderer) {
        this.renderer = dependencyReportRenderer;
    }
}

