/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.io.File;
import org.gradle.api.internal.changedetection.rules.ChangeType;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.tasks.incremental.InputFileDetails;

class FileChange
implements TaskStateChange,
InputFileDetails {
    private final String path;
    private final ChangeType change;
    private final String fileType;

    public FileChange(String path, ChangeType change, String fileType) {
        this.path = path;
        this.change = change;
        this.fileType = fileType;
    }

    public String getMessage() {
        return String.format("%s file %s %s.", this.fileType, this.path, this.change.describe());
    }

    public String toString() {
        return this.getMessage();
    }

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return new File(this.path);
    }

    public boolean isAdded() {
        return this.change == ChangeType.ADDED;
    }

    public boolean isModified() {
        return this.change == ChangeType.MODIFIED;
    }

    public boolean isRemoved() {
        return this.change == ChangeType.REMOVED;
    }
}

