/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.compression;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.gradle.api.internal.file.archive.compression.AbstractArchiver;
import org.gradle.api.internal.file.archive.compression.ArchiveOutputStreamFactory;
import org.gradle.api.resources.ResourceException;
import org.gradle.api.resources.internal.ReadableResourceInternal;

public class Bzip2Archiver
extends AbstractArchiver {
    public Bzip2Archiver(ReadableResourceInternal resource) {
        super(resource);
    }

    protected String getSchemePrefix() {
        return "bzip2:";
    }

    public static ArchiveOutputStreamFactory getCompressor() {
        return new ArchiveOutputStreamFactory(){

            public OutputStream createArchiveOutputStream(File destination) {
                try {
                    FileOutputStream outStr = new FileOutputStream(destination);
                    ((OutputStream)outStr).write(66);
                    ((OutputStream)outStr).write(90);
                    return new CBZip2OutputStream((OutputStream)outStr);
                }
                catch (Exception e) {
                    String message = String.format("Unable to create bzip2 output stream for file %s", destination);
                    throw new RuntimeException(message, e);
                }
            }
        };
    }

    public InputStream read() {
        InputStream is = this.resource.read();
        try {
            byte[] skip = new byte[2];
            is.read(skip);
            return new CBZip2InputStream(is);
        }
        catch (Exception e) {
            String message = String.format("Unable to create bzip2 input stream for resource %s.", this.resource.getDisplayName());
            throw new ResourceException(message, e);
        }
    }
}

