/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.Factory;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.id.IdGenerator;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.ConnectionAcceptor;
import org.gradle.messaging.remote.MessagingServer;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.process.internal.DefaultWorkerProcess;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleFactory;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.WorkerProcess;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.process.internal.child.ApplicationClassesInIsolatedClassLoaderWorkerFactory;
import org.gradle.process.internal.child.ApplicationClassesInSystemClassLoaderWorkerFactory;
import org.gradle.process.internal.child.WorkerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerProcessFactory
implements Factory<WorkerProcessBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkerProcessFactory.class);
    private final LogLevel workerLogLevel;
    private final MessagingServer server;
    private final IdGenerator<?> idGenerator;
    private final File gradleUserHomeDir;
    private final ExecHandleFactory execHandleFactory;
    private final ApplicationClassesInSystemClassLoaderWorkerFactory systemClassLoaderWorkerFactory;
    private final ApplicationClassesInIsolatedClassLoaderWorkerFactory isolatedClassLoaderWorkerFactory;

    public DefaultWorkerProcessFactory(LogLevel workerLogLevel, MessagingServer server, ClassPathRegistry classPathRegistry, IdGenerator<?> idGenerator, File gradleUserHomeDir, TemporaryFileProvider temporaryFileProvider, ExecHandleFactory execHandleFactory) {
        this.workerLogLevel = workerLogLevel;
        this.server = server;
        this.idGenerator = idGenerator;
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.execHandleFactory = execHandleFactory;
        this.isolatedClassLoaderWorkerFactory = new ApplicationClassesInIsolatedClassLoaderWorkerFactory(classPathRegistry);
        this.systemClassLoaderWorkerFactory = new ApplicationClassesInSystemClassLoaderWorkerFactory(classPathRegistry, temporaryFileProvider);
    }

    public WorkerProcessBuilder create() {
        return new DefaultWorkerProcessBuilder();
    }

    private class DefaultWorkerProcessBuilder
    extends WorkerProcessBuilder {
        public DefaultWorkerProcessBuilder() {
            super(DefaultWorkerProcessFactory.this.execHandleFactory.newJavaExec());
            this.setLogLevel(DefaultWorkerProcessFactory.this.workerLogLevel);
            this.setGradleUserHomeDir(DefaultWorkerProcessFactory.this.gradleUserHomeDir);
        }

        public WorkerProcess build() {
            if (this.getWorker() == null) {
                throw new IllegalStateException("No worker action specified for this worker process.");
            }
            final DefaultWorkerProcess workerProcess = new DefaultWorkerProcess(120, TimeUnit.SECONDS);
            ConnectionAcceptor acceptor = DefaultWorkerProcessFactory.this.server.accept((Action)new Action<ObjectConnection>(){

                public void execute(ObjectConnection connection) {
                    workerProcess.onConnect(connection);
                }
            });
            workerProcess.startAccepting(acceptor);
            Address localAddress = acceptor.getAddress();
            List implementationClassPath = ClasspathUtil.getClasspath((ClassLoader)this.getWorker().getClass().getClassLoader());
            Object id = DefaultWorkerProcessFactory.this.idGenerator.generateId();
            String displayName = this.getBaseName() + " " + id;
            WorkerFactory workerFactory = this.isLoadApplicationInSystemClassLoader() ? DefaultWorkerProcessFactory.this.systemClassLoaderWorkerFactory : DefaultWorkerProcessFactory.this.isolatedClassLoaderWorkerFactory;
            LOGGER.debug("Creating {}", (Object)displayName);
            LOGGER.debug("Using application classpath {}", this.getApplicationClasspath());
            LOGGER.debug("Using implementation classpath {}", (Object)implementationClassPath);
            JavaExecHandleBuilder javaCommand = this.getJavaCommand();
            javaCommand.setDisplayName(displayName);
            workerFactory.prepareJavaCommand(id, displayName, this, implementationClassPath, localAddress, javaCommand);
            javaCommand.args("'" + displayName + "'");
            ExecHandle execHandle = javaCommand.build();
            workerProcess.setExecHandle(execHandle);
            return workerProcess;
        }
    }
}

