/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Date;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.repository.Proxy;
import org.apache.maven.repository.legacy.UpdateCheckManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=UpdateCheckManager.class)
public class DefaultUpdateCheckManager
extends AbstractLogEnabled
implements UpdateCheckManager {
    private static final String ERROR_KEY_SUFFIX = ".error";
    public static final String LAST_UPDATE_TAG = ".lastUpdated";
    private static final String TOUCHFILE_NAME = "resolver-status.properties";

    public DefaultUpdateCheckManager() {
    }

    public DefaultUpdateCheckManager(Logger logger) {
        this.enableLogging(logger);
    }

    public boolean isUpdateRequired(Artifact artifact, ArtifactRepository repository) {
        Date lastCheckDate;
        ArtifactRepositoryPolicy policy;
        File file = artifact.getFile();
        ArtifactRepositoryPolicy artifactRepositoryPolicy = policy = artifact.isSnapshot() ? repository.getSnapshots() : repository.getReleases();
        if (!policy.isEnabled()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Skipping update check for " + artifact + " (" + file + ") from " + repository.getId() + " (" + repository.getUrl() + ")");
            }
            return false;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Determining update check for " + artifact + " (" + file + ") from " + repository.getId() + " (" + repository.getUrl() + ")");
        }
        if (file == null) {
            return true;
        }
        if (file.exists()) {
            lastCheckDate = new Date(file.lastModified());
        } else {
            File touchfile = this.getTouchfile(artifact);
            lastCheckDate = this.readLastUpdated(touchfile, this.getRepositoryKey(repository));
        }
        return lastCheckDate == null || policy.checkOutOfDate(lastCheckDate);
    }

    public boolean isUpdateRequired(RepositoryMetadata metadata, ArtifactRepository repository, File file) {
        ArtifactRepositoryPolicy policy = metadata.getPolicy(repository);
        if (!policy.isEnabled()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Skipping update check for " + metadata.getKey() + " (" + file + ") from " + repository.getId() + " (" + repository.getUrl() + ")");
            }
            return false;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Determining update check for " + metadata.getKey() + " (" + file + ") from " + repository.getId() + " (" + repository.getUrl() + ")");
        }
        if (file == null) {
            return true;
        }
        Date lastCheckDate = this.readLastUpdated(metadata, repository, file);
        return lastCheckDate == null || policy.checkOutOfDate(lastCheckDate);
    }

    private Date readLastUpdated(RepositoryMetadata metadata, ArtifactRepository repository, File file) {
        File touchfile = this.getTouchfile(metadata, file);
        String key = this.getMetadataKey(repository, file);
        return this.readLastUpdated(touchfile, key);
    }

    public String getError(Artifact artifact, ArtifactRepository repository) {
        File touchFile = this.getTouchfile(artifact);
        return this.getError(touchFile, this.getRepositoryKey(repository));
    }

    public void touch(Artifact artifact, ArtifactRepository repository, String error) {
        File file = artifact.getFile();
        File touchfile = this.getTouchfile(artifact);
        if (file.exists()) {
            touchfile.delete();
        } else {
            this.writeLastUpdated(touchfile, this.getRepositoryKey(repository), error);
        }
    }

    public void touch(RepositoryMetadata metadata, ArtifactRepository repository, File file) {
        File touchfile = this.getTouchfile(metadata, file);
        String key = this.getMetadataKey(repository, file);
        this.writeLastUpdated(touchfile, key, null);
    }

    String getMetadataKey(ArtifactRepository repository, File file) {
        return repository.getId() + '.' + file.getName() + LAST_UPDATE_TAG;
    }

    String getRepositoryKey(ArtifactRepository repository) {
        Authentication auth;
        StringBuilder buffer = new StringBuilder(256);
        Proxy proxy = repository.getProxy();
        if (proxy != null) {
            if (proxy.getUserName() != null) {
                int hash = (proxy.getUserName() + proxy.getPassword()).hashCode();
                buffer.append(hash).append('@');
            }
            buffer.append(proxy.getHost()).append(':').append(proxy.getPort()).append('>');
        }
        if ((auth = repository.getAuthentication()) != null) {
            int hash = (auth.getUsername() + auth.getPassword()).hashCode();
            buffer.append(hash).append('@');
        }
        buffer.append(repository.getUrl());
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLastUpdated(File touchfile, String key, String error) {
        String string = touchfile.getAbsolutePath().intern();
        synchronized (string) {
            if (!touchfile.getParentFile().exists() && !touchfile.getParentFile().mkdirs()) {
                this.getLogger().debug("Failed to create directory: " + touchfile.getParent() + " for tracking artifact metadata resolution.");
                return;
            }
            AbstractInterruptibleChannel channel = null;
            FileLock lock = null;
            try {
                Properties props = new Properties();
                channel = new RandomAccessFile(touchfile, "rw").getChannel();
                lock = ((FileChannel)channel).lock(0L, ((FileChannel)channel).size(), false);
                if (touchfile.canRead()) {
                    this.getLogger().debug("Reading resolution-state from: " + touchfile);
                    ByteBuffer buffer = ByteBuffer.allocate((int)((FileChannel)channel).size());
                    ((FileChannel)channel).read(buffer);
                    buffer.flip();
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer.array());
                    props.load(stream);
                }
                props.setProperty(key, Long.toString(System.currentTimeMillis()));
                if (error != null) {
                    props.setProperty(key + ERROR_KEY_SUFFIX, error);
                } else {
                    props.remove(key + ERROR_KEY_SUFFIX);
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                this.getLogger().debug("Writing resolution-state to: " + touchfile);
                props.store(stream, "Last modified on: " + new Date());
                byte[] data = stream.toByteArray();
                ByteBuffer buffer = ByteBuffer.allocate(data.length);
                buffer.put(data);
                buffer.flip();
                ((FileChannel)channel).position(0L);
                ((FileChannel)channel).write(buffer);
            }
            catch (IOException e) {
                this.getLogger().debug("Failed to record lastUpdated information for resolution.\nFile: " + touchfile.toString() + "; key: " + key, (Throwable)e);
            }
            finally {
                if (lock != null) {
                    try {
                        lock.release();
                    }
                    catch (IOException e) {
                        this.getLogger().debug("Error releasing exclusive lock for resolution tracking file: " + touchfile, (Throwable)e);
                    }
                }
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        this.getLogger().debug("Error closing FileChannel for resolution tracking file: " + touchfile, (Throwable)e);
                    }
                }
            }
        }
    }

    Date readLastUpdated(File touchfile, String key) {
        String rawVal;
        this.getLogger().debug("Searching for " + key + " in resolution tracking file.");
        Properties props = this.read(touchfile);
        if (props != null && (rawVal = props.getProperty(key)) != null) {
            try {
                return new Date(Long.parseLong(rawVal));
            }
            catch (NumberFormatException e) {
                this.getLogger().debug("Cannot parse lastUpdated date: '" + rawVal + "'. Ignoring.", (Throwable)e);
            }
        }
        return null;
    }

    private String getError(File touchFile, String key) {
        Properties props = this.read(touchFile);
        if (props != null) {
            return props.getProperty(key + ERROR_KEY_SUFFIX);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties read(File touchfile) {
        if (!touchfile.canRead()) {
            this.getLogger().debug("Skipped unreadable resolution tracking file " + touchfile);
            return null;
        }
        String string = touchfile.getAbsolutePath().intern();
        synchronized (string) {
            FileInputStream stream = null;
            FileLock lock = null;
            AbstractInterruptibleChannel channel = null;
            try {
                Properties props = new Properties();
                stream = new FileInputStream(touchfile);
                channel = stream.getChannel();
                lock = ((FileChannel)channel).lock(0L, ((FileChannel)channel).size(), true);
                this.getLogger().debug("Reading resolution-state from: " + touchfile);
                props.load(stream);
                Properties properties = props;
                return properties;
            }
            catch (IOException e) {
                this.getLogger().debug("Failed to read resolution tracking file " + touchfile, (Throwable)e);
                Properties properties2 = null;
                return properties2;
            }
            finally {
                if (lock != null) {
                    try {
                        lock.release();
                    }
                    catch (IOException e4) {
                        this.getLogger().debug("Error releasing shared lock for resolution tracking file: " + touchfile, (Throwable)e4);
                    }
                }
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e5) {
                        this.getLogger().debug("Error closing FileChannel for resolution tracking file: " + touchfile, (Throwable)e5);
                    }
                }
            }
        }
    }

    File getTouchfile(Artifact artifact) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(artifact.getArtifactId());
        sb.append('-').append(artifact.getBaseVersion());
        if (artifact.getClassifier() != null) {
            sb.append('-').append(artifact.getClassifier());
        }
        sb.append('.').append(artifact.getType()).append(LAST_UPDATE_TAG);
        return new File(artifact.getFile().getParentFile(), sb.toString());
    }

    File getTouchfile(RepositoryMetadata metadata, File file) {
        return new File(file.getParent(), TOUCHFILE_NAME);
    }
}

