/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.deployer;

import groovy.lang.Closure;
import java.io.File;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.maven.MavenDeployment;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.artifacts.maven.MavenResolver;
import org.gradle.api.artifacts.maven.PomFilterContainer;
import org.gradle.api.artifacts.maven.PublishFilter;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.api.internal.artifacts.repositories.AbstractArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.publication.maven.internal.ArtifactPomContainer;
import org.gradle.api.publication.maven.internal.PomFilter;
import org.gradle.api.publication.maven.internal.action.MavenPublishAction;
import org.gradle.internal.component.external.model.IvyModuleArtifactPublishMetaData;
import org.gradle.internal.component.external.model.IvyModulePublishMetaData;
import org.gradle.listener.ActionBroadcast;
import org.gradle.logging.LoggingManagerInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMavenResolver
extends AbstractArtifactRepository
implements MavenResolver,
ModuleVersionPublisher,
ResolutionAwareRepository,
PublicationAwareRepository {
    private ArtifactPomContainer artifactPomContainer;
    private PomFilterContainer pomFilterContainer;
    private LoggingManagerInternal loggingManager;
    private final ActionBroadcast<MavenDeployment> beforeDeploymentActions = new ActionBroadcast();
    private final MavenSettingsProvider mavenSettingsProvider;
    private final LocalMavenRepositoryLocator mavenRepositoryLocator;

    public AbstractMavenResolver(PomFilterContainer pomFilterContainer, ArtifactPomContainer artifactPomContainer, LoggingManagerInternal loggingManager, MavenSettingsProvider mavenSettingsProvider, LocalMavenRepositoryLocator mavenRepositoryLocator) {
        this.pomFilterContainer = pomFilterContainer;
        this.artifactPomContainer = artifactPomContainer;
        this.loggingManager = loggingManager;
        this.mavenSettingsProvider = mavenSettingsProvider;
        this.mavenRepositoryLocator = mavenRepositoryLocator;
    }

    public ConfiguredModuleComponentRepository createResolver() {
        throw new UnsupportedOperationException("A Maven deployer cannot be used to resolve dependencies. It can only be used to publish artifacts.");
    }

    public ModuleVersionPublisher createPublisher() {
        return this;
    }

    protected abstract MavenPublishAction createPublishAction(File var1, LocalMavenRepositoryLocator var2);

    public void publish(IvyModulePublishMetaData moduleVersion) {
        for (IvyModuleArtifactPublishMetaData artifact : moduleVersion.getArtifacts()) {
            this.collectArtifact(artifact.toIvyArtifact(), artifact.getFile());
        }
        this.publish();
    }

    private void collectArtifact(Artifact artifact, File src) {
        if (this.isIgnorable(artifact)) {
            return;
        }
        this.getArtifactPomContainer().addArtifact(artifact, src);
    }

    private boolean isIgnorable(Artifact artifact) {
        return artifact.getType().equals("ivy");
    }

    private void publish() {
        Set<MavenDeployment> mavenDeployments = this.getArtifactPomContainer().createDeployableFilesInfos();
        for (MavenDeployment mavenDeployment : mavenDeployments) {
            File pomFile = mavenDeployment.getPomArtifact().getFile();
            MavenPublishAction publishAction = this.createPublishAction(pomFile, this.mavenRepositoryLocator);
            this.beforeDeploymentActions.execute((Object)mavenDeployment);
            this.addArtifacts(publishAction, mavenDeployment);
            this.execute(publishAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(MavenPublishAction publishAction) {
        this.loggingManager.captureStandardOutput(LogLevel.INFO).start();
        try {
            publishAction.publish();
        }
        finally {
            this.loggingManager.stop();
        }
    }

    private void addArtifacts(MavenPublishAction publishAction, MavenDeployment mavenDeployment) {
        if (mavenDeployment.getMainArtifact() != null) {
            publishAction.setMainArtifact(mavenDeployment.getMainArtifact().getFile());
        }
        for (PublishArtifact classifierArtifact : mavenDeployment.getAttachedArtifacts()) {
            publishAction.addAdditionalArtifact(classifierArtifact.getFile(), classifierArtifact.getType(), classifierArtifact.getClassifier());
        }
    }

    public ArtifactPomContainer getArtifactPomContainer() {
        return this.artifactPomContainer;
    }

    @Override
    public Object getSettings() {
        try {
            return this.mavenSettingsProvider.buildSettings();
        }
        catch (SettingsBuildingException e) {
            throw new GradleException("Could not load Maven Settings", (Throwable)e);
        }
    }

    @Override
    public PublishFilter getFilter() {
        return this.pomFilterContainer.getFilter();
    }

    @Override
    public void setFilter(PublishFilter defaultFilter) {
        this.pomFilterContainer.setFilter(defaultFilter);
    }

    @Override
    public MavenPom getPom() {
        return this.pomFilterContainer.getPom();
    }

    @Override
    public void setPom(MavenPom defaultPom) {
        this.pomFilterContainer.setPom(defaultPom);
    }

    @Override
    public MavenPom addFilter(String name, PublishFilter publishFilter) {
        return this.pomFilterContainer.addFilter(name, publishFilter);
    }

    @Override
    public MavenPom addFilter(String name, Closure filter) {
        return this.pomFilterContainer.addFilter(name, filter);
    }

    @Override
    public void filter(Closure filter) {
        this.pomFilterContainer.filter(filter);
    }

    @Override
    public PublishFilter filter(String name) {
        return this.pomFilterContainer.filter(name);
    }

    @Override
    public MavenPom pom(String name) {
        return this.pomFilterContainer.pom(name);
    }

    @Override
    public MavenPom pom(Closure configureClosure) {
        return this.pomFilterContainer.pom(configureClosure);
    }

    @Override
    public MavenPom pom(String name, Closure configureClosure) {
        return this.pomFilterContainer.pom(name, configureClosure);
    }

    @Override
    public Iterable<PomFilter> getActivePomFilters() {
        return this.pomFilterContainer.getActivePomFilters();
    }

    public PomFilterContainer getPomFilterContainer() {
        return this.pomFilterContainer;
    }

    @Override
    public void beforeDeployment(Action<? super MavenDeployment> action) {
        this.beforeDeploymentActions.add(action);
    }

    @Override
    public void beforeDeployment(Closure action) {
        this.beforeDeploymentActions.add((Action)new ClosureBackedAction(action));
    }
}

