/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.registry;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.PersistentStateCache;
import org.gradle.cache.internal.FileIntegrityViolationSuppressingPersistentStateCacheDecorator;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.OnDemandFileAccess;
import org.gradle.cache.internal.SimpleStateCache;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.DaemonRegistryContent;
import org.gradle.messaging.remote.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentDaemonRegistry
implements DaemonRegistry {
    private final PersistentStateCache<DaemonRegistryContent> cache;
    private final Lock lock = new ReentrantLock();
    private final File registryFile;
    private static final Logger LOGGER = Logging.getLogger(PersistentDaemonRegistry.class);

    public PersistentDaemonRegistry(File registryFile, FileLockManager fileLockManager) {
        this.registryFile = registryFile;
        this.cache = new FileIntegrityViolationSuppressingPersistentStateCacheDecorator<DaemonRegistryContent>(new SimpleStateCache(registryFile, new OnDemandFileAccess(registryFile, "daemon addresses registry", fileLockManager), new DefaultSerializer()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DaemonInfo> getAll() {
        this.lock.lock();
        try {
            DaemonRegistryContent content = this.cache.get();
            if (content == null) {
                LinkedList<DaemonInfo> linkedList = new LinkedList<DaemonInfo>();
                return linkedList;
            }
            List<DaemonInfo> list = content.getInfos();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DaemonInfo> getIdle() {
        this.lock.lock();
        try {
            LinkedList<DaemonInfo> out = new LinkedList<DaemonInfo>();
            List<DaemonInfo> all = this.getAll();
            for (DaemonInfo d : all) {
                if (!d.isIdle()) continue;
                out.add(d);
            }
            LinkedList<DaemonInfo> linkedList = out;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DaemonInfo> getBusy() {
        this.lock.lock();
        try {
            LinkedList<DaemonInfo> out = new LinkedList<DaemonInfo>();
            List<DaemonInfo> all = this.getAll();
            for (DaemonInfo d : all) {
                if (d.isIdle()) continue;
                out.add(d);
            }
            LinkedList<DaemonInfo> linkedList = out;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(final Address address) {
        this.lock.lock();
        LOGGER.debug("Removing daemon address: {}", address);
        try {
            this.cache.update(new PersistentStateCache.UpdateAction<DaemonRegistryContent>(){

                @Override
                public DaemonRegistryContent update(DaemonRegistryContent oldValue) {
                    if (oldValue == null) {
                        return oldValue;
                    }
                    oldValue.removeInfo(address);
                    return oldValue;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markBusy(final Address address) {
        this.lock.lock();
        LOGGER.debug("Marking busy by address: {}", address);
        try {
            this.cache.update(new PersistentStateCache.UpdateAction<DaemonRegistryContent>(){

                @Override
                public DaemonRegistryContent update(DaemonRegistryContent oldValue) {
                    DaemonInfo daemonInfo;
                    DaemonInfo daemonInfo2 = daemonInfo = oldValue != null ? oldValue.getInfo(address) : null;
                    if (daemonInfo != null) {
                        daemonInfo.setIdle(false);
                    }
                    return oldValue;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markIdle(final Address address) {
        this.lock.lock();
        LOGGER.debug("Marking idle by address: {}", address);
        try {
            this.cache.update(new PersistentStateCache.UpdateAction<DaemonRegistryContent>(){

                @Override
                public DaemonRegistryContent update(DaemonRegistryContent oldValue) {
                    DaemonInfo daemonInfo;
                    DaemonInfo daemonInfo2 = daemonInfo = oldValue != null ? oldValue.getInfo(address) : null;
                    if (daemonInfo != null) {
                        daemonInfo.setIdle(true);
                    }
                    return oldValue;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(final Address address, final DaemonContext daemonContext, final String password, final boolean idle) {
        this.lock.lock();
        LOGGER.debug("Storing daemon address: {}, context: {}", address, daemonContext);
        try {
            this.cache.update(new PersistentStateCache.UpdateAction<DaemonRegistryContent>(){

                @Override
                public DaemonRegistryContent update(DaemonRegistryContent oldValue) {
                    if (oldValue == null) {
                        oldValue = new DaemonRegistryContent();
                    }
                    DaemonInfo daemonInfo = new DaemonInfo(address, daemonContext, password, idle);
                    oldValue.setStatus(address, daemonInfo);
                    return oldValue;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return String.format("PersistentDaemonRegistry[file=%s]", this.registryFile);
    }
}

