/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.exec.BuildCommandOnly;
import org.gradle.logging.internal.LoggingOutputInternal;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;

public class LogToClient
extends BuildCommandOnly {
    public static final String DISABLE_OUTPUT = "org.gradle.daemon.disable-output";
    private static final Logger LOGGER = Logging.getLogger(LogToClient.class);
    private final LoggingOutputInternal loggingOutput;
    private final DaemonDiagnostics diagnostics;

    public LogToClient(LoggingOutputInternal loggingOutput, DaemonDiagnostics diagnostics) {
        this.loggingOutput = loggingOutput;
        this.diagnostics = diagnostics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBuild(final DaemonCommandExecution execution, Build build) {
        if (Boolean.getBoolean(DISABLE_OUTPUT)) {
            execution.proceed();
            return;
        }
        final LogLevel buildLogLevel = build.getParameters().getLogLevel();
        OutputEventListener listener = new OutputEventListener(){

            public void onOutput(OutputEvent event) {
                try {
                    if (event.getLogLevel() != null && event.getLogLevel().compareTo(buildLogLevel) >= 0) {
                        execution.getConnection().logEvent(event);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        LOGGER.debug("About to start relaying all logs to the client via the connection.");
        this.loggingOutput.addOutputEventListener(listener);
        try {
            LOGGER.info("{}{}). The daemon log file: {}", "The client will now receive all logging from the daemon (pid: ", this.diagnostics.getPid(), this.diagnostics.getDaemonLog());
            execution.proceed();
        }
        finally {
            this.loggingOutput.removeOutputEventListener(listener);
        }
    }
}

