/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputStore;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestOutputListener;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.messaging.remote.internal.PlaceholderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestReportDataCollector
implements TestListener,
TestOutputListener {
    private final Map<String, TestClassResult> results;
    private final TestOutputStore.Writer outputWriter;
    private final Map<TestDescriptor, TestMethodResult> currentTestMethods = new HashMap<TestDescriptor, TestMethodResult>();
    private long internalIdCounter = 1L;

    public TestReportDataCollector(Map<String, TestClassResult> results, TestOutputStore.Writer outputWriter) {
        this.results = results;
        this.outputWriter = outputWriter;
    }

    public void beforeSuite(TestDescriptor suite) {
    }

    public void afterSuite(TestDescriptor suite, TestResult result) {
        if (result.getResultType() == TestResult.ResultType.FAILURE && !result.getExceptions().isEmpty()) {
            TestMethodResult methodResult = new TestMethodResult(this.internalIdCounter++, "execution failure");
            for (Throwable throwable : result.getExceptions()) {
                methodResult.addFailure(this.failureMessage(throwable), this.stackTrace(throwable), this.exceptionClassName(throwable));
            }
            methodResult.completed(result);
            TestClassResult classResult = new TestClassResult(this.internalIdCounter++, suite.getName(), result.getStartTime());
            classResult.add(methodResult);
            this.results.put(suite.getName(), classResult);
        }
    }

    public void beforeTest(TestDescriptor testDescriptor) {
        TestMethodResult methodResult = new TestMethodResult(this.internalIdCounter++, testDescriptor.getName());
        this.currentTestMethods.put(testDescriptor, methodResult);
    }

    public void afterTest(TestDescriptor testDescriptor, TestResult result) {
        String className = testDescriptor.getClassName();
        TestMethodResult methodResult = this.currentTestMethods.remove(testDescriptor).completed(result);
        for (Throwable throwable : result.getExceptions()) {
            methodResult.addFailure(this.failureMessage(throwable), this.stackTrace(throwable), this.exceptionClassName(throwable));
        }
        TestClassResult classResult = this.results.get(className);
        if (classResult == null) {
            classResult = new TestClassResult(this.internalIdCounter++, className, result.getStartTime());
            this.results.put(className, classResult);
        } else if (classResult.getStartTime() == 0L) {
            classResult.setStartTime(result.getStartTime());
        }
        classResult.add(methodResult);
    }

    private String failureMessage(Throwable throwable) {
        try {
            return throwable.toString();
        }
        catch (Throwable t) {
            String exceptionClassName = this.exceptionClassName(throwable);
            return String.format("Could not determine failure message for exception of type %s: %s", exceptionClassName, t);
        }
    }

    private String exceptionClassName(Throwable throwable) {
        return throwable instanceof PlaceholderException ? ((PlaceholderException)throwable).getExceptionClassName() : throwable.getClass().getName();
    }

    private String stackTrace(Throwable throwable) {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            throwable.printStackTrace(writer);
            writer.close();
            return stringWriter.toString();
        }
        catch (Throwable t) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            t.printStackTrace(writer);
            writer.close();
            return stringWriter.toString();
        }
    }

    public void onOutput(TestDescriptor testDescriptor, TestOutputEvent outputEvent) {
        TestMethodResult methodResult;
        String className = testDescriptor.getClassName();
        if (className == null) {
            return;
        }
        TestClassResult classResult = this.results.get(className);
        if (classResult == null) {
            classResult = new TestClassResult(this.internalIdCounter++, className, 0L);
            this.results.put(className, classResult);
        }
        if ((methodResult = this.currentTestMethods.get(testDescriptor)) == null) {
            this.outputWriter.onOutput(classResult.getId(), outputEvent);
        } else {
            this.outputWriter.onOutput(classResult.getId(), methodResult.getId(), outputEvent);
        }
    }
}

