/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.api.CodePosition;
import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.TabbedPane;
import jadx.gui.utils.Position;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import org.fife.ui.rsyntaxtextarea.LinkGenerator;
import org.fife.ui.rsyntaxtextarea.LinkGeneratorResult;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContentArea
extends RSyntaxTextArea {
    private static final Logger LOG = LoggerFactory.getLogger(ContentArea.class);
    private static final long serialVersionUID = 6312736869579635796L;
    public static final Color BACKGROUND = new Color(0xFAFAFA);
    public static final Color JUMP_TOKEN_FGD = new Color(4791201);
    private final ContentPanel contentPanel;
    private final JNode node;

    ContentArea(ContentPanel panel) {
        this.contentPanel = panel;
        this.node = panel.getNode();
        this.setMarkOccurrences(true);
        this.setBackground(BACKGROUND);
        this.setAntiAliasingEnabled(true);
        this.setEditable(false);
        this.loadSettings();
        Caret caret = this.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(2);
        }
        caret.setVisible(true);
        this.setSyntaxEditingStyle(this.node.getSyntaxName());
        if (this.node instanceof JClass) {
            SyntaxScheme scheme = this.getSyntaxScheme();
            scheme.getStyle((int)8).foreground = Color.BLACK;
            this.setHyperlinksEnabled(true);
            CodeLinkGenerator codeLinkProcessor = new CodeLinkGenerator((JClass)this.node);
            this.setLinkGenerator(codeLinkProcessor);
            this.addHyperlinkListener(codeLinkProcessor);
        }
        this.setText(this.node.getContent());
    }

    public void loadSettings() {
        JadxSettings settings = this.contentPanel.getTabbedPane().getMainWindow().getSettings();
        this.setFont(settings.getFont());
    }

    private boolean isJumpToken(Token token) {
        if (token.getType() == 20) {
            Position pos;
            char ch;
            if (token.length() == 1 && ((ch = token.getTextArray()[token.getTextOffset()]) == '.' || ch == ',' || ch == ';')) {
                return false;
            }
            if (this.node instanceof JClass && (pos = ContentArea.getPosition((JClass)this.node, this, token.getOffset())) != null) {
                return true;
            }
        }
        return false;
    }

    public Color getForegroundForToken(Token t) {
        if (this.isJumpToken(t)) {
            return JUMP_TOKEN_FGD;
        }
        return super.getForegroundForToken(t);
    }

    static Position getPosition(JClass jCls, RSyntaxTextArea textArea, int offset) {
        try {
            int line = textArea.getLineOfOffset(offset);
            int lineOffset = offset - textArea.getLineStartOffset(line);
            CodePosition pos = jCls.getCls().getDefinitionPosition(line + 1, lineOffset + 1);
            if (pos != null && pos.isSet()) {
                return new Position(pos);
            }
        }
        catch (BadLocationException e) {
            LOG.error("Can't get line by offset", (Throwable)e);
        }
        return null;
    }

    Position getCurrentPosition() {
        return new Position(this.node, this.getCaretLineNumber() + 1);
    }

    Integer getSourceLine(int line) {
        return this.node.getSourceLine(line);
    }

    void scrollToLine(int line) {
        int lineNum = line - 1;
        if (lineNum < 0) {
            lineNum = 0;
        }
        this.setCaretAtLine(lineNum);
        this.centerCurrentLine();
        this.forceCurrentLineHighlightRepaint();
    }

    public void centerCurrentLine() {
        JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, (Component)((Object)this));
        if (viewport == null) {
            return;
        }
        try {
            Rectangle r = this.modelToView(this.getCaretPosition());
            if (r == null) {
                return;
            }
            int extentHeight = viewport.getExtentSize().height;
            Dimension viewSize = viewport.getViewSize();
            if (viewSize == null) {
                return;
            }
            int viewHeight = viewSize.height;
            int y = Math.max(0, r.y - extentHeight / 2);
            y = Math.min(y, viewHeight - extentHeight);
            viewport.setViewPosition(new Point(0, y));
        }
        catch (BadLocationException e) {
            LOG.debug("Can't center current line", (Throwable)e);
        }
    }

    private void setCaretAtLine(int line) {
        try {
            this.setCaretPosition(this.getLineStartOffset(line));
        }
        catch (BadLocationException e) {
            LOG.debug("Can't scroll to {}", (Object)line, (Object)e);
        }
    }

    private class CodeLinkGenerator
    implements LinkGenerator,
    HyperlinkListener {
        private final JClass jCls;

        public CodeLinkGenerator(JClass cls) {
            this.jCls = cls;
        }

        public LinkGeneratorResult isLinkAtOffset(RSyntaxTextArea textArea, int offset) {
            try {
                Token token = textArea.modelToToken(offset);
                if (token == null) {
                    return null;
                }
                final int sourceOffset = token.getOffset();
                final Position defPos = ContentArea.getPosition(this.jCls, textArea, sourceOffset);
                if (defPos == null) {
                    return null;
                }
                return new LinkGeneratorResult(){

                    public HyperlinkEvent execute() {
                        return new HyperlinkEvent(defPos, HyperlinkEvent.EventType.ACTIVATED, null, defPos.getNode().makeLongString());
                    }

                    public int getSourceOffset() {
                        return sourceOffset;
                    }
                };
            }
            catch (Exception e) {
                LOG.error("isLinkAtOffset error", (Throwable)e);
                return null;
            }
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            Object obj = e.getSource();
            if (obj instanceof Position) {
                Position pos = (Position)obj;
                LOG.debug("Code jump to: {}", (Object)pos);
                TabbedPane tabbedPane = ContentArea.this.contentPanel.getTabbedPane();
                tabbedPane.getJumpManager().addPosition(ContentArea.this.getCurrentPosition());
                tabbedPane.getJumpManager().addPosition(pos);
                tabbedPane.showCode(pos);
            }
        }
    }
}

