/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.gui.treemodel.JNode;
import jadx.gui.ui.ContentArea;
import jadx.gui.ui.LineNumbers;
import jadx.gui.ui.SearchBar;
import jadx.gui.ui.TabbedPane;
import jadx.gui.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

class ContentPanel
extends JPanel {
    private static final long serialVersionUID = 5310536092010045565L;
    private final TabbedPane tabbedPane;
    private final JNode node;
    private final SearchBar searchBar;
    private final ContentArea contentArea;
    private final JScrollPane scrollPane;

    ContentPanel(TabbedPane panel, JNode node) {
        this.tabbedPane = panel;
        this.node = node;
        this.contentArea = new ContentArea(this);
        this.searchBar = new SearchBar(this.contentArea);
        this.scrollPane = new JScrollPane((Component)((Object)this.contentArea));
        this.scrollPane.setRowHeaderView(new LineNumbers(this.contentArea));
        this.setLayout(new BorderLayout());
        this.add((Component)this.searchBar, "North");
        this.add(this.scrollPane);
        KeyStroke key = KeyStroke.getKeyStroke(70, 2);
        Utils.addKeyBinding((JComponent)((Object)this.contentArea), key, "SearchAction", new SearchAction());
    }

    TabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    JNode getNode() {
        return this.node;
    }

    SearchBar getSearchBar() {
        return this.searchBar;
    }

    ContentArea getContentArea() {
        return this.contentArea;
    }

    JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    private class SearchAction
    extends AbstractAction {
        private static final long serialVersionUID = 8650568214755387093L;

        private SearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContentPanel.this.searchBar.toggle();
        }
    }
}

