/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DropMode;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.ThreadUtilities;

public class BufferSwitcher
extends JComboBox {
    private final EditPane editPane;
    private boolean updating;
    private Object itemSelectedBefore;
    public static final DataFlavor BufferDataFlavor = new DataFlavor(BufferTransferableData.class, "application/x-java-jvm-local-objectref");

    public BufferSwitcher(final EditPane editPane) {
        this.editPane = editPane;
        this.setTransferHandler(new ComboBoxTransferHandler(this));
        this.setRenderer(new BufferCellRenderer());
        this.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                BufferSwitcher.this.itemSelectedBefore = BufferSwitcher.this.getSelectedItem();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                Buffer buffer;
                if (!BufferSwitcher.this.updating && (buffer = (Buffer)BufferSwitcher.this.getSelectedItem()) != null) {
                    editPane.setBuffer(buffer);
                }
                editPane.getTextArea().requestFocus();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                BufferSwitcher.this.setSelectedItem(BufferSwitcher.this.itemSelectedBefore);
            }
        });
    }

    public void updateBufferList() {
        final BufferSet bufferSet = this.editPane.getBufferSet();
        if (bufferSet.size() == 0) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BufferSwitcher.this.updating = true;
                BufferSwitcher.this.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
                BufferSwitcher.this.setModel(new DefaultComboBoxModel<Buffer>(bufferSet.getAllBuffers()));
                BufferSwitcher.this.setSelectedItem(BufferSwitcher.this.editPane.getBuffer());
                BufferSwitcher.this.setToolTipText(BufferSwitcher.this.editPane.getBuffer().getPath(true));
                BufferSwitcher.this.addDnD();
                BufferSwitcher.this.updating = false;
            }
        };
        ThreadUtilities.runInDispatchThread(runnable);
    }

    private void addDnD() {
        ComboBoxUI comboBoxUI = this.getUI();
        if (comboBoxUI instanceof BasicComboBoxUI) {
            try {
                Field field = this.getField(comboBoxUI.getClass(), "listBox");
                field.setAccessible(true);
                JList jList = (JList)field.get(comboBoxUI);
                jList.setDragEnabled(true);
                jList.setDropMode(DropMode.INSERT);
                jList.setTransferHandler(new BufferSwitcherTransferHandler());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Field getField(Class clazz, String string) throws NoSuchFieldException {
        if (clazz == null) {
            throw new NoSuchFieldException("Invalid field : " + string);
        }
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return this.getField(clazz.getSuperclass(), string);
        }
    }

    private class BufferSwitcherTransferHandler
    extends TransferHandler {
        private BufferSwitcherTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            BufferTransferableData bufferTransferableData;
            if (!transferSupport.isDataFlavorSupported(BufferDataFlavor)) {
                return false;
            }
            JList.DropLocation dropLocation = (JList.DropLocation)transferSupport.getDropLocation();
            if (dropLocation.getIndex() == -1) {
                return false;
            }
            Transferable transferable = transferSupport.getTransferable();
            try {
                bufferTransferableData = (BufferTransferableData)transferable.getTransferData(BufferDataFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            JComponent jComponent = (JComponent)transferSupport.getComponent();
            EditPane editPane = (EditPane)GUIUtilities.getComponentParent(bufferTransferableData.getSource(), EditPane.class);
            EditPane editPane2 = (EditPane)GUIUtilities.getComponentParent(jComponent, EditPane.class);
            BufferSet.Scope scope = jEdit.getBufferSetManager().getScope();
            View view = editPane.getView();
            View view2 = editPane2.getView();
            switch (scope) {
                case editpane: {
                    return editPane != editPane2;
                }
                case view: {
                    return view != view2;
                }
                case global: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            BufferTransferableData bufferTransferableData;
            if (!transferSupport.isDrop()) {
                return false;
            }
            Transferable transferable = transferSupport.getTransferable();
            try {
                bufferTransferableData = (BufferTransferableData)transferable.getTransferData(BufferDataFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            JComponent jComponent = (JComponent)transferSupport.getComponent();
            EditPane editPane = (EditPane)GUIUtilities.getComponentParent(jComponent, EditPane.class);
            Buffer buffer = bufferTransferableData.getBuffer();
            View view = editPane.getView();
            BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
            if (buffer != null) {
                bufferSetManager.addBuffer(editPane, buffer);
                editPane.setBuffer(buffer);
            }
            view.toFront();
            view.requestFocus();
            editPane.requestFocus();
            return true;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        public void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2) {
                BufferTransferableData bufferTransferableData;
                try {
                    bufferTransferableData = (BufferTransferableData)transferable.getTransferData(BufferDataFlavor);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
                Buffer buffer = bufferTransferableData.getBuffer();
                EditPane editPane = (EditPane)GUIUtilities.getComponentParent(jComponent, EditPane.class);
                BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
                if (buffer != null) {
                    bufferSetManager.removeBuffer(editPane, buffer);
                }
            }
        }

        @Override
        public Transferable createTransferable(JComponent jComponent) {
            JList jList = (JList)jComponent;
            Buffer buffer = (Buffer)jList.getSelectedValue();
            if (buffer == null) {
                return null;
            }
            return new BufferSwitcherTransferable(buffer, jComponent);
        }
    }

    private class BufferTransferableData {
        private final Buffer buffer;
        private final JComponent source;

        public BufferTransferableData(Buffer buffer, JComponent jComponent) {
            this.buffer = buffer;
            this.source = jComponent;
        }

        public Buffer getBuffer() {
            return this.buffer;
        }

        public JComponent getSource() {
            return this.source;
        }
    }

    private class BufferSwitcherTransferable
    implements Transferable {
        private final DataFlavor[] supportedDataFlavor = new DataFlavor[]{BufferDataFlavor};
        private final Buffer buffer;
        private final JComponent source;

        public BufferSwitcherTransferable(Buffer buffer, JComponent jComponent) {
            this.buffer = buffer;
            this.source = jComponent;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.supportedDataFlavor;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return BufferDataFlavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return new BufferTransferableData(this.buffer, this.source);
        }
    }

    private class ComboBoxTransferHandler
    extends TransferHandler {
        JComboBox comboBox;

        public ComboBoxTransferHandler(JComboBox jComboBox) {
            this.comboBox = jComboBox;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            if (!transferSupport.isDataFlavorSupported(BufferDataFlavor)) {
                return false;
            }
            if (!this.comboBox.isPopupVisible()) {
                this.comboBox.showPopup();
            }
            return false;
        }
    }

    static class BufferCellRenderer
    extends DefaultListCellRenderer {
        BufferCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Buffer buffer = (Buffer)object;
            if (buffer == null) {
                this.setIcon(null);
            } else {
                this.setIcon(buffer.getIcon());
                this.setToolTipText(buffer.getPath());
            }
            return this;
        }
    }
}

