/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pdb;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.P3;
import org.jmol.adapter.readers.pdb.PdbReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class JmolDataReader
extends PdbReader {
    private Map<String, float[]> props;
    private String[] residueNames;
    private String[] atomNames;

    @Override
    protected void checkRemark() {
        if (this.line.length() >= 30 && this.line.indexOf("Jmol") == 11) {
            switch ("Ppard".indexOf(this.line.substring(16, 17))) {
                case 0: {
                    this.props = new Hashtable<String, float[]>();
                    this.asc.setInfo("jmolData", this.line);
                    if (this.line.endsWith("#noautobond")) break;
                    this.line = this.line + "#noautobond";
                    break;
                }
                case 1: {
                    int n = this.line.indexOf("[");
                    int n2 = this.line.indexOf("]");
                    if (n < 25 || n2 <= n) {
                        return;
                    }
                    String string = this.line.substring(25, n).trim();
                    this.line = this.line.substring(n + 1, n2).replace(',', ' ');
                    String[] stringArray = this.getTokens();
                    Logger.info("reading " + string + " " + stringArray.length);
                    float[] fArray = new float[stringArray.length];
                    int n3 = fArray.length;
                    while (--n3 >= 0) {
                        fArray[n3] = this.parseFloatStr(stringArray[n3]);
                    }
                    this.props.put(string, fArray);
                    break;
                }
                case 2: {
                    this.line = this.line.substring(27);
                    this.atomNames = this.getTokens();
                    Logger.info("reading atom names " + this.atomNames.length);
                    break;
                }
                case 3: {
                    this.line = this.line.substring(30);
                    this.residueNames = this.getTokens();
                    Logger.info("reading residue names " + this.residueNames.length);
                    break;
                }
                case 4: {
                    Logger.info(this.line);
                    float[] fArray = new float[15];
                    Parser.parseStringInfestedFloatArray(this.line.substring(10).replace('=', ' ').replace('{', ' ').replace('}', ' '), null, fArray);
                    P3 p3 = P3.new3(fArray[0], fArray[1], fArray[2]);
                    P3 p32 = P3.new3(fArray[3], fArray[4], fArray[5]);
                    this.fileScaling = P3.new3(fArray[6], fArray[7], fArray[8]);
                    this.fileOffset = P3.new3(fArray[9], fArray[10], fArray[11]);
                    P3 p33 = P3.new3(fArray[12], fArray[13], fArray[14]);
                    if (p33.x <= 0.0f) {
                        p33.x = 100.0f;
                    }
                    if (p33.y <= 0.0f) {
                        p33.y = 100.0f;
                    }
                    if (p33.z <= 0.0f) {
                        p33.z = 100.0f;
                    }
                    if (this.fileScaling.y == 0.0f) {
                        this.fileScaling.y = 1.0f;
                    }
                    if (this.fileScaling.z == 0.0f) {
                        this.fileScaling.z = 1.0f;
                    }
                    this.setFractionalCoordinates(true);
                    this.latticeCells = new int[3];
                    this.asc.xtalSymmetry = null;
                    this.setUnitCell(p33.x * 2.0f / (p32.x - p3.x), p33.y * 2.0f / (p32.y - p3.y), p33.z * 2.0f / (p32.z == p3.z ? 1.0f : p32.z - p3.z), 90.0f, 90.0f, 90.0f);
                    this.unitCellOffset = P3.newP(p33);
                    this.unitCellOffset.scale(-1.0f);
                    this.getSymmetry();
                    this.symmetry.toFractional(this.unitCellOffset, false);
                    this.unitCellOffset.scaleAdd2(-1.0f, p3, this.unitCellOffset);
                    this.symmetry.setOffsetPt(this.unitCellOffset);
                    this.asc.setInfo("jmolDataScaling", new P3[]{p3, p32, p33});
                    this.doApplySymmetry = true;
                }
            }
        }
        this.checkCurrentLineForScript();
    }

    @Override
    protected void setAdditionalAtomParameters(Atom atom) {
        if (this.residueNames != null && atom.index < this.residueNames.length) {
            atom.group3 = this.residueNames[atom.index];
        }
        if (this.atomNames != null && atom.index < this.atomNames.length) {
            atom.atomName = this.atomNames[atom.index];
        }
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.asc.setCurrentModelInfo("jmolDataProperties", this.props);
        this.finalizeReaderPDB();
    }
}

