/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Orientation;
import org.jmol.util.BSUtil;

public class Model {
    public ModelSet ms;
    public M4 mat4;
    public int modelIndex;
    int fileIndex;
    public boolean isBioModel;
    public boolean isPdbWithMultipleBonds;
    public boolean isModelKit;
    public Chain[] chains = new Chain[8];
    public SymmetryInterface simpleCage;
    public Map<String, Object> dssrCache;
    public Orientation orientation;
    protected Map<String, Object> auxiliaryInfo;
    public Properties properties;
    public SymmetryInterface biosymmetry;
    Map<String, Integer> dataFrames;
    P3 translation;
    int dataSourceFrame = -1;
    public String loadState = "";
    public SB loadScript = new SB();
    protected boolean hasRasmolHBonds;
    public boolean structureTainted;
    public boolean isJmolDataFrame;
    boolean isTrajectory;
    public int trajectoryBaseIndex;
    public int altLocCount;
    int insertionCount;
    public int act = 0;
    private int bondCount = -1;
    protected int chainCount = 0;
    public int groupCount = -1;
    public int hydrogenCount;
    public int moleculeCount;
    int biosymmetryCount;
    public int firstAtomIndex;
    int firstMoleculeIndex;
    public final BS bsAtoms = new BS();
    public final BS bsAtomsDeleted = new BS();
    float defaultRotationRadius;
    public long frameDelay;
    public int selectedTrajectory = -1;
    String jmolData;
    String jmolFrameType;
    public String pdbID;
    private BS bsCheck;

    public Model set(ModelSet modelSet, int n, int n2, String string, Properties properties, Map<String, Object> map) {
        this.ms = modelSet;
        this.dataSourceFrame = this.modelIndex = n;
        this.isTrajectory = n2 >= 0;
        int n3 = this.trajectoryBaseIndex = this.isTrajectory ? n2 : n;
        if (map == null) {
            map = new Hashtable<String, Object>();
        }
        this.auxiliaryInfo = map;
        if (map.containsKey("biosymmetryCount")) {
            this.biosymmetryCount = (Integer)map.get("biosymmetryCount");
            this.biosymmetry = (SymmetryInterface)map.get("biosymmetry");
        }
        this.properties = properties;
        if (string == null) {
            this.jmolFrameType = "modelSet";
        } else {
            this.jmolData = string;
            this.isJmolDataFrame = true;
            map.put("jmolData", string);
            map.put("title", string);
            this.jmolFrameType = string.indexOf("ramachandran") >= 0 ? "ramachandran" : (string.indexOf("quaternion") >= 0 ? "quaternion" : "data");
        }
        return this;
    }

    public int getTrueAtomCount() {
        return this.bsAtoms.cardinality() - this.bsAtomsDeleted.cardinality();
    }

    public boolean isContainedIn(BS bS) {
        if (this.bsCheck == null) {
            this.bsCheck = new BS();
        }
        this.bsCheck.or(bS);
        this.bsCheck.and(this.bsAtoms);
        this.bsCheck.andNot(this.bsAtomsDeleted);
        return this.bsCheck.cardinality() == this.getTrueAtomCount();
    }

    public void resetBoundCount() {
        this.bondCount = -1;
    }

    public int getBondCount() {
        if (this.bondCount >= 0) {
            return this.bondCount;
        }
        Bond[] bondArray = this.ms.bo;
        this.bondCount = 0;
        int n = this.ms.bondCount;
        while (--n >= 0) {
            if (bondArray[n].atom1.mi != this.modelIndex) continue;
            ++this.bondCount;
        }
        return this.bondCount;
    }

    public int getChainCount(boolean bl) {
        if (this.chainCount > 1 && !bl) {
            for (int i = 0; i < this.chainCount; ++i) {
                if (this.chains[i].chainID != 0) continue;
                return this.chainCount - 1;
            }
        }
        return this.chainCount;
    }

    void calcSelectedGroupsCount(BS bS) {
        int n = this.chainCount;
        while (--n >= 0) {
            this.chains[n].calcSelectedGroupsCount(bS);
        }
    }

    public int getGroupCount() {
        if (this.groupCount < 0) {
            this.groupCount = 0;
            int n = this.chainCount;
            while (--n >= 0) {
                this.groupCount += this.chains[n].groupCount;
            }
        }
        return this.groupCount;
    }

    public Chain getChainAt(int n) {
        return n < this.chainCount ? this.chains[n] : null;
    }

    Chain getChain(int n) {
        int n2 = this.chainCount;
        while (--n2 >= 0) {
            Chain chain = this.chains[n2];
            if (chain.chainID != n) continue;
            return chain;
        }
        return null;
    }

    public void fixIndices(int n, int n2, BS bS) {
        this.fixIndicesM(n, n2, bS);
    }

    protected void fixIndicesM(int n, int n2, BS bS) {
        if (this.dataSourceFrame > n) {
            --this.dataSourceFrame;
        }
        if (this.trajectoryBaseIndex > n) {
            --this.trajectoryBaseIndex;
        }
        this.firstAtomIndex -= n2;
        for (int i = 0; i < this.chainCount; ++i) {
            this.chains[i].fixIndices(n2, bS);
        }
        BSUtil.deleteBits(this.bsAtoms, bS);
        BSUtil.deleteBits(this.bsAtomsDeleted, bS);
    }

    public boolean freeze() {
        this.freezeM();
        return false;
    }

    protected void freezeM() {
        int n;
        for (n = 0; n < this.chainCount; ++n) {
            if (this.chains[n].groupCount != 0) continue;
            for (int i = n + 1; i < this.chainCount; ++i) {
                this.chains[i - 1] = this.chains[i];
            }
            --this.chainCount;
        }
        this.chains = (Chain[])AU.arrayCopyObject(this.chains, this.chainCount);
        this.groupCount = -1;
        this.getGroupCount();
        for (n = 0; n < this.chainCount; ++n) {
            this.chains[n].groups = (Group[])AU.arrayCopyObject(this.chains[n].groups, this.chains[n].groupCount);
        }
    }
}

