/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.SlaterReader;
import org.jmol.api.JmolAdapter;
import org.jmol.quantum.SlaterData;
import org.jmol.util.Logger;

public class AdfReader
extends SlaterReader {
    private Map<String, SymmetryData> htSymmetries;
    private Lst<SymmetryData> vSymmetries;
    private String energy = null;
    private int nXX = 0;
    private String symLine;

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("Irreducible Representations, including subspecies") >= 0) {
            this.readSymmetries();
            return true;
        }
        if (this.line.indexOf("S F O s  ***  (Symmetrized Fragment Orbitals)  ***") >= 0) {
            this.readSlaterBasis();
            return true;
        }
        if (this.line.indexOf(" Coordinates (Cartesian, in Input Orientation)") >= 0 || this.line.indexOf("G E O M E T R Y  ***") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.readCoordinates();
            return true;
        }
        if (this.line.indexOf(" ======  Eigenvectors (rows) in BAS representation") >= 0) {
            if (this.doReadMolecularOrbitals) {
                this.readMolecularOrbitals(PT.getTokens((String)this.symLine)[1]);
            }
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("Energy:") >= 0) {
            String[] stringArray = PT.getTokens((String)this.line.substring(this.line.indexOf("Energy:")));
            this.energy = stringArray[1];
            return true;
        }
        if (this.line.indexOf("Vibrations") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (this.line.indexOf(" === ") >= 0) {
            this.symLine = this.line;
            return true;
        }
        if (this.line.indexOf(" ======  Eigenvectors (rows) in BAS representation") >= 0) {
            this.readMolecularOrbitals(PT.getTokens((String)this.symLine)[1]);
            return true;
        }
        return true;
    }

    private void readCoordinates() throws Exception {
        String[] stringArray;
        boolean bl = this.line.indexOf("G E O M E T R Y") >= 0;
        this.asc.newAtomSet();
        this.asc.setAtomSetName("" + this.energy);
        this.discardLinesUntilContains("----");
        int n = bl ? 2 : 5;
        this.nXX = 0;
        while (this.rd() != null && !this.line.startsWith(" -----") && (stringArray = this.getTokens()).length >= 5) {
            String string = stringArray[1];
            if (JmolAdapter.getElementNumber((String)string) < 1) {
                ++this.nXX;
                continue;
            }
            this.addAtomXYZSymName(stringArray, n, string, null);
        }
    }

    private void readFrequencies() throws Exception {
        this.rd();
        while (this.rd() != null) {
            while (this.rd() != null && this.line.indexOf(".") < 0 && this.line.indexOf("====") < 0) {
            }
            if (this.line == null || this.line.indexOf(".") < 0) {
                return;
            }
            String[] stringArray = this.getTokens();
            this.rd();
            int n = this.asc.ac;
            int n2 = this.asc.getLastAtomSetAtomCount();
            int n3 = stringArray.length;
            boolean[] blArray = new boolean[n3];
            for (int i = 0; i < n3; ++i) {
                boolean bl = blArray[i] = !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                this.asc.cloneLastAtomSet();
                this.asc.setAtomSetFrequency(null, null, stringArray[i], null);
            }
            this.readLines(this.nXX);
            this.fillFrequencyData(n, n2, n2, blArray, true, 0, 0, null, 0);
        }
    }

    private void readSymmetries() throws Exception {
        this.vSymmetries = new Lst();
        this.htSymmetries = new Hashtable<String, SymmetryData>();
        this.rd();
        int n = 0;
        String string = "";
        while (this.rd() != null && this.line.length() > 1) {
            string = string + this.line;
        }
        String[] stringArray = PT.getTokens((String)string);
        for (int i = 0; i < stringArray.length; ++i) {
            SymmetryData symmetryData = new SymmetryData(n++, stringArray[i]);
            this.htSymmetries.put(stringArray[i], symmetryData);
            this.vSymmetries.addLast((Object)symmetryData);
        }
    }

    private void readSlaterBasis() throws Exception {
        int n;
        int n2;
        Object[] objectArray;
        String[] stringArray;
        if (this.vSymmetries == null) {
            return;
        }
        int n3 = 0;
        for (int i = 0; i < this.vSymmetries.size(); ++i) {
            stringArray = (String[])this.vSymmetries.get(i);
            Logger.info((String)stringArray.sym);
            this.discardLinesUntilContains("=== " + stringArray.sym + " ===");
            if (this.line == null) {
                Logger.error((String)("Symmetry slater basis section not found: " + stringArray.sym));
                return;
            }
            stringArray.nSFO = this.parseIntAt(this.rd(), 15);
            stringArray.nBF = this.parseIntAt(this.rd(), 75);
            String string = "";
            while (this.rd() != null && this.line.length() > 1) {
                string = string + this.line;
            }
            objectArray = PT.getTokens((String)string);
            if (objectArray.length != stringArray.nBF) {
                return;
            }
            stringArray.basisFunctions = new int[objectArray.length];
            n2 = objectArray.length;
            while (--n2 >= 0) {
                n = this.parseIntStr((String)objectArray[n2]);
                if (n > n3) {
                    n3 = n;
                }
                stringArray.basisFunctions[n2] = n - 1;
            }
        }
        this.slaterArray = new SlaterData[n3];
        this.discardLinesUntilContains("(power of)");
        this.readLines(2);
        while (this.rd() != null && this.line.length() > 3 && this.line.charAt(3) == ' ') {
            String string = this.line;
            while (this.rd().indexOf("---") < 0) {
                string = string + this.line;
            }
            stringArray = PT.getTokens((String)string);
            int n4 = stringArray.length - 1;
            objectArray = new int[n4];
            for (n2 = 1; n2 <= n4; ++n2) {
                objectArray[n2 - 1] = this.parseIntStr(stringArray[n2]) - 1;
            }
            this.rd();
            while (this.line.length() >= 10) {
                string = this.line;
                while (this.rd().length() > 35 && this.line.substring(0, 35).trim().length() == 0) {
                    string = string + this.line;
                }
                stringArray = PT.getTokens((String)string);
                n2 = stringArray[0].equals("Core") ? 1 : 0;
                n = n2 != 0 ? 1 : 0;
                int n5 = this.parseIntStr(stringArray[n++]);
                int n6 = this.parseIntStr(stringArray[n++]);
                int n7 = this.parseIntStr(stringArray[n++]);
                int n8 = this.parseIntStr(stringArray[n++]);
                float f = this.parseFloatStr(stringArray[n++]);
                for (int i = 0; i < n4; ++i) {
                    int n9 = this.parseIntStr(stringArray[n++]) - 1;
                    this.slaterArray[n9] = new SlaterData(objectArray[i], n5, n6, n7, n8, f, 1.0);
                    this.slaterArray[n9].index = n9;
                }
            }
        }
    }

    private void readMolecularOrbitals(String string) throws Exception {
        int n;
        int n2;
        int n3;
        String[][] stringArray;
        int n4;
        SymmetryData symmetryData = this.htSymmetries.get(string);
        if (symmetryData == null) {
            return;
        }
        int n5 = symmetryData.index;
        boolean bl = n5 == this.vSymmetries.size() - 1;
        int n6 = 0;
        int n7 = this.slaterArray.length;
        symmetryData.coefs = new float[symmetryData.nSFO][n7];
        while (n6 < symmetryData.nBF) {
            this.rd();
            n4 = PT.getTokens((String)this.rd()).length;
            this.rd();
            symmetryData.mos = AU.createArrayOfHashtable((int)symmetryData.nSFO);
            stringArray = new String[symmetryData.nSFO][];
            this.fillDataBlock(stringArray, 0);
            for (int i = 1; i < n4; ++i) {
                n3 = symmetryData.basisFunctions[n6++];
                for (n2 = 0; n2 < symmetryData.nSFO; ++n2) {
                    symmetryData.coefs[n2][n3] = this.parseFloatStr(stringArray[n2][i]);
                }
            }
        }
        for (n4 = 0; n4 < symmetryData.nSFO; ++n4) {
            stringArray = new Hashtable();
            stringArray.put("coefficients", symmetryData.coefs[n4]);
            stringArray.put("id", string + " " + (n4 + 1));
            symmetryData.mos[n4] = stringArray;
        }
        if (!bl) {
            return;
        }
        n4 = this.htSymmetries.size();
        this.discardLinesUntilContains(n4 == 1 ? "Orbital Energies, per Irrep" : "Orbital Energies, all Irreps");
        this.readLines(4);
        int n8 = n = n4 == 1 ? 0 : 1;
        if (n4 == 1) {
            string = this.rd().trim();
        }
        while (this.rd() != null && this.line.length() > 10) {
            this.line = this.line.replace('(', ' ').replace(')', ' ');
            String[] stringArray2 = this.getTokens();
            n3 = stringArray2.length;
            if (n4 > 1) {
                string = stringArray2[0];
            }
            n2 = this.parseIntStr(stringArray2[n]);
            float f = this.parseFloatStr(stringArray2[n3 - 4 + n]);
            float f2 = this.parseFloatStr(stringArray2[n3 - 2 + n]);
            this.addMo(string, n2, f, f2);
        }
        int n9 = this.asc.getLastAtomSetAtomIndex();
        for (n3 = 0; n3 < n7; ++n3) {
            this.slaterArray[n3].iAtom += n9;
        }
        this.setSlaters(true, true);
        this.sortOrbitals();
        this.setMOs("eV");
    }

    private void addMo(String string, int n, float f, float f2) {
        SymmetryData symmetryData = this.htSymmetries.get(string);
        if (symmetryData == null) {
            for (Map.Entry entry : this.htSymmetries.entrySet()) {
                if (!((String)entry.getKey()).startsWith(string + ":")) continue;
                symmetryData = (SymmetryData)entry.getValue();
                break;
            }
            if (symmetryData == null) {
                return;
            }
        }
        Map<String, Object> map = symmetryData.mos[n - 1];
        map.put("occupancy", Float.valueOf(f > 2.0f ? 2.0f : f));
        map.put("energy", Float.valueOf(f2));
        map.put("symmetry", symmetryData.sym + "_" + n);
        this.setMO(map);
    }

    private class SymmetryData {
        int index;
        String sym;
        int nSFO;
        int nBF;
        float[][] coefs;
        Map<String, Object>[] mos;
        int[] basisFunctions;

        public SymmetryData(int n, String string) {
            Logger.info((String)("ADF reader creating SymmetryData " + string + " " + n));
            this.index = n;
            this.sym = string;
        }
    }
}

