/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.AU;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.render.ShapeRenderer;
import org.jmol.shape.Mesh;
import org.jmol.util.C;

public abstract class MeshRenderer
extends ShapeRenderer {
    protected Mesh mesh;
    protected T3[] vertices;
    protected short[] normixes;
    protected P3i[] screens;
    protected P3[] p3Screens;
    protected V3[] transformedVectors;
    protected int vertexCount;
    protected float imageFontScaling;
    protected float scalePixelsPerMicron;
    protected int diameter;
    protected float width;
    protected boolean isTranslucent;
    protected boolean frontOnly;
    protected boolean isShell;
    protected boolean antialias;
    protected boolean haveBsDisplay;
    protected boolean selectedPolyOnly;
    protected boolean isGhostPass;
    protected boolean isPrecision;
    protected P4 thePlane;
    protected P3 latticeOffset = new P3();
    protected final P3 pt1f = new P3();
    protected final P3 pt2f = new P3();
    protected P3i pt1i = new P3i();
    protected P3i pt2i = new P3i();
    protected final P3i pt3i = new P3i();
    protected int exportPass;
    protected boolean needTranslucent;
    private boolean doRender;
    protected boolean volumeRender;
    protected BS bsPolygons;
    protected boolean isTranslucentInherit;
    protected boolean renderLow;
    protected int meshSlabValue = 100;
    protected BS bsPolygonsToExport = new BS();

    protected boolean renderMesh2(Mesh mesh) {
        this.mesh = mesh;
        if (!this.setVariables()) {
            return false;
        }
        if (!this.doRender) {
            return mesh.title != null;
        }
        this.latticeOffset.set(0.0f, 0.0f, 0.0f);
        if (mesh.modelIndex < 0 || mesh.lattice == null && mesh.symops == null) {
            int n = this.vertexCount;
            while (--n >= 0) {
                if (this.vertices[n] == null) continue;
                this.tm.transformPtScr(this.vertices[n], this.screens[n]);
            }
            if (this.isPrecision) {
                n = this.vertexCount;
                while (--n >= 0) {
                    if (this.vertices[n] == null) continue;
                    this.tm.transformPtScrT3(this.vertices[n], this.p3Screens[n]);
                }
            }
            this.render2(this.isExport);
        } else {
            P3 p3 = new P3();
            SymmetryInterface symmetryInterface = mesh.getUnitCell();
            if (symmetryInterface != null) {
                if (mesh.symops != null) {
                    if (mesh.symopNormixes == null) {
                        mesh.symopNormixes = AU.newShort2(mesh.symops.length);
                    }
                    T3[] t3Array = null;
                    int n = mesh.symops.length;
                    short s = mesh.colix;
                    int n2 = n;
                    while (--n2 >= 0) {
                        short[] sArray;
                        M4 m4 = mesh.symops[n2];
                        if (m4 == null) continue;
                        if (mesh.colorType == 1296041474) {
                            mesh.colix = mesh.symopColixes[n2];
                        }
                        boolean bl = (sArray = mesh.symopNormixes[n2]) == null;
                        t3Array = bl ? new P3[this.vertexCount] : null;
                        int n3 = this.vertexCount;
                        while (--n3 >= 0) {
                            p3.setT(this.vertices[n3]);
                            symmetryInterface.toFractional(p3, true);
                            m4.rotTrans(p3);
                            symmetryInterface.toCartesian(p3, true);
                            this.tm.transformPtScr(p3, this.screens[n3]);
                            if (!bl) continue;
                            t3Array[n3] = p3;
                            p3 = new P3();
                        }
                        if (bl) {
                            mesh.symopNormixes[n2] = mesh.setNormixes(mesh.getNormals(t3Array, null));
                            this.normixes = mesh.symopNormixes[n2];
                        } else {
                            mesh.normixes = mesh.symopNormixes[n2];
                            this.normixes = mesh.normixes;
                        }
                        this.render2(this.isExport);
                    }
                    mesh.colix = s;
                } else {
                    P3i p3i = new P3i();
                    P3i p3i2 = P3i.new3((int)mesh.lattice.x, (int)mesh.lattice.y, (int)mesh.lattice.z);
                    symmetryInterface.setMinMaxLatticeParameters(p3i, p3i2);
                    for (int i = p3i.x; i < p3i2.x; ++i) {
                        for (int j = p3i.y; j < p3i2.y; ++j) {
                            for (int k = p3i.z; k < p3i2.z; ++k) {
                                this.latticeOffset.set(i, j, k);
                                symmetryInterface.toCartesian(this.latticeOffset, false);
                                int n = this.vertexCount;
                                while (--n >= 0) {
                                    p3.add2(this.vertices[n], this.latticeOffset);
                                    this.tm.transformPtScr(p3, this.screens[n]);
                                }
                                this.render2(this.isExport);
                            }
                        }
                    }
                }
            }
        }
        if (this.screens != null) {
            this.vwr.freeTempScreens(this.screens);
        }
        if (this.p3Screens != null) {
            this.vwr.freeTempPoints(this.p3Screens);
        }
        return true;
    }

    private boolean setVariables() {
        if (this.mesh.visibilityFlags == 0) {
            return false;
        }
        if (this.mesh.bsSlabGhost != null) {
            this.g3d.setC(this.mesh.slabColix);
        }
        if (this.mesh.colorsExplicit) {
            this.g3d.setC((short)2047);
        }
        this.isGhostPass = this.mesh.bsSlabGhost != null && (this.isExport ? this.exportPass == 2 : this.vwr.gdata.isPass2);
        this.isTranslucentInherit = this.isGhostPass && C.getColixTranslucent3(this.mesh.slabColix, false, 0.0f) == 1;
        boolean bl = this.isTranslucent = this.isGhostPass || C.renderPass2(this.mesh.colix);
        if (this.isTranslucent || this.volumeRender || this.mesh.bsSlabGhost != null) {
            this.needTranslucent = true;
        }
        boolean bl2 = this.doRender = this.setColix(this.mesh.colix) || this.mesh.showContourLines;
        if (!this.doRender || this.isGhostPass && !(this.doRender = this.g3d.setC(this.mesh.slabColix))) {
            this.vertices = this.mesh.vs;
            if (this.needTranslucent) {
                this.g3d.setC(C.getColixTranslucent3((short)4, true, 0.5f));
            }
            return true;
        }
        if (this.mesh.isModelConnected) {
            this.mesh.mat4 = this.ms.am[this.mesh.modelIndex].mat4;
        }
        T3[] t3Array = this.vertices = this.mesh.scale3d == 0.0f && this.mesh.mat4 == null ? this.mesh.vs : this.mesh.getOffsetVertices(this.thePlane);
        if (this.mesh.lineData == null) {
            this.vertexCount = this.mesh.vc;
            if (this.vertexCount == 0) {
                return false;
            }
            this.normixes = this.mesh.normixes;
            if (this.normixes == null && this.mesh.pc >= 0 || this.vertices == null) {
                return false;
            }
            this.haveBsDisplay = this.mesh.bsDisplay != null;
            boolean bl3 = this.selectedPolyOnly = this.isGhostPass || this.mesh.bsSlabDisplay != null;
            this.bsPolygons = this.isGhostPass ? this.mesh.bsSlabGhost : (this.selectedPolyOnly ? this.mesh.bsSlabDisplay : null);
            this.renderLow = !this.isExport && !this.vwr.checkMotionRendering(1073742018);
            boolean bl4 = !this.mesh.isTwoSided && !this.selectedPolyOnly && (this.meshSlabValue == Integer.MIN_VALUE || this.meshSlabValue >= 100);
            this.frontOnly = this.renderLow || this.mesh.frontOnly && !this.tm.slabEnabled && bl4;
            this.isShell = this.mesh.isShell && bl4;
            this.screens = this.vwr.allocTempScreens(this.vertexCount);
            if (this.isPrecision) {
                this.p3Screens = this.vwr.allocTempPoints(this.vertexCount);
            }
            if (this.frontOnly || this.isShell) {
                this.transformedVectors = this.vwr.gdata.getTransformedVertexVectors();
            }
            if (this.transformedVectors == null) {
                this.isShell = false;
                this.frontOnly = false;
            }
        }
        return true;
    }

    public boolean setColix(short s) {
        if (this.isGhostPass) {
            return true;
        }
        if (this.volumeRender && !this.isTranslucent) {
            s = C.getColixTranslucent3(s, true, 0.8f);
        }
        this.colix = s;
        if (C.isColixLastAvailable(s)) {
            this.vwr.gdata.setColor(this.mesh.color);
        }
        return this.g3d.setC(s);
    }

    protected boolean isPolygonDisplayable(int n) {
        return true;
    }

    protected void render2(boolean bl) {
        this.render2b(bl);
    }

    protected void render2b(boolean bl) {
        if (!this.g3d.setC(this.isGhostPass ? this.mesh.slabColix : this.colix)) {
            return;
        }
        if (this.renderLow || this.mesh.showPoints || this.mesh.pc <= 0) {
            this.renderPoints();
        }
        if (!this.renderLow && (this.isGhostPass ? this.mesh.slabMeshType == 1073742018 : this.mesh.drawTriangles)) {
            this.renderTriangles(false, this.mesh.showTriangles, false);
        }
        if (!this.renderLow && this.mesh.pc > 0 && (this.isGhostPass ? this.mesh.slabMeshType == 1073741938 : this.mesh.fillTriangles)) {
            this.renderTriangles(true, this.mesh.showTriangles, bl);
        }
    }

    protected void renderPoints() {
        if (!this.mesh.isTriangleSet || this.mesh.pc < 0) {
            int n = this.vertexCount;
            while (--n >= 0) {
                if (this.frontOnly && this.normixes != null && !this.isVisibleNormix(this.normixes[n])) continue;
                this.drawPoint(n, false);
            }
            return;
        }
        int[][] nArray = this.mesh.pis;
        BS bS = BS.newN(this.mesh.vc);
        if (this.haveBsDisplay) {
            bS.setBits(0, this.mesh.vc);
            bS.andNot(this.mesh.bsDisplay);
        }
        int n = this.mesh.pc;
        while (--n >= 0) {
            if (!this.isPolygonDisplayable(n)) continue;
            int[] nArray2 = nArray[n];
            if (this.frontOnly && !this.isVisibleNormix(this.normixes[n])) continue;
            int n2 = nArray2.length - 1;
            while (--n2 >= 0) {
                int n3 = nArray2[n2];
                if (bS.get(n3)) continue;
                bS.set(n3);
                this.drawPoint(n3, true);
            }
        }
    }

    private void drawPoint(int n, boolean bl) {
        if (this.renderLow && bl) {
            P3i p3i = this.screens[n];
            this.g3d.drawPixel(p3i.x, p3i.y, p3i.z);
        } else if (this.mesh.pc >= 0) {
            this.drawMeshSphere(this.screens[n]);
        } else {
            this.drawEdge(n, n, false, this.vertices[n], this.vertices[n], this.screens[n], null);
        }
    }

    private void drawMeshSphere(P3i p3i) {
        this.g3d.fillSphereI(4, p3i);
    }

    protected void renderTriangles(boolean bl, boolean bl2, boolean bl3) {
        this.g3d.addRenderer(1073742182);
        int[][] nArray = this.mesh.pis;
        short s = this.colix = this.isGhostPass ? this.mesh.slabColix : this.mesh.colix;
        if (this.isTranslucentInherit) {
            this.colix = C.copyColixTranslucency(this.mesh.slabColix, this.mesh.colix);
        }
        this.g3d.setC(this.colix);
        if (bl3) {
            if (this.frontOnly && bl) {
                this.frontOnly = false;
            }
            this.bsPolygonsToExport.clearAll();
        }
        int n = this.mesh.pc;
        while (--n >= 0) {
            int n2;
            short s2;
            if (!this.isPolygonDisplayable(n)) continue;
            int[] nArray2 = nArray[n];
            int n3 = nArray2[0];
            int n4 = nArray2[1];
            int n5 = nArray2[2];
            if (bl2) {
                this.setColix((short)(Math.round(Math.random() * 10.0) + 5L));
            }
            if (this.haveBsDisplay && (!this.mesh.bsDisplay.get(n3) || !this.mesh.bsDisplay.get(n4) || !this.mesh.bsDisplay.get(n5))) continue;
            if (n4 == n5) {
                this.drawEdge(n3, n4, bl, this.vertices[n3], this.vertices[n4], this.screens[n3], this.screens[n4]);
                continue;
            }
            if (this.mesh.isTriangleSet) {
                s2 = this.normixes[n];
                if (this.frontOnly && !this.isVisibleNormix(s2)) continue;
                if (bl) {
                    if (this.isPrecision) {
                        this.g3d.fillTriangle3CNBits(this.p3Screens[n3], this.colix, s2, this.p3Screens[n4], this.colix, s2, this.p3Screens[n5], this.colix, s2);
                        continue;
                    }
                    this.g3d.fillTriangle3CN(this.screens[n3], this.colix, s2, this.screens[n4], this.colix, s2, this.screens[n5], this.colix, s2);
                    continue;
                }
                n2 = nArray2[3];
                if (bl2) {
                    n2 = 7;
                }
                if ((n2 & 1) == 1) {
                    this.drawEdge(n3, n4, true, this.vertices[n3], this.vertices[n4], this.screens[n3], this.screens[n4]);
                }
                if ((n2 & 2) == 2) {
                    this.drawEdge(n4, n5, true, this.vertices[n4], this.vertices[n5], this.screens[n4], this.screens[n5]);
                }
                if ((n2 & 4) != 4) continue;
                this.drawEdge(n3, n5, true, this.vertices[n3], this.vertices[n5], this.screens[n3], this.screens[n5]);
                continue;
            }
            s2 = this.normixes[n3];
            short s3 = this.normixes[n4];
            short s4 = this.normixes[n5];
            int n6 = n2 = this.frontOnly || this.isShell ? this.checkFront(s2, s3, s4) : 7;
            if (bl && n2 != 7) continue;
            switch (nArray2.length) {
                case 3: {
                    if (bl) {
                        if (bl3) {
                            this.bsPolygonsToExport.set(n);
                            break;
                        }
                        if (this.isPrecision) {
                            this.g3d.fillTriangle3CNBits(this.p3Screens[n3], this.colix, s2, this.p3Screens[n4], this.colix, s3, this.p3Screens[n5], this.colix, s4);
                            break;
                        }
                        this.g3d.fillTriangle3CN(this.screens[n3], this.colix, s2, this.screens[n4], this.colix, s3, this.screens[n5], this.colix, s4);
                        break;
                    }
                    if (this.isPrecision) {
                        this.drawTriangleBits(this.p3Screens[n3], this.colix, this.p3Screens[n4], this.colix, this.p3Screens[n5], this.colix, n2, 1);
                        break;
                    }
                    this.drawTriangle(this.screens[n3], this.colix, this.screens[n4], this.colix, this.screens[n5], this.colix, n2, 1);
                    break;
                }
                case 4: {
                    int n7 = nArray2[3];
                    short s5 = this.normixes[n7];
                    if (this.frontOnly && (n2 != 7 || !this.isVisibleNormix(s5))) break;
                    if (bl) {
                        if (bl3) {
                            this.bsPolygonsToExport.set(n);
                            break;
                        }
                        if (this.isPrecision) {
                            this.g3d.fillTriangle3CNBits(this.p3Screens[n3], this.colix, s2, this.p3Screens[n4], this.colix, s3, this.p3Screens[n5], this.colix, s4);
                            this.g3d.fillTriangle3CNBits(this.p3Screens[n3], this.colix, s2, this.p3Screens[n5], this.colix, s4, this.p3Screens[n7], this.colix, s5);
                            break;
                        }
                        this.g3d.fillTriangle3CN(this.screens[n3], this.colix, s2, this.screens[n4], this.colix, s3, this.screens[n5], this.colix, s4);
                        this.g3d.fillTriangle3CN(this.screens[n3], this.colix, s2, this.screens[n5], this.colix, s4, this.screens[n7], this.colix, s5);
                        break;
                    }
                    this.vwr.gdata.drawQuadrilateralBits(this.g3d, this.colix, this.p3Screens[n3], this.p3Screens[n4], this.p3Screens[n5], this.p3Screens[n7]);
                }
            }
        }
        if (bl3) {
            this.exportSurface(this.colix);
        }
    }

    protected boolean isVisibleNormix(short s) {
        return s < 0 || this.transformedVectors[s].z >= 0.0f;
    }

    private void drawTriangleBits(P3 p3, short s, P3 p32, short s2, P3 p33, short s3, int n, int n2) {
        if (!this.antialias && n2 == 1) {
            this.vwr.gdata.drawTriangleBits(this.g3d, p3, s, p32, s2, p33, s3, n);
            return;
        }
        if (this.antialias) {
            n2 <<= 1;
        }
        if ((n & 1) == 1) {
            this.g3d.fillCylinderBits2(s, s2, (byte)1, n2, p3, p32);
        }
        if ((n & 2) == 2) {
            this.g3d.fillCylinderBits2(s2, s3, (byte)1, n2, p32, p33);
        }
        if ((n & 4) == 4) {
            this.g3d.fillCylinderBits2(s, s3, (byte)1, n2, p3, p33);
        }
    }

    protected void drawTriangle(P3i p3i, short s, P3i p3i2, short s2, P3i p3i3, short s3, int n, int n2) {
        if (!this.antialias && n2 == 1) {
            this.g3d.drawTriangle3C(p3i, s, p3i2, s2, p3i3, s3, n);
            return;
        }
        if (this.antialias) {
            n2 <<= 1;
        }
        if ((n & 1) == 1) {
            this.g3d.fillCylinderXYZ(s, s2, (byte)1, n2, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z);
        }
        if ((n & 2) == 2) {
            this.g3d.fillCylinderXYZ(s2, s3, (byte)1, n2, p3i2.x, p3i2.y, p3i2.z, p3i3.x, p3i3.y, p3i3.z);
        }
        if ((n & 4) == 4) {
            this.g3d.fillCylinderXYZ(s, s3, (byte)1, n2, p3i.x, p3i.y, p3i.z, p3i3.x, p3i3.y, p3i3.z);
        }
    }

    protected int checkFront(short s, short s2, short s3) {
        int n = 7;
        if (this.transformedVectors[s].z < 0.0f) {
            n ^= 1;
        }
        if (this.transformedVectors[s2].z < 0.0f) {
            n ^= 2;
        }
        if (this.transformedVectors[s3].z < 0.0f) {
            n ^= 4;
        }
        return n;
    }

    protected void drawEdge(int n, int n2, boolean bl, T3 t3, T3 t32, P3i p3i, P3i p3i2) {
        byte by;
        byte by2 = n != n2 && !bl ? (byte)0 : (by = this.width < 0.0f || (double)this.width == -0.0 || n != n2 && this.isTranslucent ? (byte)2 : 3);
        if (this.width == 0.0f) {
            if (this.diameter == 0) {
                int n3 = this.mesh.diameter > 0 ? this.mesh.diameter : (this.diameter = n == n2 ? 7 : 3);
            }
            if (this.exportType == 1) {
                this.pt1f.ave(t3, t32);
                this.tm.transformPtScr(this.pt1f, this.pt1i);
            }
            if (n == n2) {
                if (this.isPrecision) {
                    this.pt1f.set(p3i.x, p3i.y, p3i.z);
                    this.g3d.fillSphereBits(this.diameter, this.pt1f);
                } else {
                    this.g3d.fillSphereI(this.diameter, this.pt1i);
                }
                return;
            }
            if (!this.isPrecision) {
                this.g3d.fillCylinder(by, this.diameter, p3i, p3i2);
                return;
            }
        } else {
            this.pt1f.ave(t3, t32);
            this.tm.transformPtScr(this.pt1f, this.pt1i);
            int n4 = (int)Math.floor(Math.abs(this.width) * 1000.0f);
            this.diameter = (int)this.vwr.tm.scaleToScreen(this.pt1i.z, n4);
        }
        if (this.diameter == 0) {
            this.diameter = 1;
        }
        this.tm.transformPt3f(t3, this.pt1f);
        this.tm.transformPt3f(t32, this.pt2f);
        this.g3d.fillCylinderBits(by, this.diameter, this.pt1f, this.pt2f);
    }

    protected void exportSurface(short s) {
        this.mesh.normals = this.mesh.getNormals(this.vertices, null);
        this.mesh.bsPolygons = this.bsPolygonsToExport;
        this.mesh.offset = this.latticeOffset;
        this.g3d.drawSurface(this.mesh, s);
        this.mesh.normals = null;
        this.mesh.bsPolygons = null;
    }
}

