/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterStructureIterator;
import org.jmol.api.JmolBioResolver;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.CarbohydrateMonomer;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.modelsetbio.PhosphorusPolymer;
import org.jmol.script.SV;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public final class Resolver
implements JmolBioResolver,
Comparator<String[]> {
    public static final Map<String, Short> htGroup = new Hashtable<String, Short>();
    private Viewer vwr;
    private V3 vAB;
    private V3 vNorm;
    private P4 plane;
    private ModelLoader ml;
    private ModelSet ms;
    private BS bsAddedMask;
    private int lastSetH = Integer.MIN_VALUE;
    private int maxSerial = 0;
    private boolean haveHsAlready;
    private BS bsAddedHydrogens;
    private BS bsAtomsForHs;
    private Map<String, String> htBondMap;
    private Map<String, Boolean> htGroupBonds;
    private String[] hNames;
    private int baseBondIndex = 0;
    private BS bsAssigned;
    private static Map<String, String[][]> htPdbBondInfo;
    public static final String[] pdbBondInfo;
    private static final int[] pdbHydrogenCount;
    private static final String allCarbohydrates = ",[AHR],[ALL],[AMU],[ARA],[ARB],[BDF],[BDR],[BGC],[BMA],[FCA],[FCB],[FRU],[FUC],[FUL],[GAL],[GLA],[GLC],[GXL],[GUP],[LXC],[MAN],[RAM],[RIB],[RIP],[XYP],[XYS],[CBI],[CT3],[CTR],[CTT],[LAT],[MAB],[MAL],[MLR],[MTT],[SUC],[TRE],[GCU],[MTL],[NAG],[NDG],[RHA],[SOR],[SOL],[SOE],[XYL],[A2G],[LBT],[NGA],[SIA],[SLB],[AFL],[AGC],[GLB],[NAN],[RAA]";
    private static int group3Count;
    static final char[] predefinedGroup1Names;
    public static short group3NameCount;
    private static final String[] predefinedGroup3Names;
    private static final String naNoH = "A3;A1;C3;G3;I3";
    private static final String aaSp2 = "ARGN;ASNN;ASNO;ASPO;GLNN;GLNO;GLUO;HISN;HISC;PHECTRPC;TRPN;TYRC";
    private static final String aaPlus = "LYSN";
    private static final String[] specialAtomNames;
    public static final int ATOMID_MAX;
    private static Map<String, Byte> htSpecialAtoms;
    private static final int[] argbsAmino;
    private static final int[] argbsChainAtom;
    private static final int[] argbsChainHetero;
    private static final int[] argbsShapely;

    @Override
    public JmolBioResolver setLoader(ModelLoader modelLoader) {
        this.ml = modelLoader;
        this.bsAddedMask = null;
        this.lastSetH = Integer.MIN_VALUE;
        this.maxSerial = 0;
        this.haveHsAlready = false;
        if (modelLoader == null) {
            this.ms = null;
            this.bsAssigned = null;
            this.bsAtomsForHs = null;
            this.bsAddedHydrogens = null;
            this.htBondMap = null;
            this.htGroupBonds = null;
            this.hNames = null;
        } else {
            Group.specialAtomNames = specialAtomNames;
            this.ms = modelLoader.ms;
            this.vwr = modelLoader.ms.vwr;
            modelLoader.specialAtomIndexes = new int[ATOMID_MAX];
        }
        return this;
    }

    @Override
    public Resolver setViewer(Viewer viewer) {
        this.vwr = viewer;
        if (Group.standardGroupList == null) {
            int n;
            SB sB = new SB();
            for (n = 1; n < 42; ++n) {
                sB.append(",[").append(predefinedGroup3Names[n]).append("]");
            }
            sB.append(allCarbohydrates);
            group3Count = sB.length() / 6;
            Group.standardGroupList = sB.toString();
            int n2 = predefinedGroup3Names.length;
            for (n = 0; n < n2; ++n) {
                Resolver.addGroup3Name(predefinedGroup3Names[n].trim());
            }
        }
        return this;
    }

    @Override
    public Model getBioModel(int n, int n2, String string, Properties properties, Map<String, Object> map) {
        return new BioModel(this.ms, n, n2, string, properties, map);
    }

    @Override
    public Group distinguishAndPropagateGroup(Chain chain, String string, int n, int n2, int n3, int n4, int[] nArray, Atom[] atomArray) {
        int n5 = 0;
        int n6 = ATOMID_MAX;
        while (--n6 >= 0) {
            nArray[n6] = Integer.MIN_VALUE;
        }
        for (n6 = n3; n6 >= n2; --n6) {
            byte by = atomArray[n6].atomID;
            if (by <= 0) continue;
            if (by < 14) {
                n5 |= 1 << by;
            }
            nArray[by] = n6;
        }
        Monomer monomer = null;
        if ((n5 & 0xE) == 14) {
            monomer = AminoMonomer.validateAndAllocate(chain, string, n, n2, n3, nArray, atomArray);
        } else if (n5 == 4) {
            monomer = AlphaMonomer.validateAndAllocateA(chain, string, n, n2, n3, nArray);
        } else if ((n5 & 0x1FC0) == 8128) {
            monomer = NucleicMonomer.validateAndAllocate(chain, string, n, n2, n3, nArray);
        } else if (n5 == 8192) {
            monomer = PhosphorusMonomer.validateAndAllocateP(chain, string, n, n2, n3, nArray);
        } else if (Resolver.checkCarbohydrate(string)) {
            monomer = CarbohydrateMonomer.validateAndAllocate(chain, string, n, n2, n3);
        }
        return monomer != null && monomer.leadAtomIndex >= 0 ? monomer : null;
    }

    @Override
    public void setHaveHsAlready(boolean bl) {
        this.haveHsAlready = bl;
    }

    @Override
    public void initializeHydrogenAddition() {
        this.baseBondIndex = this.ms.bondCount;
        this.bsAddedHydrogens = new BS();
        this.bsAtomsForHs = new BS();
        this.htBondMap = new Hashtable<String, String>();
        this.htGroupBonds = new Hashtable<String, Boolean>();
        this.hNames = new String[3];
        this.vAB = new V3();
        this.vNorm = new V3();
        this.plane = new P4();
    }

    @Override
    public void addImplicitHydrogenAtoms(JmolAdapter jmolAdapter, int n, int n2) {
        int n3;
        String string = this.ml.getGroup3(n);
        if (this.haveHsAlready || string == null || (n3 = Resolver.getStandardPdbHydrogenCount(string)) == 0) {
            return;
        }
        n2 = n3 < 0 ? -1 : n3 + n2;
        Object object = null;
        int n4 = this.ml.getFirstAtomIndex(n);
        int n5 = this.ms.ac;
        if (n2 < 0) {
            if (n5 - n4 == 1) {
                return;
            }
            object = this.vwr.getLigandModel(string, "ligand_", "_data", null);
            if (object == null) {
                return;
            }
            n2 = jmolAdapter.getHydrogenAtomCount(object);
            if (n2 < 1) {
                return;
            }
        }
        this.getBondInfo(jmolAdapter, string, object);
        this.ms.am[this.ms.at[n4].mi].isPdbWithMultipleBonds = true;
        this.bsAtomsForHs.setBits(n4, n5);
        this.bsAddedHydrogens.setBits(n5, n5 + n2);
        boolean bl = this.ms.at[n4].isHetero();
        P3 p3 = P3.new3(Float.NaN, Float.NaN, Float.NaN);
        Atom atom = this.ms.at[n4];
        for (int i = 0; i < n2; ++i) {
            this.ms.addAtom(atom.mi, atom.group, 1, "H", null, 0, atom.getSeqID(), 0, p3, Float.NaN, null, 0, 0.0f, 1.0f, 0.0f, null, bl, (byte)0, null).delete(null);
        }
    }

    private void getBondInfo(JmolAdapter jmolAdapter, String string, Object object) {
        String[][] stringArray;
        if (this.htGroupBonds.get(string) != null) {
            return;
        }
        String[][] stringArray2 = stringArray = object == null ? this.getPdbBondInfo(string, this.vwr.g.legacyHAddition) : this.getLigandBondInfo(jmolAdapter, object, string);
        if (stringArray == null) {
            return;
        }
        this.htGroupBonds.put(string, Boolean.TRUE);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i][1].charAt(0) == 'H') {
                this.htBondMap.put(string + "." + stringArray[i][0], stringArray[i][1]);
                continue;
            }
            this.htBondMap.put(string + ":" + stringArray[i][0] + ":" + stringArray[i][1], stringArray[i][2]);
        }
    }

    private String[][] getLigandBondInfo(JmolAdapter jmolAdapter, Object object, String string) {
        String[][] stringArray = jmolAdapter.getBondList(object);
        Hashtable<String, P3> hashtable = new Hashtable<String, P3>();
        JmolAdapterAtomIterator jmolAdapterAtomIterator = jmolAdapter.getAtomIterator(object);
        while (jmolAdapterAtomIterator.hasNext()) {
            hashtable.put(jmolAdapterAtomIterator.getAtomName(), jmolAdapterAtomIterator.getXYZ());
        }
        String[][] stringArray2 = new String[stringArray.length * 2][];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            if (stringArray3[0].charAt(0) != 'H') {
                stringArray2[n++] = new String[]{stringArray3[0], stringArray3[1], stringArray3[2], stringArray3[1].startsWith("H") ? "0" : "1"};
            }
            if (stringArray3[1].charAt(0) == 'H') continue;
            stringArray2[n++] = new String[]{stringArray3[1], stringArray3[0], stringArray3[2], stringArray3[0].startsWith("H") ? "0" : "1"};
        }
        Arrays.sort(stringArray2, this);
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray4 = stringArray2[n2];
            String string2 = stringArray4[0];
            int n3 = 0;
            int n4 = 0;
            while (n2 < n && (stringArray4 = stringArray2[n2])[0].equals(string2)) {
                if (stringArray4[3].equals("0")) {
                    ++n3;
                } else if (stringArray4[3].equals("1")) {
                    ++n4;
                }
                ++n2;
            }
            int n5 = n2 - n3 - n4;
            if (n3 == 1) continue;
            switch (n4) {
                case 1: {
                    char c = n3 == 2 ? (char)'@' : '|';
                    for (int i = 1; i < n3; ++i) {
                        String[] stringArray5 = stringArray2[n5];
                        stringArray5[1] = stringArray5[1] + c + stringArray2[n5 + i][1];
                        stringArray2[n5 + i] = null;
                    }
                    break;
                }
                case 2: {
                    if (n3 != 2) break;
                    String string3 = stringArray2[n5][0];
                    String string4 = stringArray2[n5 + n3][1];
                    String string5 = stringArray2[n5 + n3 + 1][1];
                    int n6 = string4.compareTo(string5);
                    Measure.getPlaneThroughPoints((T3)hashtable.get(string4), (T3)hashtable.get(string3), (T3)hashtable.get(string5), this.vNorm, this.vAB, this.plane);
                    float f = Measure.distanceToPlane(this.plane, (T3)hashtable.get(stringArray2[n5][1])) * (float)n6;
                    stringArray2[n5][1] = f > 0.0f ? stringArray2[n5][1] + "@" + stringArray2[n5 + 1][1] : stringArray2[n5 + 1][1] + "@" + stringArray2[n5][1];
                    stringArray2[n5 + 1] = null;
                }
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            String[] stringArray6 = stringArray2[n2];
            if (stringArray6 != null && stringArray6[1].charAt(0) != 'H' && stringArray6[0].compareTo(stringArray6[1]) > 0) {
                stringArray2[n2] = null;
                continue;
            }
            if (stringArray6 == null) continue;
            Logger.info(" ligand " + string + ": " + stringArray2[n2][0] + " - " + stringArray2[n2][1] + " order " + stringArray2[n2][2]);
        }
        return stringArray2;
    }

    @Override
    public int compare(String[] stringArray, String[] stringArray2) {
        return stringArray2 == null ? (stringArray == null ? 0 : -1) : (stringArray == null ? 1 : (stringArray[0].compareTo(stringArray2[0]) < 0 ? -1 : (stringArray[0].compareTo(stringArray2[0]) > 0 ? 1 : (stringArray[3].compareTo(stringArray2[3]) < 0 ? -1 : (stringArray[3].compareTo(stringArray2[3]) > 0 ? 1 : (stringArray[1].compareTo(stringArray2[1]) < 0 ? -1 : (stringArray[1].compareTo(stringArray2[1]) > 0 ? 1 : 0)))))));
    }

    @Override
    public void finalizeHydrogens() {
        this.vwr.getLigandModel(null, null, null, null);
        this.finalizePdbMultipleBonds();
        this.addHydrogens();
    }

    private void addHydrogens() {
        if (this.bsAddedHydrogens.nextSetBit(0) < 0) {
            return;
        }
        this.bsAddedMask = BSUtil.copy(this.bsAddedHydrogens);
        this.finalizePdbCharges();
        int[] nArray = new int[1];
        P3[][] p3Array = this.ms.calculateHydrogens(this.bsAtomsForHs, nArray, true, false, null);
        Group group = null;
        int n = 0;
        block8: for (int i = 0; i < p3Array.length; ++i) {
            if (p3Array[i] == null) continue;
            Atom atom = this.ms.at[i];
            Group group2 = atom.group;
            if (group2 != group) {
                group = group2;
                n = group2.lastAtomIndex;
                while (this.bsAddedHydrogens.get(n)) {
                    --n;
                }
            }
            String string = atom.getGroup3(false);
            String string2 = atom.getAtomName();
            String string3 = this.htBondMap.get(string + "." + string2);
            if (string3 == null) continue;
            boolean bl = string3.contains("@");
            boolean bl2 = string3.endsWith("?") || string3.indexOf("|") >= 0;
            int n2 = p3Array[i].length;
            if (n2 == 3 && !bl2 && string3.equals("H@H2")) {
                string3 = "H|H2|H3";
                bl2 = true;
                bl = false;
            }
            if (bl && n2 == 3 || bl2 != (n2 == 3)) {
                Logger.info("Error adding H atoms to " + string + group2.getResno() + ": " + p3Array[i].length + " atoms should not be added to " + string2);
                continue;
            }
            int n3 = string3.indexOf("@");
            switch (p3Array[i].length) {
                case 1: {
                    if (n3 > 0) {
                        string3 = string3.substring(0, n3);
                    }
                    this.setHydrogen(i, ++n, string3, p3Array[i][0]);
                    continue block8;
                }
                case 2: {
                    String string4;
                    String string5;
                    float f = -1.0f;
                    Bond[] bondArray = atom.bonds;
                    if (bondArray != null) {
                        switch (bondArray.length) {
                            case 2: {
                                Atom atom2 = bondArray[0].getOtherAtom(atom);
                                Atom atom3 = bondArray[1].getOtherAtom(atom);
                                int n4 = atom2.getAtomName().compareTo(atom3.getAtomName());
                                f = Measure.distanceToPlane(Measure.getPlaneThroughPoints(atom2, atom, atom3, this.vNorm, this.vAB, this.plane), p3Array[i][0]) * (float)n4;
                            }
                        }
                    }
                    if (n3 < 0) {
                        Logger.info("Error adding H atoms to " + string + group2.getResno() + ": expected to only need 1 H but needed 2");
                        string5 = "H";
                        string4 = "H";
                    } else if (f < 0.0f) {
                        string5 = string3.substring(0, n3);
                        string4 = string3.substring(n3 + 1);
                    } else {
                        string4 = string3.substring(0, n3);
                        string5 = string3.substring(n3 + 1);
                    }
                    this.setHydrogen(i, ++n, string4, p3Array[i][0]);
                    this.setHydrogen(i, ++n, string5, p3Array[i][1]);
                    continue block8;
                }
                case 3: {
                    int n5 = string3.indexOf(124);
                    if (n5 >= 0) {
                        int n6 = string3.lastIndexOf(124);
                        this.hNames[0] = string3.substring(0, n5);
                        this.hNames[1] = string3.substring(n5 + 1, n6);
                        this.hNames[2] = string3.substring(n6 + 1);
                    } else {
                        this.hNames[0] = string3.replace('?', '1');
                        this.hNames[1] = string3.replace('?', '2');
                        this.hNames[2] = string3.replace('?', '3');
                    }
                    this.setHydrogen(i, ++n, this.hNames[0], p3Array[i][0]);
                    this.setHydrogen(i, ++n, this.hNames[1], p3Array[i][2]);
                    this.setHydrogen(i, ++n, this.hNames[2], p3Array[i][1]);
                }
            }
        }
        this.deleteUnneededAtoms();
        this.ms.fixFormalCharges(BSUtil.newBitSet2(this.ml.baseAtomIndex, this.ml.ms.ac));
    }

    private void deleteUnneededAtoms() {
        BS bS = new BS();
        int n = this.bsAtomsForHs.nextSetBit(0);
        while (n >= 0) {
            Atom atom = this.ms.at[n];
            if (atom.isHetero() && atom.getElementNumber() == 8 && atom.getFormalCharge() == 0 && atom.getCovalentBondCount() == 2) {
                Bond[] bondArray;
                Bond[] bondArray2 = atom.bonds;
                Bond[] bondArray3 = bondArray2[0].getOtherAtom(atom);
                Atom atom2 = bondArray2[1].getOtherAtom(atom);
                if (bondArray3.getElementNumber() == 1) {
                    bondArray = bondArray3;
                    bondArray3 = atom2;
                    atom2 = bondArray;
                }
                if (atom2.getElementNumber() == 1) {
                    bondArray = bondArray3.bonds;
                    for (int i = 0; i < bondArray.length; ++i) {
                        Atom atom3;
                        if (bondArray[i].order != 2 || (atom3 = bondArray[i].getOtherAtom((Atom)bondArray3)).getElementNumber() != 8) continue;
                        this.bsAddedHydrogens.set(atom2.i);
                        atom2.delete(bS);
                        break;
                    }
                }
            }
            n = this.bsAtomsForHs.nextSetBit(n + 1);
        }
        this.ms.deleteBonds(bS, true);
        this.deleteAtoms(this.bsAddedHydrogens);
    }

    private void deleteAtoms(BS bS) {
        int n;
        int[] nArray = new int[this.ms.ac];
        int[] nArray2 = new int[this.ms.ac - bS.cardinality()];
        int n2 = this.ml.baseAtomIndex;
        Model[] modelArray = this.ms.am;
        Atom[] atomArray = this.ms.at;
        for (n = this.ml.baseAtomIndex; n < this.ms.ac; ++n) {
            modelArray[atomArray[n].mi].bsAtoms.clear(n);
            modelArray[atomArray[n].mi].bsAtomsDeleted.clear(n);
            if (bS.get(n)) {
                nArray[n] = n2 - 1;
                --modelArray[atomArray[n].mi].act;
                continue;
            }
            nArray2[n2] = n;
            nArray[n] = n2++;
        }
        this.ms.msInfo.put("bsDeletedAtoms", bS);
        for (n = this.ml.baseGroupIndex; n < this.ml.groups.length; ++n) {
            Group group = this.ml.groups[n];
            if (group.firstAtomIndex < this.ml.baseAtomIndex) continue;
            group.firstAtomIndex = nArray[group.firstAtomIndex];
            group.lastAtomIndex = nArray[group.lastAtomIndex];
            if (group.leadAtomIndex < 0) continue;
            group.leadAtomIndex = nArray[group.leadAtomIndex];
        }
        this.ms.adjustAtomArrays(nArray2, this.ml.baseAtomIndex, n2);
        this.ms.calcBoundBoxDimensions(null, 1.0f);
        this.ms.resetMolecules();
        this.ms.validateBspf(false);
        this.bsAddedMask = BSUtil.deleteBits(this.bsAddedMask, bS);
        for (n = this.ml.baseModelIndex; n < this.ms.mc; ++n) {
            this.fixAnnotations(n, "domains", 1073741925);
            this.fixAnnotations(n, "validation", 1073742189);
        }
    }

    private void fixAnnotations(int n, String string, int n2) {
        Object object;
        Object object2 = this.ml.ms.getInfo(n, string);
        if (object2 != null && (object = ((BioModel)this.ml.ms.bioModelset).getCachedAnnotationMap(string, object2)) != null) {
            this.vwr.getAnnotationParser(false).fixAtoms(n, (SV)object, this.bsAddedMask, n2, 20);
        }
    }

    private void finalizePdbCharges() {
        Atom[] atomArray = this.ms.at;
        int n = this.bsAtomsForHs.nextSetBit(0);
        while (n >= 0) {
            Atom atom = atomArray[n];
            if (atom.group.getNitrogenAtom() == atom && atom.getCovalentBondCount() == 1) {
                atom.setFormalCharge(1);
            }
            if ((n = this.bsAtomsForHs.nextClearBit(n + 1)) < 0) break;
            n = this.bsAtomsForHs.nextSetBit(n + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void finalizePdbMultipleBonds() {
        void var5_11;
        Object object;
        Object object2;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        int n = this.ms.bondCount;
        Bond[] bondArray = this.ms.bo;
        for (int i = this.baseBondIndex; i < n; ++i) {
            Atom object4 = bondArray[i].atom1;
            Atom atom = bondArray[i].atom2;
            object2 = object4.group;
            if (object2 != atom.group) continue;
            object = new SB().append(((Group)object2).getGroup3());
            ((SB)object).append(":");
            String string = object4.getAtomName();
            String string2 = atom.getAtomName();
            if (string.compareTo(string2) > 0) {
                ((SB)object).append(string2).append(":").append(string);
            } else {
                ((SB)object).append(string).append(":").append(string2);
            }
            String string3 = ((SB)object).toString();
            String string4 = this.htBondMap.get(string3);
            if (string4 == null) continue;
            hashtable.put(string3, Boolean.TRUE);
            bondArray[i].setOrder(PT.parseInt(string4));
        }
        for (String string : this.htBondMap.keySet()) {
            if (hashtable.get(string) != null) continue;
            if (string.indexOf(":") < 0) {
                hashtable.put(string, Boolean.TRUE);
                continue;
            }
            String string5 = this.htBondMap.get(string);
            Logger.info("bond " + string + " was not used; order=" + string5);
            if (!this.htBondMap.get(string).equals("1")) continue;
            hashtable.put(string, Boolean.TRUE);
        }
        Hashtable hashtable2 = new Hashtable();
        for (String string : this.htBondMap.keySet()) {
            if (hashtable.get(string) != null) continue;
            hashtable2.put(string.substring(0, string.lastIndexOf(":")), this.htBondMap.get(string));
        }
        if (hashtable2.isEmpty()) {
            return;
        }
        boolean bl = false;
        while (var5_11 < n) {
            Atom atom = bondArray[var5_11].atom1;
            object2 = bondArray[var5_11].atom2;
            if (atom.group != ((Atom)object2).group && ((object = (String)hashtable2.get(atom.getGroup3(false) + ":" + atom.getAtomName())) != null || (object = (String)hashtable2.get(((Atom)object2).getGroup3(false) + ":" + ((Atom)object2).getAtomName())) != null)) {
                bondArray[var5_11].setOrder(PT.parseInt((String)object));
                Logger.info("assigning order " + bondArray[var5_11].order + " to bond " + bondArray[var5_11]);
            }
            ++var5_11;
        }
    }

    private void setHydrogen(int n, int n2, String string, P3 p3) {
        if (!this.bsAddedHydrogens.get(n2)) {
            return;
        }
        Atom[] atomArray = this.ms.at;
        if (this.lastSetH == Integer.MIN_VALUE || atomArray[n2].mi != atomArray[this.lastSetH].mi) {
            this.lastSetH = n2;
            this.maxSerial = ((int[])this.ms.getInfo(atomArray[this.lastSetH].mi, "PDB_CONECT_firstAtom_count_max"))[2];
        }
        this.bsAddedHydrogens.clear(n2);
        this.ms.setAtomName(n2, string);
        atomArray[n2].setT(p3);
        this.ms.setAtomNumber(n2, ++this.maxSerial);
        atomArray[n2].atomSymmetry = atomArray[n].atomSymmetry;
        this.ml.undeleteAtom(n2);
        this.ms.bondAtoms(atomArray[n], atomArray[n2], 1, this.ms.getDefaultMadFromOrder(1), null, 0.0f, true, false);
    }

    @Override
    public Object fixPropertyValue(BS bS, Object object, boolean bl) {
        Atom[] atomArray = this.ms.at;
        float[] fArray = (float[])object;
        float[] fArray2 = new float[bS.cardinality()];
        float f = 0.0f;
        int n = 0;
        int n2 = 0;
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            block3: {
                block2: {
                    block1: {
                        if (atomArray[n3].getElementNumber() != 1) break block1;
                        if (bl) break block2;
                        break block3;
                    }
                    f = fArray[n++];
                }
                fArray2[n2] = f;
            }
            n3 = bS.nextSetBit(n3 + 1);
            ++n2;
        }
        return fArray2;
    }

    static BioPolymer allocateBioPolymer(Group[] groupArray, int n, boolean bl) {
        Group group;
        Object object = null;
        int n2 = 0;
        for (int i = n; i < groupArray.length && (group = groupArray[i]) instanceof Monomer; ++i) {
            Monomer monomer = (Monomer)group;
            if (monomer.bioPolymer != null || object != null && object.getClass() != monomer.getClass() || bl && !monomer.isConnectedAfter((Monomer)object)) break;
            object = monomer;
            ++n2;
        }
        if (n2 < 2) {
            return null;
        }
        Monomer[] monomerArray = new Monomer[n2];
        for (int i = 0; i < n2; ++i) {
            monomerArray[i] = (Monomer)groupArray[n + i];
        }
        if (object instanceof AminoMonomer) {
            return new AminoPolymer(monomerArray);
        }
        if (object instanceof AlphaMonomer) {
            return new AlphaPolymer(monomerArray);
        }
        if (object instanceof NucleicMonomer) {
            return new NucleicPolymer(monomerArray);
        }
        if (object instanceof PhosphorusMonomer) {
            return new PhosphorusPolymer(monomerArray);
        }
        if (object instanceof CarbohydrateMonomer) {
            return new CarbohydratePolymer(monomerArray);
        }
        Logger.error("Polymer.allocatePolymer() ... no matching polymer for monomor " + object);
        throw new NullPointerException();
    }

    @Override
    public void iterateOverAllNewStructures(JmolAdapter jmolAdapter, Object object) {
        JmolAdapterStructureIterator jmolAdapterStructureIterator = jmolAdapter.getStructureIterator(object);
        if (jmolAdapterStructureIterator == null) {
            return;
        }
        BS bS = jmolAdapterStructureIterator.getStructuredModels();
        if (bS != null) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                this.ml.structuresDefinedInFile.set(this.ml.baseModelIndex + n);
                n = bS.nextSetBit(n + 1);
            }
        }
        while (jmolAdapterStructureIterator.hasNext()) {
            if (jmolAdapterStructureIterator.getStructureType() == STR.TURN) continue;
            this.setStructure(jmolAdapterStructureIterator);
        }
        jmolAdapterStructureIterator = jmolAdapter.getStructureIterator(object);
        while (jmolAdapterStructureIterator.hasNext()) {
            if (jmolAdapterStructureIterator.getStructureType() != STR.TURN) continue;
            this.setStructure(jmolAdapterStructureIterator);
        }
    }

    private void setStructure(JmolAdapterStructureIterator jmolAdapterStructureIterator) {
        STR sTR = jmolAdapterStructureIterator.getSubstructureType();
        String string = jmolAdapterStructureIterator.getStructureID();
        int n = jmolAdapterStructureIterator.getSerialID();
        int n2 = jmolAdapterStructureIterator.getStrandCount();
        int[] nArray = jmolAdapterStructureIterator.getAtomIndices();
        int[] nArray2 = jmolAdapterStructureIterator.getModelIndices();
        if (this.bsAssigned == null) {
            this.bsAssigned = new BS();
        }
        this.defineStructure(sTR, string, n, n2, jmolAdapterStructureIterator.getStartChainID(), jmolAdapterStructureIterator.getStartSequenceNumber(), jmolAdapterStructureIterator.getStartInsertionCode(), jmolAdapterStructureIterator.getEndChainID(), jmolAdapterStructureIterator.getEndSequenceNumber(), jmolAdapterStructureIterator.getEndInsertionCode(), nArray, nArray2, this.bsAssigned);
    }

    private void defineStructure(STR sTR, String string, int n, int n2, int n3, int n4, char c, int n5, int n6, char c2, int[] nArray, int[] nArray2, BS bS) {
        STR sTR2 = sTR == STR.NOT ? STR.NONE : sTR;
        int n7 = Group.getSeqcodeFor(n4, c);
        int n8 = Group.getSeqcodeFor(n6, c2);
        Model[] modelArray = this.ms.am;
        if (this.ml.isTrajectory) {
            nArray2[1] = nArray2[0];
        } else {
            nArray2[0] = nArray2[0] + this.ml.baseModelIndex;
            nArray2[1] = nArray2[1] + this.ml.baseModelIndex;
        }
        this.ml.structuresDefinedInFile.setBits(nArray2[0], nArray2[1] + 1);
        for (int i = nArray2[0]; i <= nArray2[1]; ++i) {
            int n9 = modelArray[i].firstAtomIndex;
            if (!(modelArray[i] instanceof BioModel)) continue;
            ((BioModel)modelArray[i]).addSecondaryStructure(sTR2, string, n, n2, n3, n7, n5, n8, n9 + nArray[0], n9 + nArray[1], bS);
        }
    }

    @Override
    public void setGroupLists(int n) {
        this.ml.group3Lists[n + 1] = Group.standardGroupList;
        this.ml.group3Counts[n + 1] = new int[group3Count + 10];
        if (this.ml.group3Lists[0] == null) {
            this.ml.group3Lists[0] = Group.standardGroupList;
            this.ml.group3Counts[0] = new int[group3Count + 10];
        }
    }

    @Override
    public boolean isKnownPDBGroup(String string, int n) {
        short s = Resolver.knownGroupID(string);
        return s > 0 ? s < n : n == Integer.MAX_VALUE && Resolver.checkCarbohydrate(string);
    }

    @Override
    public byte lookupSpecialAtomID(String string) {
        Byte by;
        if (htSpecialAtoms == null) {
            htSpecialAtoms = new Hashtable<String, Byte>();
            int n = specialAtomNames.length;
            while (--n >= 0) {
                String string2 = specialAtomNames[n];
                if (string2 == null) continue;
                htSpecialAtoms.put(string2, (byte)n);
            }
        }
        return (by = htSpecialAtoms.get(string)) == null ? (byte)0 : by;
    }

    private String[][] getPdbBondInfo(String string, boolean bl) {
        String[][] stringArray;
        if (htPdbBondInfo == null) {
            htPdbBondInfo = new Hashtable<String, String[][]>();
        }
        if ((stringArray = htPdbBondInfo.get(string)) != null) {
            return stringArray;
        }
        int n = Resolver.knownGroupID(string);
        if (n < 0 || n > pdbBondInfo.length) {
            return null;
        }
        String string2 = pdbBondInfo[n];
        if (bl && (n = string2.indexOf("O3'")) >= 0) {
            string2 = string2.substring(0, n);
        }
        String[] stringArray2 = PT.getTokens(string2);
        stringArray = new String[stringArray2.length / 2][];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            String string4 = stringArray2[n2++];
            if ((string3 = stringArray2[n2++]).length() == 1) {
                switch (string3.charAt(0)) {
                    case 'N': {
                        string3 = "H@H2";
                        break;
                    }
                    case 'B': {
                        string3 = "HB3@HB2";
                        break;
                    }
                    case 'D': {
                        string3 = "HD3@HD2";
                        break;
                    }
                    case 'G': {
                        string3 = "HG3@HG2";
                        break;
                    }
                    case '2': {
                        string3 = "H2'@H2''";
                        break;
                    }
                    case '5': {
                        string3 = "H5''@H5'";
                    }
                }
            }
            if (string3.charAt(0) != 'H' && string4.compareTo(string3) > 0) {
                string2 = string3;
                string3 = string4;
                string4 = string2;
            }
            stringArray[i] = new String[]{string4, string3, string3.startsWith("H") ? "1" : "2"};
        }
        htPdbBondInfo.put(string, stringArray);
        return stringArray;
    }

    public static short knownGroupID(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        Short s = htGroup.get(string);
        return s == null ? (short)-1 : (short)s;
    }

    private static final boolean checkCarbohydrate(String string) {
        return string != null && allCarbohydrates.indexOf("[" + string.toUpperCase() + "]") >= 0;
    }

    @Override
    public boolean isHetero(String string) {
        switch (string.length()) {
            case 1: {
                string = string + "  ";
                break;
            }
            case 2: {
                string = string + " ";
                break;
            }
            case 3: {
                break;
            }
            default: {
                return true;
            }
        }
        int n = Group.standardGroupList.indexOf(string);
        return n < 0 || n / 6 + 1 >= 42;
    }

    @Override
    public String toStdAmino3(String string) {
        int n;
        if (string.length() == 0) {
            return "";
        }
        SB sB = new SB();
        int n2 = Resolver.knownGroupID("==A");
        if (n2 < 0) {
            for (n = 1; n <= 20; ++n) {
                n2 = Resolver.knownGroupID(predefinedGroup3Names[n]);
                htGroup.put("==" + predefinedGroup1Names[n], (short)n2);
            }
        }
        int n3 = string.length();
        for (n = 0; n < n3; ++n) {
            char c = string.charAt(n);
            n2 = Resolver.knownGroupID("==" + c);
            if (n2 < 0) {
                n2 = 23;
            }
            sB.append(" ").append(predefinedGroup3Names[n2]);
        }
        return sB.toString().substring(1);
    }

    @Override
    public short getGroupID(String string) {
        return Resolver.getGroupIdFor(string);
    }

    static short getGroupIdFor(String string) {
        short s;
        if (string != null) {
            string = string.trim();
        }
        return (s = Resolver.knownGroupID(string)) == -1 ? Resolver.addGroup3Name(string) : s;
    }

    private static synchronized short addGroup3Name(String string) {
        if (group3NameCount == Group.group3Names.length) {
            Group.group3Names = AU.doubleLengthS(Group.group3Names);
        }
        short s = group3NameCount;
        group3NameCount = (short)(s + 1);
        short s2 = s;
        Group.group3Names[s2] = string;
        htGroup.put(string, s2);
        return s2;
    }

    private static int getStandardPdbHydrogenCount(String string) {
        short s = Resolver.knownGroupID(string);
        return s < 0 || s >= pdbHydrogenCount.length ? -1 : pdbHydrogenCount[s];
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean getAminoAcidValenceAndCharge(String string, String string2, int[] nArray) {
        if (string == null) return false;
        if (string.length() == 0) return false;
        if (string.length() > 3) return false;
        if (string2.equals("CA")) return false;
        if (string2.equals("CB")) {
            return false;
        }
        char c = string2.charAt(0);
        char c2 = string2.length() == 1 ? (char)'\u0000' : string2.charAt(1);
        boolean bl = false;
        int n = nArray[3];
        block0 : switch (string.length()) {
            case 3: {
                if (string2.length() == 1) {
                    switch (c) {
                        case 'N': {
                            if (n > 1) {
                                return false;
                            }
                            nArray[1] = 1;
                            break block0;
                        }
                        case 'O': {
                            bl = "HOH;DOD;WAT".indexOf(string) < 0;
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                String string3 = string + c;
                boolean bl2 = bl = aaSp2.indexOf(string3) >= 0;
                if (aaPlus.indexOf(string3) >= 0) {
                    nArray[1] = 1;
                    break;
                }
                if (c != 'O' || c2 != 'X') break;
                nArray[1] = -1;
                break;
            }
            case 1: 
            case 2: {
                if (string2.length() > 2 && string2.charAt(2) == '\'') {
                    return false;
                }
                switch (c) {
                    case 'C': {
                        if (c2 != '7') break;
                        return false;
                    }
                    case 'N': {
                        switch (c2) {
                            case '1': 
                            case '3': {
                                if (naNoH.indexOf("" + string.charAt(string.length() - 1) + c2) < 0) break;
                                nArray[0] = nArray[0] - 1;
                                break;
                            }
                            case '7': {
                                nArray[0] = nArray[0] - 1;
                            }
                        }
                        break;
                    }
                }
                bl = true;
                break;
            }
        }
        if (!bl) return true;
        switch (c) {
            case 'N': {
                nArray[2] = 2;
                return true;
            }
            case 'C': {
                nArray[2] = 2;
                nArray[0] = nArray[0] - 1;
                return true;
            }
            case 'O': {
                nArray[0] = nArray[0] - 1;
                return true;
            }
        }
        return true;
    }

    static final String getSpecialAtomName(int n) {
        return specialAtomNames[n];
    }

    @Override
    public int[] getArgbs(int n) {
        switch (n) {
            case 0x200002: {
                return argbsAmino;
            }
            case 0x40000140: {
                return argbsShapely;
            }
            case 0x44000001: {
                return argbsChainAtom;
            }
            case 0x60200006: {
                return argbsChainHetero;
            }
        }
        return null;
    }

    static {
        pdbBondInfo = new String[]{"", "N N CA HA C O CB HB?", "N N CA HA C O CB B CG G CD D NE HE CZ NH1 NH1 HH11@HH12 NH2 HH22@HH21", "N N CA HA C O CB B CG OD1 ND2 HD21@HD22", "N N CA HA C O CB B CG OD1", "N N CA HA C O CB B SG HG", "N N CA HA C O CB B CG G CD OE1 NE2 HE22@HE21", "N N CA HA C O CB B CG G CD OE1", "N N CA HA2@HA3 C O", "N N CA HA C O CB B CG CD2 ND1 CE1 ND1 HD1 CD2 HD2 CE1 HE1 NE2 HE2", "N N CA HA C O CB HB CG1 HG13@HG12 CG2 HG2? CD1 HD1?", "N N CA HA C O CB B CG HG CD1 HD1? CD2 HD2?", "N N CA HA C O CB B CG G CD HD2@HD3 CE HE3@HE2 NZ HZ?", "N N CA HA C O CB B CG G CE HE?", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 CD2 HD2 CE1 CZ CE1 HE1 CE2 HE2 CZ HZ", "N H CA HA C O CB B CG G CD D", "N N CA HA C O CB B OG HG", "N N CA HA C O CB HB OG1 HG1 CG2 HG2?", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 NE1 HE1 CE3 CZ3 CE3 HE3 CZ2 CH2 CZ2 HZ2 CZ3 HZ3 CH2 HH2", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 CD2 HD2 CE1 CZ CE1 HE1 CE2 HE2 OH HH", "N N CA HA C O CB HB CG1 HG1? CG2 HG2?", "N N CA HA C O CB B", "N N CA HA C O CB B CG G", "", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 N2 H22@H21 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C2 O2 N3 C4 N4 H41@H42 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 N1 N6 H61@H62 C2 N3 C2 H2 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C7 H7? C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 C2 H2 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 N2 H22@H21 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 C4 N4 H41@H42 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 N1 N6 H61@H62 C2 N3 C2 H2 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C7 H7? C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 C2 H2 O3' HO3' O5' HO5'"};
        pdbHydrogenCount = new int[]{0, 6, 16, 7, 6, 6, 9, 8, 4, 9, 12, 12, 14, 10, 10, 8, 6, 8, 11, 10, 10, 3, 5, 0, 13, 13, 13, -1, 12, 12, 13, 13, 13, 14, 12, 12};
        predefinedGroup1Names = new char[]{'\u0000', 'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V', 'A', 'G', '?', 'G', 'C', 'A', 'T', 'U', 'I', 'G', 'C', 'A', 'T', 'U', 'I', 'G', 'C', 'A', 'T', 'U', 'I'};
        predefinedGroup3Names = new String[]{"   ", "ALA", "ARG", "ASN", "ASP", "CYS", "GLN", "GLU", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL", "ASX", "GLX", "UNK", "G  ", "C  ", "A  ", "T  ", "U  ", "I  ", "DG ", "DC ", "DA ", "DT ", "DU ", "DI ", "+G ", "+C ", "+A ", "+T ", "+U ", "+I ", "HOH", "DOD", "WAT", "UREA", "PO4", "SO4", "UNL"};
        specialAtomNames = new String[]{null, "N", "CA", "C", "O", "O1", "O5'", "C5'", "C4'", "C3'", "O3'", "C2'", "C1'", "P", "OD1", "OD2", "OE1", "OE2", "SG", null, null, null, null, null, null, null, null, null, null, null, null, null, "N1", "C2", "N3", "C4", "C5", "C6", "O2", "N7", "C8", "N9", "N4", "N2", "N6", "C5M", "O6", "O4", "S4", "C7", "H1", "H2", "H3", null, null, null, null, null, null, null, null, null, null, null, "OXT", "H", "1H", "2H", "3H", "HA", "1HA", "2HA", "H5T", "O5T", "O1P", "OP1", "O2P", "OP2", "O4'", "O2'", "1H5'", "2H5'", "H4'", "H3'", "1H2'", "2H2'", "2HO'", "H1'", "H3T", "HO3'", "HO5'", "HA2", "HA3", "HA2", "H5'", "H5''", "H2'", "H2''", "HO2'", "O3P", "OP3"};
        ATOMID_MAX = specialAtomNames.length;
        argbsAmino = new int[]{-4284306, -3618616, -15443201, -16720676, -1701366, -1645056, -16720676, -1701366, -1315861, -8224046, -15760881, -15760881, -15443201, -1645056, -13487446, -2320766, -354816, -354816, -4957516, -13487446, -15760881, -38476, -38476, -4284306};
        argbsChainAtom = new int[]{-1, -4140801, -5177424, -16184, -128, -16129, -5181200, -12176, -1015680, -663885, -16728065, -3318692, -10039894, -6632142, -1146130, -16724271, -16711809, -12799119, -16777077, -4343957, -16751616, -8388608, -8355840, -8388480, -16744320, -4684277, -5103070};
        argbsChainHetero = new int[]{-1, -7298865, -8335464, -3174224, -3158160, -3174193, -8339264, -3170208, -4173712, -3821949, -16734257, -4895668, -11094638, -7686870, -4296002, -16730463, -16724113, -13329567, -16777029, -5922981, -16739328, -5242880, -5197824, -5242704, -16731984, -1526253, -4050382};
        argbsShapely = new int[]{-65281, -16777092, -33680, -7536756, -6291390, -144, -46004, -10092544, -1, -9408257, -16757760, -12231099, -12105800, -11318190, -4677566, -11382190, -36798, -4699136, -11581952, -7573428, -29441, -65281, -65281, -65281, -36752, -29621, -6250241, -6226016, -32640, -8323073, -36752, -29621, -6250241, -6226016, -32640, -8323073, -36752, -29621, -6250241, -6226016, -32640, -8323073};
        if (argbsShapely.length != 42) {
            Logger.error("argbsShapely wrong length");
            throw new NullPointerException();
        }
        if (argbsAmino.length != 24) {
            Logger.error("argbsAmino wrong length");
            throw new NullPointerException();
        }
        if (argbsChainHetero.length != argbsChainAtom.length) {
            Logger.error("argbsChainHetero wrong length");
            throw new NullPointerException();
        }
    }
}

