/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javajs.util.PT;

public class AwtClipboard
implements Transferable {
    private Image image;
    private String text;

    public static void setClipboard(Object textOrImage) {
        AwtClipboard sel = new AwtClipboard(textOrImage);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, null);
    }

    private AwtClipboard(Object image) {
        if (image instanceof String) {
            this.text = (String)image;
        } else {
            this.image = (Image)image;
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray;
        if (this.text == null) {
            DataFlavor[] dataFlavorArray2 = new DataFlavor[1];
            dataFlavorArray = dataFlavorArray2;
            dataFlavorArray2[0] = DataFlavor.imageFlavor;
        } else {
            DataFlavor[] dataFlavorArray3 = new DataFlavor[1];
            dataFlavorArray = dataFlavorArray3;
            dataFlavorArray3[0] = DataFlavor.stringFlavor;
        }
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DataFlavor.imageFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (DataFlavor.imageFlavor.equals(flavor)) {
            return this.image;
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return this.text;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public static String getClipboardText() {
        String result;
        block10: {
            int length;
            List fileList;
            block11: {
                Transferable contents;
                block9: {
                    result = null;
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    contents = clipboard.getContents(null);
                    if (contents != null) break block9;
                    return null;
                }
                if (contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    result = (String)contents.getTransferData(DataFlavor.stringFlavor);
                    break block10;
                }
                if (!contents.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) break block10;
                Object o = contents.getTransferData(DataFlavor.javaFileListFlavor);
                fileList = (List)o;
                length = fileList.size();
                if (length != 0) break block11;
                return null;
            }
            try {
                if (length == 1) {
                    result = "LoAd " + PT.esc(((File)fileList.get(0)).getAbsolutePath().replace('\\', '/'));
                    if (result.endsWith(".pse\"")) {
                        result = String.valueOf(result) + " filter 'DORESIZE'";
                    }
                } else {
                    result = "LoAd files ";
                    int i = 0;
                    while (i < length) {
                        result = String.valueOf(result) + " " + PT.esc(((File)fileList.get(i)).getAbsolutePath().replace('\\', '/'));
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                result = ex.toString();
            }
        }
        return result;
    }
}

