/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.MeshSurface;
import org.jmol.util.Normix;
import org.jmol.viewer.Viewer;

public class Mesh
extends MeshSurface {
    public static final String PREVIOUS_MESH_ID = "+PREVIOUS_MESH+";
    public String[] title;
    public short meshColix;
    public short[] normixes;
    public Lst<P3[]> lineData;
    public String thisID;
    public boolean isValid = true;
    public String scriptCommand;
    public String colorCommand;
    public P3 lattice;
    public M4[] symops;
    public short[][] symopNormixes;
    public boolean visible = true;
    public int lighting = 1073741958;
    public int colorType;
    public boolean haveXyPoints;
    public int diameter;
    public float width;
    public P3 ptCenter;
    public Mesh linkedMesh;
    public Map<String, BS> vertexColorMap;
    public V3 vAB;
    public V3 vTemp;
    public int color;
    public boolean useColix = true;
    public SymmetryInterface unitCell;
    public float scale3d = 0.0f;
    public int index;
    public int atomIndex = -1;
    public int modelIndex = -1;
    public int visibilityFlags;
    public boolean insideOut;
    public int checkByteCount;
    private boolean normalsInverted;
    public boolean showContourLines = false;
    public boolean showPoints = false;
    public boolean drawTriangles = false;
    public boolean fillTriangles = true;
    public boolean showTriangles = false;
    public boolean frontOnly = false;
    public boolean isShell = false;
    public boolean isTwoSided = true;
    public boolean havePlanarContours = false;
    protected BS bsTemp;
    public boolean colorDensity;
    public Object cappingObject;
    public Object slabbingObject;
    public float volumeRenderPointSize = 0.15f;
    public int[] connectedAtoms;
    public boolean isModelConnected;
    public boolean recalcAltVertices;
    public short[] symopColixes;

    public void setVisibilityFlags(int n) {
        this.visibilityFlags = n;
    }

    public Mesh mesh1(Viewer viewer, String string, short s, int n) {
        if (PREVIOUS_MESH_ID.equals(string)) {
            string = null;
        }
        this.vwr = viewer;
        this.thisID = string;
        this.colix = s;
        this.index = n;
        this.ptCenter = new P3();
        this.vAB = new V3();
        this.vTemp = new V3();
        return this;
    }

    public void clear(String string) {
        this.clearMesh(string);
    }

    public void clearMesh(String string) {
        this.altVertices = null;
        this.bsDisplay = null;
        this.bsSlabDisplay = null;
        this.bsSlabGhost = null;
        this.symops = null;
        this.symopColixes = null;
        this.cappingObject = null;
        this.colix = (short)23;
        this.colorDensity = false;
        this.connectedAtoms = null;
        this.diameter = 0;
        this.drawTriangles = false;
        this.fillTriangles = true;
        this.frontOnly = false;
        this.isShell = false;
        this.havePlanarContours = false;
        this.haveXyPoints = false;
        this.isModelConnected = false;
        this.isTriangleSet = false;
        this.isTwoSided = false;
        this.lattice = null;
        this.mat4 = null;
        this.normixes = null;
        this.pis = null;
        this.scale3d = 0.0f;
        this.showContourLines = false;
        this.showPoints = false;
        this.showTriangles = false;
        this.slabbingObject = null;
        this.slabOptions = null;
        this.spanningVectors = null;
        this.symopNormixes = null;
        this.title = null;
        this.unitCell = null;
        this.useColix = true;
        this.pc = 0;
        this.vc = 0;
        this.polygonCount0 = 0;
        this.vertexCount0 = 0;
        this.vs = null;
        this.vertexSource = null;
        this.volumeRenderPointSize = 0.15f;
        this.meshType = string;
    }

    public void initialize(int n, T3[] t3Array, P4 p4) {
        if (t3Array == null) {
            t3Array = this.vs;
        }
        V3[] v3Array = this.getNormals(t3Array, p4);
        this.setNormixes(v3Array);
        this.lighting = 1073741958;
        if (this.insideOut) {
            this.invertNormixes();
        }
        if (this.isShell && !this.isTwoSided) {
            this.invertNormixes();
        }
        this.setLighting(n);
    }

    public short[] setNormixes(V3[] v3Array) {
        if (v3Array == null) {
            this.normixes = null;
            return null;
        }
        this.normixes = new short[this.normixCount];
        if (this.bsTemp == null) {
            this.bsTemp = Normix.newVertexBitSet();
        }
        if (this.haveXyPoints) {
            int n = this.normixCount;
            while (--n >= 0) {
                this.normixes[n] = 9999;
            }
        } else {
            int n = this.normixCount;
            while (--n >= 0) {
                this.normixes[n] = Normix.getNormixV(v3Array[n], this.bsTemp);
            }
        }
        return this.normixes;
    }

    public V3[] getNormals(T3[] t3Array, P4 p4) {
        int n = this.normixCount = this.isTriangleSet ? this.pc : this.vc;
        if (this.normixCount < 0) {
            return null;
        }
        V3[] v3Array = new V3[this.normixCount];
        int n2 = this.normixCount;
        while (--n2 >= 0) {
            v3Array[n2] = new V3();
        }
        if (p4 == null) {
            this.sumVertexNormals(t3Array, v3Array);
        } else {
            V3 v3 = V3.new3(p4.x, p4.y, p4.z);
            int n3 = this.normixCount;
            while (--n3 >= 0) {
                v3Array[n3] = v3;
            }
        }
        if (!this.isTriangleSet) {
            int n4 = this.normixCount;
            while (--n4 >= 0) {
                v3Array[n4].normalize();
            }
        }
        return v3Array;
    }

    public void setLighting(int n) {
        boolean bl = this.isTwoSided = n == 1073741964;
        if (n == this.lighting) {
            return;
        }
        this.flipLighting(this.lighting);
        this.lighting = n;
        this.flipLighting(this.lighting);
    }

    private void flipLighting(int n) {
        if (n == 1073741964) {
            int n2 = this.normixCount;
            while (--n2 >= 0) {
                this.normixes[n2] = ~this.normixes[n2];
            }
        } else if (n == 1073741958 == this.insideOut) {
            this.invertNormixes();
        }
    }

    private void invertNormixes() {
        Normix.setInverseNormixes();
        this.normalsInverted = !this.normalsInverted;
        int n = this.normixCount;
        while (--n >= 0) {
            this.normixes[n] = Normix.getInverseNormix(this.normixes[n]);
        }
    }

    public void setTranslucent(boolean bl, float f) {
        this.colix = C.getColixTranslucent3(this.colix, bl, f);
    }

    protected void sumVertexNormals(T3[] t3Array, V3[] v3Array) {
        Mesh.sumVertexNormals2(this, t3Array, v3Array);
    }

    protected static void sumVertexNormals2(Mesh mesh, T3[] t3Array, V3[] v3Array) {
        int n = mesh.checkByteCount;
        float f = mesh.getMinDistance2ForVertexGrouping();
        int n2 = mesh.pc;
        while (--n2 >= 0) {
            try {
                int[] nArray = mesh.setABC(n2);
                if (nArray == null) continue;
                T3 t3 = t3Array[nArray[0]];
                T3 t32 = t3Array[nArray[1]];
                T3 t33 = t3Array[nArray[2]];
                if (t3.distanceSquared(t32) < f || t32.distanceSquared(t33) < f || t3.distanceSquared(t33) < f) continue;
                Measure.calcNormalizedNormal(t3, t32, t33, mesh.vTemp, mesh.vAB);
                if (mesh.isTriangleSet) {
                    v3Array[n2].setT(mesh.vTemp);
                    continue;
                }
                float f2 = mesh.vTemp.length();
                if (!((double)f2 > 0.9) || !((double)f2 < 1.1)) continue;
                int n3 = nArray.length - n;
                while (--n3 >= 0) {
                    int n4 = nArray[n3];
                    v3Array[n4].add(mesh.vTemp);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    protected float getMinDistance2ForVertexGrouping() {
        return 1.0E-8f;
    }

    public String getState(String string) {
        SB sB = new SB();
        if (this.isValid) {
            sB.append(string);
            if (!string.equals("mo") && !string.equals("nbo")) {
                sB.append(" ID ").append(PT.esc(this.thisID));
            }
            if (this.lattice != null) {
                sB.append(" lattice ").append(Escape.eP(this.lattice));
            }
            if (this.meshColix != 0) {
                sB.append(" color mesh ").append(C.getHexCode(this.meshColix));
            }
            sB.append(this.getRendering());
            if (!this.visible) {
                sB.append(" hidden");
            }
            if (this.bsDisplay != null) {
                sB.append(";\n  ").append(string);
                if (!string.equals("mo") && !string.equals("nbo")) {
                    sB.append(" ID ").append(PT.esc(this.thisID));
                }
                sB.append(" display " + Escape.eBS(this.bsDisplay));
            }
        }
        return sB.toString();
    }

    protected String getRendering() {
        SB sB = new SB();
        sB.append(this.fillTriangles ? " fill" : " noFill");
        sB.append(this.drawTriangles ? " mesh" : " noMesh");
        sB.append(this.showPoints ? " dots" : " noDots");
        sB.append(this.frontOnly ? " frontOnly" : " notFrontOnly");
        if (this.showContourLines) {
            sB.append(" contourlines");
        }
        if (this.showTriangles) {
            sB.append(" triangles");
        }
        sB.append(" ").append(T.nameOf(this.lighting));
        if (this.isShell && !this.isTwoSided) {
            sB.append(" backshell");
        }
        return sB.toString();
    }

    public P3[] getOffsetVertices(P4 p4) {
        if (this.altVertices != null && !this.recalcAltVertices) {
            return (P3[])this.altVertices;
        }
        this.altVertices = new P3[this.vc];
        for (int i = 0; i < this.vc; ++i) {
            this.altVertices[i] = P3.newP(this.vs[i]);
        }
        V3 v3 = null;
        float f = 0.0f;
        if (this.scale3d != 0.0f && this.vvs != null && p4 != null) {
            v3 = V3.new3(p4.x, p4.y, p4.z);
            v3.normalize();
            v3.scale(this.scale3d);
            if (this.mat4 != null) {
                M3 m3 = new M3();
                this.mat4.getRotationScale(m3);
                m3.rotate(v3);
            }
        }
        for (int i = 0; i < this.vc; ++i) {
            if (this.vvs != null && Float.isNaN(f = this.vvs[i])) continue;
            P3 p3 = (P3)this.altVertices[i];
            if (this.mat4 != null) {
                this.mat4.rotTrans(p3);
            }
            if (v3 == null || f == 0.0f) continue;
            p3.scaleAdd2(f, v3, p3);
        }
        this.initialize(this.lighting, this.altVertices, null);
        this.recalcAltVertices = false;
        return (P3[])this.altVertices;
    }

    public void setShowWithin(Lst<P3> lst, float f, boolean bl) {
        if (lst.size() == 0) {
            this.bsDisplay = bl ? BSUtil.newBitSet2(0, this.vc) : null;
            return;
        }
        this.bsDisplay = new BS();
        for (int i = 0; i < this.vc; ++i) {
            if (!Mesh.checkWithin(this.vs[i], lst, f, bl)) continue;
            this.bsDisplay.set(i);
        }
    }

    public static boolean checkWithin(T3 t3, Lst<P3> lst, float f, boolean bl) {
        if (lst.size() != 0) {
            int n = lst.size();
            while (--n >= 0) {
                if (!(t3.distanceSquared((T3)lst.get(n)) <= f)) continue;
                return !bl;
            }
        }
        return bl;
    }

    public int getVertexIndexFromNumber(int n) {
        if (--n < 0) {
            n = this.vc + n;
        }
        return this.vc <= n ? this.vc - 1 : (n < 0 ? 0 : n);
    }

    public BS getVisibleVertexBitSet() {
        return this.getVisibleVBS();
    }

    protected BS getVisibleVBS() {
        BS bS = new BS();
        if (this.pc == 0 && this.bsSlabDisplay != null) {
            BSUtil.copy2(this.bsSlabDisplay, bS);
        } else {
            int n = this.pc;
            while (--n >= 0) {
                int[] nArray;
                if (this.bsSlabDisplay != null && !this.bsSlabDisplay.get(n) || (nArray = this.pis[n]) == null) continue;
                bS.set(nArray[0]);
                bS.set(nArray[1]);
                bS.set(nArray[2]);
            }
        }
        return bS;
    }

    public void setTokenProperty(int n, boolean bl) {
        switch (n) {
            case 0x40000088: 
            case 1073742058: {
                this.frontOnly = n == 0x40000088 ? bl : !bl;
                return;
            }
            case 1073741862: 
            case 1073742057: {
                if (!this.isTwoSided && this.isShell != (n == 1073741862 ? bl : !bl)) {
                    this.isShell = !this.isShell;
                    this.invertNormixes();
                }
                return;
            }
            case 1073741861: 
            case 1073741958: 
            case 1073741964: {
                this.setLighting(n);
                return;
            }
            case 1073742042: 
            case 1112150019: {
                this.showPoints = n == 1112150019 ? bl : !bl;
                return;
            }
            case 1073742018: 
            case 0x400000E4: {
                this.drawTriangles = n == 1073742018 ? bl : !bl;
                return;
            }
            case 1073741938: 
            case 1073742046: {
                this.fillTriangles = n == 1073741938 ? bl : !bl;
                return;
            }
            case 1073742060: 
            case 1073742182: {
                this.showTriangles = n == 1073742182 ? bl : !bl;
                return;
            }
            case 0x4000004A: 
            case 1073742039: {
                this.showContourLines = n == 0x4000004A ? bl : !bl;
                return;
            }
        }
    }

    Object getInfo(boolean bl) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("id", this.thisID);
        hashtable.put("vertexCount", this.vc);
        hashtable.put("polygonCount", this.pc);
        hashtable.put("haveQuads", this.haveQuads);
        hashtable.put("haveValues", this.vvs != null);
        if (bl) {
            if (this.vc > 0) {
                hashtable.put("vertices", AU.arrayCopyPt(this.vs, this.vc));
                if (this.bsSlabDisplay != null) {
                    hashtable.put("bsVertices", this.getVisibleVBS());
                }
            }
            if (this.vvs != null) {
                hashtable.put("vertexValues", AU.arrayCopyF(this.vvs, this.vc));
            }
            if (this.pc > 0) {
                hashtable.put("polygons", AU.arrayCopyII(this.pis, this.pc));
                if (this.bsSlabDisplay != null) {
                    hashtable.put("bsPolygons", this.bsSlabDisplay);
                }
            }
        }
        return hashtable;
    }

    public P3[] getBoundingBox() {
        return null;
    }

    public SymmetryInterface getUnitCell() {
        return null;
    }

    public void rotateTranslate(Quat quat, T3 t3, boolean bl) {
        if (quat == null && t3 == null) {
            this.mat4 = null;
            return;
        }
        M3 m3 = new M3();
        V3 v3 = new V3();
        if (this.mat4 == null) {
            this.mat4 = M4.newM4(null);
        }
        this.mat4.getRotationScale(m3);
        this.mat4.getTranslation(v3);
        if (quat == null) {
            if (bl) {
                v3.setT(t3);
            } else {
                v3.add(t3);
            }
        } else {
            m3.mul(quat.getMatrix());
        }
        this.mat4 = M4.newMV(m3, v3);
        this.recalcAltVertices = true;
    }

    public V3[] getNormalsTemp() {
        V3[] v3Array;
        if (this.normalsTemp == null) {
            this.normalsTemp = this.getNormals(this.vs, null);
            v3Array = this.normalsTemp;
        } else {
            v3Array = this.normalsTemp;
        }
        return v3Array;
    }
}

