/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.script.SV;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBODialog;
import org.openscience.jmol.app.nbo.NBOJobQueueManager;

public class NBOService {
    static final int MODE_ERROR = -1;
    static final int MODE_RAW = 0;
    static final int MODE_MODEL = 1;
    static final int MODE_RUN = 20;
    static final int MODE_VIEW = 30;
    static final int MODE_SEARCH = 40;
    static final int MODE_VIEW_LIST = 33;
    static final int MODE_SEARCH_VALUE = 45;
    static final int MODE_SEARCH_LIST = 46;
    static final int MODE_SEARCH_SELECT = 47;
    static final int MODE_IMAGE = 88;
    private static final int MODE_ERR = -1;
    private int serverMode = 0;
    protected Viewer vwr;
    NBODialog nboDialog;
    protected Process nboServer;
    protected Thread nboListener;
    private InputStream stdout;
    protected BufferedReader nboReader;
    private PrintWriter stdinWriter;
    protected static NBOJobQueueManager manager;
    private SB sbRet;
    private boolean inData;
    protected boolean isWorking;
    String serverPath;
    String serverDir;
    String workingPath;
    private boolean nboSync;
    private String nboModel;
    protected int dialogMode;
    private Object lock = "jmol_lock";
    public boolean jobCanceled;

    public NBOService(Viewer viewer) {
        this.vwr = viewer;
        this.sbRet = new SB();
        Properties properties = JmolPanel.historyFile.getProperties();
        this.setServerPath(properties.getProperty("nboServerPath", System.getProperty("user.home") + "/NBOServe"));
        this.setWorkingPath(null);
        if (manager == null) {
            manager = new NBOJobQueueManager();
        }
    }

    private void setServerPath(String string) {
        this.serverPath = string;
        this.serverDir = new File(this.serverPath).getParent() + "/";
    }

    void setWorkingPath(String string) {
        this.workingPath = string == null ? this.vwr.getDefaultDirectory() + "/nbo" : string;
        File file = new File(this.workingPath);
        if (!file.exists()) {
            file.mkdir();
        }
        System.out.println("NBOService setting directory to " + file);
    }

    public boolean processRequest(Map<String, Object> map, int n) {
        String string;
        boolean bl = false;
        boolean bl2 = map.get("sync") == Boolean.TRUE;
        boolean bl3 = false;
        this.dialogMode = n;
        if (this.nboServer != null) {
            try {
                this.nboServer.exitValue();
                bl3 = true;
                System.out.println("NBOServe.exe has closed unexpectedly!");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl2 || this.nboSync || this.nboServer == null || bl3) {
            this.closeProcess();
            this.startProcess(bl2, this.dialogMode);
        }
        this.serverMode = (Integer)map.get("mode");
        if (this.stdinWriter == null) {
            this.closeProcess();
            this.sbRet.append("ERROR: Could not connect to NBOServe -- Use Tools...NBO... to set up NBOServe");
            this.serverMode = -1;
        }
        String string2 = (String)map.get("action");
        switch (this.serverMode) {
            case 1: {
                string = (String)map.get("value");
                if (string2.equals("load")) {
                    string = "sh " + string;
                    break;
                }
                if (string2.equals("run")) break;
                string = null;
                break;
            }
            case 0: 
            case 33: 
            case 88: {
                string = (String)map.get("value");
                if (!string.startsWith("<")) break;
                string = "\n" + string;
                break;
            }
            default: {
                this.nboReport("unknown mode", -1);
                string = null;
            }
        }
        if (string != null) {
            if (bl2) {
                this.clearServerFile("fort.106");
                this.clearServerFile("jmol_molfile.txt");
            }
            this.sendToNBO(this.serverMode, string);
            if (bl2) {
                this.waitFor(this.serverMode);
            }
            bl = true;
        }
        if (bl2) {
            map.put("ret", this.sbRet.toString());
            this.sbRet.setLength(0);
        }
        return bl;
    }

    private boolean waitFor(int n) {
        String string = this.serverDir + (n == 1 ? "jmol_molfile.txt" : "fort.106");
        File file = new File(string);
        for (int i = 0; i < 200; ++i) {
            if (file.exists()) {
                switch (n) {
                    case 1: {
                        String string2 = this.fixNBOModel(this.getFileData(string));
                        Logger.info(string2);
                        this.sbRet.append(string2 + ";rotate best;");
                        break;
                    }
                }
                break;
            }
            try {
                Thread.sleep(10L);
                System.out.println("NBOService.waitfor()");
                continue;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    private boolean clearServerFile(String string) {
        File file = new File(this.serverDir + string);
        try {
            file.delete();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void sendToNBO(int n, String string) {
        string = n == 0 ? string : "\r\n" + n + "\r\n" + string + "\r\nexit\r\n" + (this.nboSync ? "x\r\n" : "");
        this.sendCmd(string);
    }

    private void sendCmd(String string) {
        System.out.println("sending " + string);
        if (string.startsWith("\n<")) {
            System.out.println(this.getFileData(this.serverDir + PT.trim(string, "\n<>")));
        }
        try {
            this.stdinWriter.println(string);
            this.stdinWriter.flush();
            Thread.sleep(10L);
            System.out.println("NBOService.sendCmd()");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void nboReport(String string, int n) {
        if (Logger.debugging) {
            Logger.debug(this.inData + " " + this.nboSync + " " + this.sbRet.length() + " " + "receiving: " + string);
        }
        if (string.startsWith("DATA \" \"")) {
            this.isWorking = false;
        } else if (string.startsWith("DATA ")) {
            if (string.startsWith("DATA \"model")) {
                this.sbRet.setLength(0);
                string = this.fixNBOModel(string);
            }
            boolean bl = this.inData = string.indexOf("exit") < 0;
            if (this.inData) {
                this.sbRet.append(string + "\n");
            }
            return;
        }
        if (!this.inData && string.indexOf("NBO") < 0 && n == 1) {
            this.nboDialog.addLine(10, string);
        }
        if (this.inData && this.sbRet != null) {
            this.sbRet.append(string + "\n");
            if (string.indexOf("END") >= 0) {
                this.inData = false;
                String string2 = "\"" + this.nboModel + "\"";
                this.nboModel = "\u0000";
                if (!this.nboSync && string.indexOf(string2) >= 0) {
                    String string3 = this.sbRet.toString();
                    this.sbRet.setLength(0);
                    if (string3.contains("\\")) {
                        string3 = string3.replaceAll("\\\\", "");
                    }
                    this.runScriptQueued(string3);
                }
                return;
            }
        }
    }

    private String fixNBOModel(String string) {
        this.nboModel = PT.getQuotedStringAt(string, 0);
        String string2 = " NBO " + this.nboModel;
        int n = string.indexOf("\n");
        return n < 0 ? string + string2 : string.substring(0, n) + string2 + string.substring(n);
    }

    String startProcess(boolean bl, int n) {
        this.dialogMode = n;
        try {
            System.out.println("starting NBO process sync=" + bl);
            this.nboSync = bl;
            File file = new File(this.serverPath);
            ProcessBuilder processBuilder = new ProcessBuilder(this.serverPath);
            processBuilder.directory(new File(file.getParent()));
            processBuilder.redirectErrorStream(true);
            this.nboServer = processBuilder.start();
            this.stdout = this.nboServer.getInputStream();
            this.nboReader = new BufferedReader(new InputStreamReader(this.stdout));
            this.nboListener = null;
            this.nboListener = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    System.out.println("nboListener " + this + " running");
                    while (!Thread.currentThread().isInterrupted()) {
                        String string = null;
                        try {
                            Thread.sleep(25L);
                            System.out.println("NBOService.startProcess()");
                            while ((string = NBOService.this.nboReader.readLine()) != null) {
                                Thread.sleep(1L);
                                System.out.println("NBOService.line");
                                if (string.indexOf("DATA \" \"") >= 0) {
                                    Logger.info(" [NBO opener ignored]");
                                    bl2 = true;
                                    continue;
                                }
                                if (string.indexOf("END \"\"") >= 0) {
                                    bl2 = false;
                                    continue;
                                }
                                if (bl2) continue;
                                Logger.info(string);
                                if (string.indexOf("*start*") >= 0) {
                                    NBOService.this.isWorking = true;
                                    bl3 = true;
                                    bl = true;
                                    NBOService.this.nboDialog.addLine(0, null);
                                    continue;
                                }
                                if (string.indexOf("Permission denied") >= 0 || string.indexOf("PGFIO-F") >= 0 || string.indexOf("Invalid command") >= 0) {
                                    NBOService.this.nboDialog.alert(string + "\n\nNBOServe could not access key files -- Is another version running? Perhaps NBOPro?");
                                    NBOService.this.isWorking = false;
                                    bl3 = false;
                                    NBOService.this.isWorking = false;
                                    manager.clearQueue();
                                    continue;
                                }
                                if (string.indexOf("missing or invalid") >= 0) {
                                    NBOService.this.vwr.alert(string);
                                    manager.clearQueue();
                                }
                                if (string.indexOf("FORTRAN STOP") >= 0) {
                                    NBOService.this.vwr.alert("NBOServe has stopped working");
                                    NBOService.this.restart();
                                }
                                if (string.indexOf("*end*") >= 0) {
                                    if (bl) {
                                        NBOService.this.isWorking = false;
                                    }
                                    bl = false;
                                    bl3 = false;
                                    continue;
                                }
                                switch (NBOService.this.dialogMode) {
                                    case 33: 
                                    case 45: {
                                        if (!NBOService.this.isWorking || !bl3) break;
                                        NBOService.this.nboDialog.addLine(30, string);
                                        break;
                                    }
                                    case 46: {
                                        if (!NBOService.this.isWorking || !bl3) break;
                                        NBOService.this.nboDialog.addLine(-1, string);
                                        break;
                                    }
                                    case 47: {
                                        if (!string.startsWith(" Select")) break;
                                        NBOService.this.nboDialog.addLine(40, string);
                                        bl3 = false;
                                        NBOService.this.isWorking = false;
                                        break;
                                    }
                                    case 88: {
                                        if (!string.startsWith("END")) break;
                                        bl3 = false;
                                        NBOService.this.isWorking = false;
                                        break;
                                    }
                                    case 1: {
                                        if (string.indexOf("can't do that") >= 0) {
                                            NBOService.this.nboDialog.addLine(10, string);
                                            bl3 = false;
                                            NBOService.this.isWorking = false;
                                            break;
                                        }
                                    }
                                    default: {
                                        NBOService.this.nboReport(string, NBOService.this.dialogMode);
                                    }
                                }
                                try {
                                    int n = NBOService.this.nboServer.exitValue();
                                    NBOService.this.closeProcess();
                                    System.out.println("NBOService test = " + n);
                                    return;
                                }
                                catch (Exception exception) {
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            NBOService.this.closeProcess();
                            return;
                        }
                    }
                }
            });
            this.nboListener.setName("NBOServiceThread" + System.currentTimeMillis());
            this.nboListener.start();
            this.stdinWriter = new PrintWriter(this.nboServer.getOutputStream());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return iOException.getMessage();
        }
        return null;
    }

    void closeProcess() {
        this.isWorking = false;
        this.stdout = null;
        try {
            this.stdinWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stdinWriter = null;
        try {
            this.nboReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nboReader = null;
        try {
            this.nboListener.interrupt();
        }
        catch (Exception exception) {
            System.out.println("can't interrupt");
        }
        this.nboListener = null;
        try {
            this.nboServer.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nboServer = null;
    }

    String restart() {
        this.closeProcess();
        return this.startProcess(false, 0);
    }

    public boolean restartIfNecessary() {
        if (this.nboServer == null) {
            this.startProcess(false, 0);
        }
        return this.nboServer != null;
    }

    void runScriptQueued(String string) {
        Logger.info("NBO->JMOL ASYNC: " + string);
        this.vwr.script(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String runScriptNow(String string) {
        Object object = this.lock;
        synchronized (object) {
            Logger.info("NBO->JMOL SYNC: " + string);
            return this.vwr.runScript(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SV evaluateJmol(String string) {
        Object object = this.lock;
        synchronized (object) {
            return this.vwr.evaluateExpressionAsVariable(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String evaluateJmolString(String string) {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluateJmol(string).asString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getJmolFilename() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluateJmolString("getProperty('filename')");
        }
    }

    protected void rawCmdNew(String string, SB sB, boolean bl, int n) {
        bl = true;
        String string2 = null;
        File file = null;
        try {
            if (sB == null) {
                Logger.info("issuing\n" + string);
            } else {
                string2 = string + "_test.txt";
                file = new File(this.serverDir + string2);
                Logger.info("issuing " + string2 + "\n" + sB);
                this.writeToFile(sB.toString(), file);
                string = "<" + string2 + ">";
                this.isWorking = bl;
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("mode", 0);
            hashtable.put("sync", Boolean.FALSE);
            hashtable.put("action", "cmd");
            hashtable.put("value", string);
            if (!this.processRequest(hashtable, n)) {
                this.nboReport(null, n);
                this.nboReport("not implemented", n);
                this.isWorking = false;
            }
            if (bl) {
                while (this.isWorking) {
                    System.out.println("NBOService rawCmd");
                    Thread.sleep(10L);
                }
            }
            if (file != null) {
                file = new File(this.serverDir + string2 + "DONE");
                this.writeToFile("", file);
            }
        }
        catch (IOException iOException) {
            System.out.println("Could not write to " + string2);
            this.isWorking = false;
        }
        catch (InterruptedException interruptedException) {
            this.isWorking = false;
        }
    }

    void writeToFile(String string, File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.print(string);
        printWriter.close();
        Logger.info(string.length() + " bytes written to " + file + "\n" + string);
    }

    String getFileData(String string) {
        return this.vwr.getFileAsString4(string, Integer.MAX_VALUE, false, false, false, "nbo");
    }

    public void queueJob(String string, String string2, Runnable runnable) {
        manager.addJob(this, string, string2, runnable);
    }
}

