/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class Metadata {
    @NotNull
    private final Map<Class<? extends Directory>, Collection<Directory>> _directoryListByClass = new HashMap<Class<? extends Directory>, Collection<Directory>>();

    @NotNull
    public Iterable<Directory> getDirectories() {
        return new DirectoryIterable(this._directoryListByClass);
    }

    @Nullable
    public <T extends Directory> Collection<T> getDirectoriesOfType(Class<T> clazz) {
        return this._directoryListByClass.get(clazz);
    }

    public int getDirectoryCount() {
        int n = 0;
        for (Map.Entry<Class<? extends Directory>, Collection<Directory>> entry : this._directoryListByClass.entrySet()) {
            n += entry.getValue().size();
        }
        return n;
    }

    public <T extends Directory> void addDirectory(@NotNull T t) {
        this.getOrCreateDirectoryList(t.getClass()).add(t);
    }

    @Nullable
    public <T extends Directory> T getFirstDirectoryOfType(@NotNull Class<T> clazz) {
        Collection<Directory> collection = this.getDirectoryList(clazz);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return (T)collection.iterator().next();
    }

    public boolean containsDirectoryOfType(Class<? extends Directory> clazz) {
        Collection<Directory> collection = this.getDirectoryList(clazz);
        return collection != null && !collection.isEmpty();
    }

    public boolean hasErrors() {
        for (Directory directory : this.getDirectories()) {
            if (!directory.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int n = this.getDirectoryCount();
        return String.format("Metadata (%d %s)", n, n == 1 ? "directory" : "directories");
    }

    @Nullable
    private <T extends Directory> Collection<Directory> getDirectoryList(@NotNull Class<T> clazz) {
        return this._directoryListByClass.get(clazz);
    }

    @NotNull
    private <T extends Directory> Collection<Directory> getOrCreateDirectoryList(@NotNull Class<T> clazz) {
        Collection<Directory> collection = this.getDirectoryList(clazz);
        if (collection != null) {
            return collection;
        }
        collection = new ArrayList<Directory>();
        this._directoryListByClass.put(clazz, collection);
        return collection;
    }

    private static class DirectoryIterable
    implements Iterable<Directory> {
        private final Map<Class<? extends Directory>, Collection<Directory>> _map;

        public DirectoryIterable(Map<Class<? extends Directory>, Collection<Directory>> map) {
            this._map = map;
        }

        @Override
        public Iterator<Directory> iterator() {
            return new DirectoryIterator(this._map);
        }

        private static class DirectoryIterator
        implements Iterator<Directory> {
            @NotNull
            private final Iterator<Map.Entry<Class<? extends Directory>, Collection<Directory>>> _mapIterator;
            @Nullable
            private Iterator<Directory> _listIterator;

            public DirectoryIterator(Map<Class<? extends Directory>, Collection<Directory>> map) {
                this._mapIterator = map.entrySet().iterator();
                if (this._mapIterator.hasNext()) {
                    this._listIterator = this._mapIterator.next().getValue().iterator();
                }
            }

            @Override
            public boolean hasNext() {
                return this._listIterator != null && (this._listIterator.hasNext() || this._mapIterator.hasNext());
            }

            @Override
            public Directory next() {
                if (this._listIterator == null || !this._listIterator.hasNext() && !this._mapIterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                while (!this._listIterator.hasNext()) {
                    this._listIterator = this._mapIterator.next().getValue().iterator();
                }
                return this._listIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

