/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.struct;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SortedPreferentialArray<T extends Comparable<? super T>> {
    private static final Log log = LogFactory.getLog(SortedPreferentialArray.class);
    private boolean preferLarge = true;
    private int maxSize = 0;
    private int curSize = 0;
    private final T[] array;
    private int insertCnt = 0;

    public SortedPreferentialArray(int n) {
        this.maxSize = n;
        Comparable[] comparableArray = new Comparable[n];
        this.array = comparableArray;
    }

    public synchronized void add(T t) {
        if (t == null) {
            return;
        }
        if (this.curSize < this.maxSize) {
            this.insert(t);
            return;
        }
        if (this.preferLarge) {
            T t2 = this.getSmallest();
            if (t.compareTo(t2) > 0) {
                this.insert(t);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("New object is smaller than or equal to the smallest");
            }
            return;
        }
        T t3 = this.getLargest();
        int n = t.compareTo(t3);
        if (n > 0 || n == 0) {
            if (log.isDebugEnabled()) {
                log.debug("New object is larger than or equal to the largest");
            }
            return;
        }
        this.insert(t);
    }

    public synchronized T getLargest() {
        return this.array[this.curSize - 1];
    }

    public synchronized T getSmallest() {
        return this.array[0];
    }

    private void insert(T t) {
        try {
            int n = this.findNearestLargerEqualOrLastPosition(t);
            if (log.isDebugEnabled()) {
                log.debug("nLar = " + n + " obj = " + t);
            }
            if (n == this.curSize && this.curSize < this.maxSize) {
                this.array[n] = t;
                ++this.curSize;
                if (log.isDebugEnabled()) {
                    log.debug(this.dumpArray());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Inserted object at the end of the array");
                }
                return;
            }
            boolean bl = false;
            if (this.curSize == this.maxSize) {
                bl = true;
            }
            if (this.preferLarge) {
                if (bl) {
                    int n2 = n - 1;
                    for (int i = 0; i < n2; ++i) {
                        this.array[i] = this.array[i + 1];
                    }
                    this.array[n - 1] = t;
                    if (log.isDebugEnabled()) {
                        log.debug("Inserted object at " + (n - 1));
                    }
                } else {
                    int n3 = n;
                    for (int i = this.curSize; i > n3; --i) {
                        this.array[i] = this.array[i - 1];
                    }
                    this.array[n] = t;
                    ++this.curSize;
                    if (log.isDebugEnabled()) {
                        log.debug("Inserted object at " + n);
                    }
                }
            } else {
                int n4 = n + 1;
                if (!bl) {
                    n4 = n;
                }
                for (int i = this.curSize; i > n4; --i) {
                    this.array[i] = this.array[i - 1];
                }
                this.array[n] = t;
                if (log.isDebugEnabled()) {
                    log.debug("Inserted object at " + n);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug(this.dumpArray());
            }
        }
        catch (Exception exception) {
            log.error("Insertion problem" + this.dumpArray(), exception);
        }
        ++this.insertCnt;
        if (this.insertCnt % 100 == 0 && log.isDebugEnabled()) {
            log.debug(this.dumpArray());
        }
    }

    public synchronized void setPreferLarge(boolean bl) {
        this.preferLarge = bl;
    }

    public synchronized T takeNearestLargerOrEqual(T t) {
        if (t == null) {
            return null;
        }
        T t2 = null;
        try {
            int n = this.findNearestOccupiedLargerOrEqualPosition(t);
            if (n == -1) {
                return null;
            }
            try {
                t2 = this.array[n];
                this.remove(n);
            }
            catch (Exception exception) {
                log.error("Problem removing from array. pos [" + n + "] " + t, exception);
            }
            if (log.isDebugEnabled()) {
                log.debug("obj = " + t + " || retVal = " + t2);
            }
        }
        catch (Exception exception) {
            log.error("Take problem" + this.dumpArray(), exception);
        }
        return t2;
    }

    public synchronized int size() {
        return this.curSize;
    }

    private int findNearestOccupiedLargerOrEqualPosition(T t) {
        if (this.curSize == 0) {
            return -1;
        }
        int n = this.findNearestLargerEqualOrLastPosition(t);
        if (n == this.curSize) {
            n = t.compareTo(this.array[n - 1]) <= 0 ? --n : -1;
        } else if (t.compareTo(this.array[n]) > 0) {
            return -1;
        }
        return n;
    }

    private int findNearestLargerEqualOrLastPosition(T t) {
        if (t == null) {
            return -1;
        }
        if (this.curSize <= 0) {
            return 0;
        }
        int n = -1;
        int n2 = (this.curSize - 1) / 2;
        int n3 = -1;
        try {
            boolean bl = false;
            if (t.compareTo(this.getSmallest()) <= 0) {
                if (log.isDebugEnabled()) {
                    log.debug(t + " is smaller than or equal to " + this.getSmallest());
                }
                n = 0;
                bl = true;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(t + " is bigger than " + this.getSmallest());
                }
                if (t.compareTo(this.getLargest()) >= 0) {
                    if (this.curSize == this.maxSize) {
                        n = this.curSize - 1;
                        bl = true;
                    } else {
                        n = this.curSize;
                        bl = true;
                    }
                } else {
                    n = this.curSize - 1;
                }
            }
            while (!bl) {
                int n4;
                if (log.isDebugEnabled()) {
                    log.debug("\n curPos = " + n2 + "; greaterPos = " + n + "; prevpos = " + n3);
                }
                if (n2 == n3 || n2 >= this.curSize) {
                    bl = true;
                    break;
                }
                if (this.array[n2].compareTo(t) == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(this.array[n2] + " is equal to " + t);
                    }
                    n = n2;
                    bl = true;
                    break;
                }
                if (this.array[n2].compareTo(t) > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(this.array[n2] + " is greater than " + t);
                    }
                    n = n2;
                    n4 = Math.min(n2, (n2 + n3) / 2);
                    n3 = n2;
                    n2 = n4;
                    continue;
                }
                if (this.array[n2].compareTo(t) >= 0) continue;
                if (log.isDebugEnabled()) {
                    log.debug(this.array[n2] + " is less than " + t);
                }
                if (n != -1 && n - n2 < 0) {
                    bl = true;
                    break;
                }
                n4 = 0;
                if (n3 > n2) {
                    n4 = Math.min((n2 + n3) / 2, this.curSize);
                } else if (n3 == -1) {
                    n4 = Math.min((this.curSize + n2) / 2, this.curSize);
                }
                n3 = n2;
                n2 = n4;
            }
            if (log.isDebugEnabled()) {
                log.debug("Greater Position is [" + n + "]" + " array[greaterPos] [" + this.array[n] + "]");
            }
        }
        catch (Exception exception) {
            log.error("\n curPos = " + n2 + "; greaterPos = " + n + "; prevpos = " + n3 + " " + this.dumpArray(), exception);
        }
        return n;
    }

    private void remove(int n) {
        if (n >= this.curSize || n < 0) {
            throw new IndexOutOfBoundsException("position=" + n + " must be less than curSize=" + this.curSize);
        }
        --this.curSize;
        if (n < this.curSize) {
            try {
                System.arraycopy(this.array, n + 1, this.array, n, this.curSize - n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                log.warn("Caught index out of bounds exception. called 'System.arraycopy( array, position + 1, array, position, (curSize - position) );'  array.lengh [" + this.array.length + "] position [" + n + "] curSize [" + this.curSize + "]");
                throw indexOutOfBoundsException;
            }
        }
    }

    protected synchronized String dumpArray() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n ---------------------------");
        stringBuilder.append("\n curSize = " + this.curSize);
        stringBuilder.append("\n array.length = " + this.array.length);
        stringBuilder.append("\n ---------------------------");
        stringBuilder.append("\n Dump:");
        for (int i = 0; i < this.curSize; ++i) {
            stringBuilder.append("\n " + i + "=" + this.array[i]);
        }
        return stringBuilder.toString();
    }
}

