/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.glassfish.json.JsonWriterImpl;
import org.glassfish.json.api.BufferPool;

class JsonWriterFactoryImpl
implements JsonWriterFactory {
    private final Map<String, ?> config;
    private final boolean prettyPrinting;
    private final BufferPool bufferPool;

    JsonWriterFactoryImpl(Map<String, ?> map, boolean bl, BufferPool bufferPool) {
        this.config = map;
        this.prettyPrinting = bl;
        this.bufferPool = bufferPool;
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        return new JsonWriterImpl(writer, this.prettyPrinting, this.bufferPool);
    }

    @Override
    public JsonWriter createWriter(OutputStream outputStream) {
        return new JsonWriterImpl(outputStream, this.prettyPrinting, this.bufferPool);
    }

    @Override
    public JsonWriter createWriter(OutputStream outputStream, Charset charset) {
        return new JsonWriterImpl(outputStream, charset, this.prettyPrinting, this.bufferPool);
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return this.config;
    }
}

