/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.Arrays;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;

public final class ReverseWayNoTagCorrector {
    private static final TagCollection directionalTags = new TagCollection(Arrays.asList(new Tag("natural", "coastline"), new Tag("natural", "cliff"), new Tag("barrier", "guard_rail"), new Tag("barrier", "kerb"), new Tag("barrier", "retaining_wall"), new Tag("man_made", "embankment")));

    private ReverseWayNoTagCorrector() {
    }

    public static TagCollection getDirectionalTags(Tagged tagged) {
        TagCollection tagCollection = new TagCollection();
        for (Map.Entry<String, String> entry : tagged.getKeys().entrySet()) {
            boolean bl;
            Tag tag = new Tag(entry.getKey(), entry.getValue());
            boolean bl2 = directionalTags.contains(tag) || OsmPrimitive.directionalKeyPredicate.evaluate(tag);
            if (!bl2 || !(bl = ReverseWayTagCorrector.getTagCorrections(tag).isEmpty())) continue;
            tagCollection.add(tag);
        }
        return tagCollection;
    }

    public static boolean isReversible(Tagged tagged) {
        return ReverseWayNoTagCorrector.getDirectionalTags(tagged).isEmpty();
    }

    protected static boolean confirmReverseWay(Way way, TagCollection tagCollection) {
        String string = I18n.trn("<html>You are going to reverse the way ''{0}'',<br/> whose semantic meaning of its tag ''{1}'' is defined by its direction.<br/>Do you really want to change the way direction, thus its semantic meaning?</html>", "<html>You are going to reverse the way ''{0}'',<br/> whose semantic meaning of these tags are defined by its direction:<br/>{1}Do you really want to change the way direction, thus its semantic meaning?</html>", tagCollection.size(), way.getDisplayName(DefaultNameFormatter.getInstance()), Utils.joinAsHtmlUnorderedList(tagCollection));
        int n = ConditionalOptionPaneUtil.showOptionDialog("reverse_directional_way", Main.parent, string, I18n.tr("Reverse directional way.", new Object[0]), 1, 2, null, null);
        switch (n) {
            case -2147483648: 
            case 0: {
                return true;
            }
        }
        return false;
    }

    public static void checkAndConfirmReverseWay(Way way) throws UserCancelException {
        TagCollection tagCollection = ReverseWayNoTagCorrector.getDirectionalTags(way);
        if (!tagCollection.isEmpty() && !ReverseWayNoTagCorrector.confirmReverseWay(way, tagCollection)) {
            throw new UserCancelException();
        }
    }
}

