/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Hash;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class DuplicateNode
extends Test {
    protected static final int DUPLICATE_NODE = 1;
    protected static final int DUPLICATE_NODE_MIXED = 2;
    protected static final int DUPLICATE_NODE_OTHER = 3;
    protected static final int DUPLICATE_NODE_BUILDING = 10;
    protected static final int DUPLICATE_NODE_BOUNDARY = 11;
    protected static final int DUPLICATE_NODE_HIGHWAY = 12;
    protected static final int DUPLICATE_NODE_LANDUSE = 13;
    protected static final int DUPLICATE_NODE_NATURAL = 14;
    protected static final int DUPLICATE_NODE_POWER = 15;
    protected static final int DUPLICATE_NODE_RAILWAY = 16;
    protected static final int DUPLICATE_NODE_WATERWAY = 17;
    private static final String[] TYPES = new String[]{"none", "highway", "railway", "waterway", "boundary", "power", "natural", "landuse", "building"};
    private Storage<Object> potentialDuplicates;

    public DuplicateNode() {
        super(I18n.tr("Duplicated nodes", new Object[0]), I18n.tr("This test checks that there are no nodes at the very same location.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.potentialDuplicates = new Storage<Object>(new NodeHash());
    }

    @Override
    public void endTest() {
        for (Object object : this.potentialDuplicates) {
            if (object instanceof Node) continue;
            List list = (List)object;
            HashSet<String> hashSet = new HashSet<String>();
            for (Node node : list) {
                String string = node.get("ele");
                if (string == null) continue;
                hashSet.add(string);
            }
            if (hashSet.size() == list.size()) continue;
            this.errors.addAll(this.buildTestErrors(this, list));
        }
        super.endTest();
        this.potentialDuplicates = null;
    }

    /*
     * WARNING - void declaration
     */
    public List<TestError> buildTestErrors(Test test, List<Node> list) {
        ArrayList<TestError> arrayList2 = new ArrayList<TestError>();
        MultiMap<Object, Node> multiMap = new MultiMap<Object, Node>();
        for (Node arrayList3 : list) {
            multiMap.put(arrayList3.getKeys(), arrayList3);
        }
        HashMap hashMap = new HashMap();
        Iterator iterator = multiMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            void set;
            Map map = (Map)iterator.next();
            if (multiMap.get(map).size() <= 1) continue;
            for (String string : TYPES) {
                hashMap.put(string, Boolean.FALSE);
            }
            for (OsmPrimitive osmPrimitive : multiMap.get(map)) {
                if (osmPrimitive.getType() != OsmPrimitiveType.NODE) continue;
                Node node = (Node)osmPrimitive;
                List<OsmPrimitive> list2 = node.getReferrers();
                for (OsmPrimitive osmPrimitive2 : list2) {
                    if (osmPrimitive2.getType() != OsmPrimitiveType.WAY) continue;
                    boolean bl = false;
                    Way way = (Way)osmPrimitive2;
                    TagMap tagMap = way.getKeys();
                    for (String string : hashMap.keySet()) {
                        if (!tagMap.containsKey(string)) continue;
                        hashMap.put(string, Boolean.TRUE);
                        bl = true;
                    }
                    if (bl) continue;
                    hashMap.put("none", Boolean.TRUE);
                }
            }
            boolean bl = false;
            for (Map.Entry entry : hashMap.entrySet()) {
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                ++set;
            }
            if (set > true) {
                object = I18n.marktr("Mixed type duplicated nodes");
                arrayList2.add(new TestError(test, Severity.WARNING, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object, new Object[0]), (String)object, 2, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("highway")).booleanValue()) {
                object = I18n.marktr("Highway duplicated nodes");
                arrayList2.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object, new Object[0]), (String)object, 12, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("railway")).booleanValue()) {
                object = I18n.marktr("Railway duplicated nodes");
                arrayList2.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object, new Object[0]), (String)object, 16, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("waterway")).booleanValue()) {
                object = I18n.marktr("Waterway duplicated nodes");
                arrayList2.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object, new Object[0]), (String)object, 17, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("boundary")).booleanValue()) {
                object = I18n.marktr("Boundary duplicated nodes");
                arrayList2.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object, new Object[0]), (String)object, 11, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("power")).booleanValue()) {
                object = I18n.marktr("Power duplicated nodes");
                arrayList2.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object, new Object[0]), (String)object, 15, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("natural")).booleanValue()) {
                object = I18n.marktr("Natural duplicated nodes");
                arrayList2.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object, new Object[0]), (String)object, 14, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("building")).booleanValue()) {
                object = I18n.marktr("Building duplicated nodes");
                arrayList2.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object, new Object[0]), (String)object, 10, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("landuse")).booleanValue()) {
                object = I18n.marktr("Landuse duplicated nodes");
                arrayList2.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object, new Object[0]), (String)object, 13, multiMap.get(map)));
            } else {
                object = I18n.marktr("Other duplicated nodes");
                arrayList2.add(new TestError(test, Severity.WARNING, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object, new Object[0]), (String)object, 3, multiMap.get(map)));
            }
            iterator.remove();
        }
        if (!multiMap.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            for (Set set : multiMap.values()) {
                arrayList.addAll(set);
            }
            if (arrayList.size() > 1) {
                arrayList2.add(new TestError(test, Severity.WARNING, I18n.tr("Nodes at same position", new Object[0]), 1, arrayList));
            }
        }
        return arrayList2;
    }

    @Override
    public void visit(Node node) {
        if (node.isUsable()) {
            if (this.potentialDuplicates.get(node) == null) {
                this.potentialDuplicates.put(node);
            } else if (this.potentialDuplicates.get(node) instanceof Node) {
                Node node2 = (Node)this.potentialDuplicates.get(node);
                ArrayList<Node> arrayList = new ArrayList<Node>(2);
                arrayList.add(node2);
                arrayList.add(node);
                this.potentialDuplicates.put(arrayList);
            } else if (this.potentialDuplicates.get(node) instanceof List) {
                List list = (List)this.potentialDuplicates.get(node);
                list.add(node);
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        if (!this.isFixable(testError)) {
            return null;
        }
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>(testError.getPrimitives());
        LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>(OsmPrimitive.getFilteredList(linkedList, Node.class));
        Object object = linkedHashSet.iterator();
        while (object.hasNext()) {
            if (!((Node)object.next()).isDeleted()) continue;
            object.remove();
        }
        if (linkedHashSet.size() >= 2) {
            object = null;
            for (Node node : linkedHashSet) {
                if (node.isNew()) continue;
                object = node;
                break;
            }
            if (object == null) {
                object = (Node)linkedHashSet.iterator().next();
            }
            if (DeleteCommand.checkAndConfirmOutlyingDelete(linkedHashSet, Collections.singleton(object))) {
                return MergeNodesAction.mergeNodes(Main.main.getEditLayer(), linkedHashSet, (Node)object);
            }
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (!(testError.getTester() instanceof DuplicateNode)) {
            return false;
        }
        return testError.getCode() != 1;
    }

    private static class NodeHash
    implements Hash<Object, Object> {
        private final double precision = Main.pref.getDouble("validator.duplicatenodes.precision", 0.0);

        private NodeHash() {
        }

        private LatLon roundCoord(LatLon latLon) {
            return new LatLon((double)Math.round(latLon.lat() / this.precision) * this.precision, (double)Math.round(latLon.lon() / this.precision) * this.precision);
        }

        private LatLon getLatLon(Object object) {
            if (object instanceof Node) {
                LatLon latLon = ((Node)object).getCoor();
                if (latLon == null) {
                    return null;
                }
                if (this.precision == 0.0) {
                    return latLon.getRoundedToOsmPrecision();
                }
                return this.roundCoord(latLon);
            }
            if (object instanceof List) {
                LatLon latLon = ((Node)((List)object).get(0)).getCoor();
                if (latLon == null) {
                    return null;
                }
                if (this.precision == 0.0) {
                    return latLon.getRoundedToOsmPrecision();
                }
                return this.roundCoord(latLon);
            }
            throw new AssertionError();
        }

        @Override
        public boolean equals(Object object, Object object2) {
            LatLon latLon;
            LatLon latLon2 = this.getLatLon(object);
            return latLon2 == (latLon = this.getLatLon(object2)) || latLon2 != null && latLon != null && latLon2.equals(latLon);
        }

        @Override
        public int getHashCode(Object object) {
            LatLon latLon = this.getLatLon(object);
            return latLon == null ? 0 : latLon.hashCode();
        }
    }
}

