/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;

class MapSlider
extends JSlider
implements PropertyChangeListener,
ChangeListener,
Helpful {
    private static final double zoomStep = 1.1;
    private final MapView mv;
    private boolean preventChange;
    private int lastValue;

    MapSlider(MapView mapView) {
        super(0, 150);
        this.setOpaque(false);
        this.mv = mapView;
        mapView.addPropertyChangeListener("scale", this);
        this.addChangeListener(this);
        this.propertyChange(null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        double d = this.mv.getMaxScale();
        int n = (int)Math.round(Math.log(d / this.mv.getScale()) / Math.log(1.1));
        this.preventChange = true;
        this.setValue(n);
        this.lastValue = n;
        this.preventChange = false;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.preventChange) {
            return;
        }
        if (!this.getModel().getValueIsAdjusting() && this.mv.getNativeScaleLayer() != null) {
            if (this.getValue() < this.lastValue) {
                this.mv.zoomOut();
            } else if (this.getValue() > this.lastValue) {
                this.mv.zoomIn();
            }
        } else {
            double d = this.mv.getMaxScale();
            double d2 = d / Math.pow(1.1, this.getValue());
            double d3 = this.mv.scaleFloor(d2);
            this.mv.zoomTo(this.mv.getCenter(), d3);
        }
        this.propertyChange(null);
    }

    @Override
    public String helpTopic() {
        return HelpUtil.ht("/MapView/Slider");
    }
}

