/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OverpassDownloadReader
extends BoundingBoxDownloader {
    final String overpassServer;
    final String overpassQuery;

    public OverpassDownloadReader(Bounds bounds, String string, String string2) {
        super(bounds);
        this.overpassServer = string;
        this.overpassQuery = string2.trim();
    }

    @Override
    protected String getBaseUrl() {
        return this.overpassServer;
    }

    @Override
    protected String getRequestForBbox(double d, double d2, double d3, double d4) {
        if (this.overpassQuery.isEmpty()) {
            return super.getRequestForBbox(d, d2, d3, d4);
        }
        String string = OverpassDownloadReader.completeOverpassQuery(this.overpassQuery);
        return "interpreter?data=" + Utils.encodeUrl(string) + "&bbox=" + d + ',' + d2 + ',' + d3 + ',' + d4;
    }

    private static String completeOverpassQuery(String string) {
        int n;
        int n2 = string.indexOf(59);
        if (n2 == -1) {
            return "[bbox];" + string;
        }
        int n3 = string.indexOf("[bbox");
        if (n3 > -1 && n3 < n2) {
            return string;
        }
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (string.charAt(n) == '[') {
                ++n4;
                continue;
            }
            if (string.charAt(n) == ']') {
                --n4;
                continue;
            }
            if (n4 == 0 && !Character.isWhitespace(string.charAt(n))) break;
        }
        if (n < n2) {
            return "[bbox];" + string;
        }
        return "[bbox]" + string;
    }

    @Override
    protected InputStream getInputStreamRaw(String string, ProgressMonitor progressMonitor, String string2, boolean bl) throws OsmTransferException {
        try {
            return super.getInputStreamRaw(string, progressMonitor, string2, bl);
        }
        catch (OsmApiException osmApiException) {
            String string3;
            if (osmApiException.getMessage() != null && osmApiException.getMessage().contains("Error</strong>: ") && (string3 = osmApiException.getMessage().split("Error</strong>: ")[1]) != null) {
                String string4 = string3.split("</")[0];
                osmApiException.setErrorHeader(string4);
            }
            throw osmApiException;
        }
    }

    @Override
    protected void adaptRequest(HttpClient httpClient) {
        Matcher matcher = Pattern.compile("\\[timeout:(\\d+)\\]").matcher(this.overpassQuery);
        int n = matcher.find() ? 1000 * Integer.parseInt(matcher.group(1)) : 180000;
        httpClient.setConnectTimeout(n);
        httpClient.setReadTimeout(n);
    }

    @Override
    protected String getTaskName() {
        return I18n.tr("Contacting Server...", new Object[0]);
    }

    @Override
    protected DataSet parseDataSet(InputStream inputStream, ProgressMonitor progressMonitor) throws IllegalDataException {
        return new OsmReader(){

            @Override
            protected void parseUnknown(boolean bl) throws XMLStreamException {
                String string;
                if ("remark".equals(this.parser.getLocalName()) && this.parser.getEventType() == 1 && (string = this.parser.getElementText()).contains("runtime error")) {
                    throw new XMLStreamException(string);
                }
                super.parseUnknown(bl);
            }
        }.doParseDataSet(inputStream, progressMonitor);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        DataSet dataSet = super.parseOsm(progressMonitor);
        if (dataSet != null && dataSet.dataSources.isEmpty()) {
            if (this.crosses180th) {
                Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, 180.0);
                DataSource dataSource = new DataSource(bounds, this.getBaseUrl());
                dataSet.dataSources.add(dataSource);
                bounds = new Bounds(this.lat1, -180.0, this.lat2, this.lon2);
                dataSource = new DataSource(bounds, this.getBaseUrl());
                dataSet.dataSources.add(dataSource);
            } else {
                Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, this.lon2);
                DataSource dataSource = new DataSource(bounds, this.getBaseUrl());
                dataSet.dataSources.add(dataSource);
            }
        }
        return dataSet;
    }
}

