/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.debug.shell.server;

import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrument.ASTPrinter;
import com.oracle.truffle.api.instrument.KillException;
import com.oracle.truffle.api.instrument.QuitException;
import com.oracle.truffle.api.instrument.StandardSyntaxTag;
import com.oracle.truffle.api.instrument.Visualizer;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.vm.PolyglotEngine;
import com.oracle.truffle.tools.debug.shell.REPLMessage;
import com.oracle.truffle.tools.debug.shell.server.REPLServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class REPLHandler {
    private static final int DEFAULT_IGNORE_COUNT = 0;
    private final String op;
    public static final REPLHandler BACKTRACE_HANDLER = new REPLHandler("backtrace"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            Visualizer visualizer = replServer.getVisualizer();
            ArrayList<REPLMessage> replies = new ArrayList<REPLMessage>();
            REPLServer.Context currentContext = replServer.getCurrentContext();
            List<FrameInstance> stack = currentContext.getStack();
            replies.add(REPLHandler.btMessage(0, currentContext.getNode(), visualizer));
            for (int i = 1; i <= stack.size(); ++i) {
                replies.add(REPLHandler.btMessage(i, stack.get(i - 1).getCallNode(), visualizer));
            }
            if (replies.size() > 0) {
                return replies.toArray(new REPLMessage[0]);
            }
            return 1.finishReplyFailed(new REPLMessage("op", "backtrace"), "No stack");
        }
    };
    public static final REPLHandler BREAK_AT_LINE_HANDLER = new REPLHandler("break-at-line"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            String path = request.get("path");
            String fileName = request.get("source-name");
            String lookupFile = path == null || path.isEmpty() ? fileName : path;
            Source source = null;
            try {
                source = Source.fromFileName(lookupFile, true);
            }
            catch (Exception ex) {
                return 2.finishReplyFailed(reply, ex);
            }
            if (source == null) {
                return 2.finishReplyFailed(reply, fileName + " not found");
            }
            Integer lineNumber = request.getIntValue("line-number");
            if (lineNumber == null) {
                return 2.finishReplyFailed(reply, "missing line number");
            }
            Integer ignoreCount = request.getIntValue("breakpoint-ignore-count");
            if (ignoreCount == null) {
                ignoreCount = 0;
            }
            REPLServer.BreakpointInfo breakpointInfo = replServer.setLineBreakpoint(0, source.createLineLocation(lineNumber), false);
            reply.put("source-name", fileName);
            reply.put("path", source.getPath());
            reply.put("breakpoint-id", Integer.toString(breakpointInfo.getID()));
            reply.put("line-number", Integer.toString(lineNumber));
            reply.put("breakpoint-ignore-count", ignoreCount.toString());
            return 2.finishReplySucceeded(reply, "Breakpoint set");
        }
    };
    public static final REPLHandler BREAK_AT_LINE_ONCE_HANDLER = new REPLHandler("break-at-line-once"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            String path = request.get("path");
            String fileName = request.get("source-name");
            String lookupFile = path == null || path.isEmpty() ? fileName : path;
            Source source = null;
            try {
                source = Source.fromFileName(lookupFile, true);
            }
            catch (Exception ex) {
                return 3.finishReplyFailed(reply, ex);
            }
            if (source == null) {
                return 3.finishReplyFailed(reply, fileName + " not found");
            }
            Integer lineNumber = request.getIntValue("line-number");
            if (lineNumber == null) {
                return 3.finishReplyFailed(reply, "missing line number");
            }
            REPLServer.BreakpointInfo breakpointInfo = replServer.setLineBreakpoint(0, source.createLineLocation(lineNumber), true);
            reply.put("source-name", fileName);
            reply.put("path", source.getPath());
            reply.put("breakpoint-id", Integer.toString(breakpointInfo.getID()));
            reply.put("line-number", Integer.toString(lineNumber));
            return 3.finishReplySucceeded(reply, "One-shot line breakpoint set");
        }
    };
    public static final REPLHandler BREAK_AT_THROW_HANDLER = new REPLHandler("break-at-throw"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            try {
                replServer.setTagBreakpoint(0, StandardSyntaxTag.THROW, false);
                return 4.finishReplySucceeded(reply, "Breakpoint at any throw set");
            }
            catch (Exception ex) {
                return 4.finishReplyFailed(reply, ex);
            }
        }
    };
    public static final REPLHandler BREAK_AT_THROW_ONCE_HANDLER = new REPLHandler("break-at-throw-once"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            try {
                replServer.setTagBreakpoint(0, StandardSyntaxTag.THROW, true);
                return 5.finishReplySucceeded(reply, "One-shot breakpoint at any throw set");
            }
            catch (Exception ex) {
                return 5.finishReplyFailed(reply, ex);
            }
        }
    };
    public static final REPLHandler BREAKPOINT_INFO_HANDLER = new REPLHandler("breakpoint-info"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            ArrayList<REPLMessage> infoMessages = new ArrayList<REPLMessage>();
            for (REPLServer.BreakpointInfo breakpointInfo : replServer.getBreakpoints()) {
                infoMessages.add(6.createBreakpointInfoMessage(breakpointInfo));
            }
            if (infoMessages.size() > 0) {
                return infoMessages.toArray(new REPLMessage[0]);
            }
            return 6.finishReplyFailed(reply, "No breakpoints");
        }
    };
    public static final REPLHandler CALL_HANDLER = new REPLHandler("call"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            String arg;
            REPLMessage reply = new REPLMessage("op", "call");
            String callName = request.get("call-name");
            if (callName == null) {
                return 7.finishReplyFailed(reply, "no name specified");
            }
            ArrayList<String> argList = new ArrayList<String>();
            for (int argCount = 0; argCount < REPLMessage.ARG_NAMES.length && (arg = request.get(REPLMessage.ARG_NAMES[argCount])) != null; ++argCount) {
                argList.add(arg);
            }
            boolean stepInto = "true".equals(request.get("step-into"));
            try {
                Object result = replServer.getCurrentContext().call(callName, stepInto, argList);
                reply.put("value", result == null ? "<void>" : result.toString());
            }
            catch (QuitException ex) {
                throw ex;
            }
            catch (KillException ex) {
                return 7.finishReplySucceeded(reply, callName + " killed");
            }
            catch (Exception ex) {
                return 7.finishReplyFailed(reply, ex);
            }
            return 7.finishReplySucceeded(reply, callName + " returned");
        }
    };
    public static final REPLHandler CLEAR_BREAK_HANDLER = new REPLHandler("clear-breakpoint"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            Integer breakpointNumber = request.getIntValue("breakpoint-id");
            if (breakpointNumber == null) {
                return 8.finishReplyFailed(reply, "missing breakpoint number");
            }
            REPLServer.BreakpointInfo breakpointInfo = replServer.findBreakpoint(breakpointNumber);
            if (breakpointInfo == null) {
                return 8.finishReplyFailed(reply, "no breakpoint number " + breakpointNumber);
            }
            breakpointInfo.dispose();
            reply.put("breakpoint-id", Integer.toString(breakpointNumber));
            return 8.finishReplySucceeded(reply, "Breakpoint " + breakpointNumber + " cleared");
        }
    };
    public static final REPLHandler CONTINUE_HANDLER = new REPLHandler("continue"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            replServer.getCurrentContext().prepareContinue();
            return 9.finishReplySucceeded(reply, "Continue mode entered");
        }
    };
    public static final REPLHandler DELETE_HANDLER = new REPLHandler("delete-breakpoint"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            Collection<REPLServer.BreakpointInfo> breakpoints = replServer.getBreakpoints();
            if (breakpoints.isEmpty()) {
                return 10.finishReplyFailed(reply, "no breakpoints to delete");
            }
            for (REPLServer.BreakpointInfo breakpointInfo : breakpoints) {
                breakpointInfo.dispose();
            }
            return 10.finishReplySucceeded(reply, Integer.toString(breakpoints.size()) + " breakpoints deleted");
        }
    };
    public static final REPLHandler DISABLE_BREAK_HANDLER = new REPLHandler("disable-breakpoint"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            Integer breakpointNumber = request.getIntValue("breakpoint-id");
            if (breakpointNumber == null) {
                return 11.finishReplyFailed(reply, "missing breakpoint number");
            }
            REPLServer.BreakpointInfo breakpointInfo = replServer.findBreakpoint(breakpointNumber);
            if (breakpointInfo == null) {
                return 11.finishReplyFailed(reply, "no breakpoint number " + breakpointNumber);
            }
            breakpointInfo.setEnabled(false);
            reply.put("breakpoint-id", Integer.toString(breakpointNumber));
            return 11.finishReplySucceeded(reply, "Breakpoint " + breakpointNumber + " disabled");
        }
    };
    public static final REPLHandler ENABLE_BREAK_HANDLER = new REPLHandler("enable-breakpoint"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            Integer breakpointNumber = request.getIntValue("breakpoint-id");
            if (breakpointNumber == null) {
                return 12.finishReplyFailed(reply, "missing breakpoint number");
            }
            REPLServer.BreakpointInfo breakpointInfo = replServer.findBreakpoint(breakpointNumber);
            if (breakpointInfo == null) {
                return 12.finishReplyFailed(reply, "no breakpoint number " + breakpointNumber);
            }
            breakpointInfo.setEnabled(true);
            reply.put("breakpoint-id", Integer.toString(breakpointNumber));
            return 12.finishReplySucceeded(reply, "Breakpoint " + breakpointNumber + " enabled");
        }
    };
    public static final REPLHandler EVAL_HANDLER = new REPLHandler("eval"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            String sourceName = request.get("source-name");
            reply.put("source-name", sourceName);
            REPLServer.Context serverContext = replServer.getCurrentContext();
            reply.put("debug-level", Integer.toString(serverContext.getLevel()));
            String source = request.get("code");
            Visualizer visualizer = replServer.getVisualizer();
            Integer frameNumber = request.getIntValue("frame-number");
            boolean stepInto = "true".equals(request.get("step-into"));
            try {
                Object returnValue = serverContext.eval(source, frameNumber, stepInto);
                return 13.finishReplySucceeded(reply, visualizer.displayValue(returnValue, 0));
            }
            catch (QuitException ex) {
                throw ex;
            }
            catch (KillException ex) {
                return 13.finishReplySucceeded(reply, "eval (" + sourceName + ") killed");
            }
            catch (Exception ex) {
                return 13.finishReplyFailed(reply, ex);
            }
        }
    };
    public static final REPLHandler FILE_HANDLER = new REPLHandler("file"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            String fileName = request.get("source-name");
            if (fileName == null) {
                return 14.finishReplyFailed(reply, "no file specified");
            }
            reply.put("source-name", fileName);
            try {
                Source source = Source.fromFileName(fileName);
                if (source == null) {
                    return 14.finishReplyFailed(reply, "file \"" + fileName + "\" not found");
                }
                reply.put("path", source.getPath());
                reply.put("code", source.getCode());
                return 14.finishReplySucceeded(reply, "file found");
            }
            catch (IOException ex) {
                return 14.finishReplyFailed(reply, "can't read file \"" + fileName + "\"");
            }
            catch (Exception ex) {
                return 14.finishReplyFailed(reply, ex);
            }
        }
    };
    public static final REPLHandler FRAME_HANDLER = new REPLHandler("frame"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            Node node;
            MaterializedFrame frame;
            Integer frameNumber = request.getIntValue("frame-number");
            if (frameNumber == null) {
                return 15.finishReplyFailed(this.createReply(), "no frame number specified");
            }
            REPLServer.Context currentContext = replServer.getCurrentContext();
            List<FrameInstance> stack = currentContext.getStack();
            if (frameNumber < 0 || frameNumber > stack.size()) {
                return 15.finishReplyFailed(this.createReply(), "frame number " + frameNumber + " out of range");
            }
            Visualizer visualizer = replServer.getVisualizer();
            if (frameNumber == 0) {
                frame = currentContext.getFrame();
                node = currentContext.getNode();
            } else {
                FrameInstance instance = stack.get(frameNumber - 1);
                frame = instance.getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize();
                node = instance.getCallNode();
            }
            List<? extends FrameSlot> slots = frame.getFrameDescriptor().getSlots();
            if (slots.size() == 0) {
                REPLMessage emptyFrameMessage = 15.createFrameInfoMessage(replServer, frameNumber, node);
                return 15.finishReplySucceeded(emptyFrameMessage, "empty frame");
            }
            ArrayList<REPLMessage> replies = new ArrayList<REPLMessage>();
            for (FrameSlot frameSlot : slots) {
                REPLMessage slotMessage = 15.createFrameInfoMessage(replServer, frameNumber, node);
                slotMessage.put("slot-index", Integer.toString(frameSlot.getIndex()));
                slotMessage.put("slot-identifier", visualizer.displayIdentifier(frameSlot));
                slotMessage.put("slot-value", visualizer.displayValue(frame.getValue(frameSlot), 0));
                slotMessage.put("status", "succeeded");
                replies.add(slotMessage);
            }
            return replies.toArray(new REPLMessage[0]);
        }
    };
    public static final REPLHandler INFO_HANDLER = new REPLHandler("info"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            String topic = request.get("topic");
            if (topic == null || topic.isEmpty()) {
                REPLMessage message = new REPLMessage("op", "info");
                return 16.finishReplyFailed(message, "No info topic specified");
            }
            switch (topic) {
                case "info-supported-languages": {
                    ArrayList<REPLMessage> langMessages = new ArrayList<REPLMessage>();
                    for (PolyglotEngine.Language language : replServer.getLanguages()) {
                        REPLMessage infoMessage = new REPLMessage("op", "info");
                        infoMessage.put("topic", "info-supported-languages");
                        infoMessage.put("language-name", language.getName());
                        infoMessage.put("language-version", language.getVersion());
                        infoMessage.put("status", "succeeded");
                        langMessages.add(infoMessage);
                    }
                    return langMessages.toArray(new REPLMessage[0]);
                }
                case "info-current-language": {
                    REPLMessage reply = new REPLMessage("op", "info");
                    reply.put("topic", "info-current-language");
                    String languageName = replServer.getCurrentContext().getLanguageName();
                    reply.put("language-name", languageName);
                    return 16.finishReplySucceeded(reply, languageName);
                }
                case "welcome-message": {
                    REPLMessage infoMessage = new REPLMessage("op", "info");
                    infoMessage.put("topic", "welcome-message");
                    infoMessage.put("info-value", replServer.getWelcome());
                    infoMessage.put("status", "succeeded");
                    return 16.finishReplySucceeded(infoMessage, "welcome");
                }
            }
            REPLMessage message = new REPLMessage("op", "info");
            return 16.finishReplyFailed(message, "No info about topic \"" + topic + "\"");
        }
    };
    public static final REPLHandler KILL_HANDLER = new REPLHandler("kill"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            if (replServer.getCurrentContext().getLevel() == 0) {
                return 17.finishReplyFailed(this.createReply(), "nothing to kill");
            }
            throw new KillException();
        }
    };
    public static final REPLHandler LOAD_HANDLER = new REPLHandler("load-source"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = new REPLMessage("op", "load-source");
            String fileName = request.get("source-name");
            boolean stepInto = "true".equals(request.get("step-into"));
            try {
                Source fileSource = Source.fromFileName(fileName);
                replServer.getCurrentContext().eval(fileSource, stepInto);
                reply.put("path", fileName);
                return 18.finishReplySucceeded(reply, fileName + "  loaded");
            }
            catch (QuitException ex) {
                throw ex;
            }
            catch (KillException ex) {
                return 18.finishReplySucceeded(reply, fileName + " killed");
            }
            catch (Exception ex) {
                return 18.finishReplyFailed(reply, ex);
            }
        }
    };
    public static final REPLHandler QUIT_HANDLER = new REPLHandler("quit"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            throw new QuitException();
        }
    };
    public static final REPLHandler SET_LANGUAGE_HANDLER = new REPLHandler("set-language"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = new REPLMessage("op", "set-language");
            String languageName = request.get("language-name");
            if (languageName == null) {
                String oldLanguageName = replServer.getCurrentContext().getLanguageName();
                reply.put("language-name", reply.put("language-name", oldLanguageName));
                return 20.finishReplySucceeded(reply, "Language set to " + oldLanguageName);
            }
            reply.put("language-name", languageName);
            try {
                String newLanguageName = replServer.getCurrentContext().setLanguage(languageName);
                if (newLanguageName != null) {
                    return 20.finishReplySucceeded(reply, "Language set to " + newLanguageName);
                }
            }
            catch (Exception ex) {
                return 20.finishReplyFailed(reply, ex);
            }
            return 20.finishReplyFailed(reply, "Language \"" + languageName + "\" not supported");
        }
    };
    public static final REPLHandler SET_BREAK_CONDITION_HANDLER = new REPLHandler("set-breakpoint-condition"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage message = new REPLMessage("op", "set-breakpoint-condition");
            Integer breakpointNumber = request.getIntValue("breakpoint-id");
            if (breakpointNumber == null) {
                return 21.finishReplyFailed(message, "missing breakpoint number");
            }
            message.put("breakpoint-id", Integer.toString(breakpointNumber));
            REPLServer.BreakpointInfo breakpointInfo = replServer.findBreakpoint(breakpointNumber);
            if (breakpointInfo == null) {
                return 21.finishReplyFailed(message, "no breakpoint number " + breakpointNumber);
            }
            String expr = request.get("breakpoint-condition");
            if (expr == null || expr.isEmpty()) {
                return 21.finishReplyFailed(message, "missing condition for " + breakpointNumber);
            }
            try {
                breakpointInfo.setCondition(expr);
            }
            catch (IOException ex) {
                return 21.finishReplyFailed(message, "invalid condition for " + breakpointNumber);
            }
            catch (UnsupportedOperationException ex) {
                return 21.finishReplyFailed(message, "conditions not supported by breakpoint " + breakpointNumber);
            }
            catch (Exception ex) {
                return 21.finishReplyFailed(message, ex);
            }
            message.put("breakpoint-condition", expr);
            return 21.finishReplySucceeded(message, "Breakpoint " + breakpointNumber + " condition=\"" + expr + "\"");
        }
    };
    public static final REPLHandler STEP_INTO_HANDLER = new REPLHandler("step-into"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            Integer repeat = request.getIntValue("repeat");
            if (repeat == null) {
                repeat = 1;
            }
            replServer.getCurrentContext().prepareStepInto(repeat);
            return 22.finishReplySucceeded(reply, "StepInto <" + repeat + "> enabled");
        }
    };
    public static final REPLHandler STEP_OUT_HANDLER = new REPLHandler("step-out"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            replServer.getCurrentContext().prepareStepOut();
            return 23.finishReplySucceeded(this.createReply(), "StepOut enabled");
        }
    };
    public static final REPLHandler STEP_OVER_HANDLER = new REPLHandler("step-over"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            Integer repeat = request.getIntValue("repeat");
            if (repeat == null) {
                repeat = 1;
            }
            replServer.getCurrentContext().prepareStepOver(repeat);
            return 24.finishReplySucceeded(reply, "StepOver <" + repeat + "> enabled");
        }
    };
    public static final REPLHandler TRUFFLE_HANDLER = new REPLHandler("truffle"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            ASTPrinter astPrinter = replServer.getVisualizer().getASTPrinter();
            String topic = request.get("topic");
            reply.put("topic", topic);
            Node node = replServer.getCurrentContext().getNodeAtHalt();
            if (node == null) {
                return 25.finishReplyFailed(reply, "no current AST node");
            }
            Integer depth = request.getIntValue("show-max-depth");
            if (depth == null) {
                return 25.finishReplyFailed(reply, "missing AST depth");
            }
            try {
                switch (topic) {
                    case "ast": {
                        while (node.getParent() != null) {
                            node = node.getParent();
                        }
                        String astText = astPrinter.printTreeToString(node, depth, replServer.getCurrentContext().getNodeAtHalt());
                        return 25.finishReplySucceeded(reply, astText);
                    }
                    case "subtree": 
                    case "sub": {
                        String subTreeText = astPrinter.printTreeToString(node, depth);
                        return 25.finishReplySucceeded(reply, subTreeText);
                    }
                }
                return 25.finishReplyFailed(reply, "Unknown \"" + "truffle".toString() + "\" topic");
            }
            catch (Exception ex) {
                return 25.finishReplyFailed(reply, ex);
            }
        }
    };
    public static final REPLHandler UNSET_BREAK_CONDITION_HANDLER = new REPLHandler("unset-breakpoint-condition"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage message = new REPLMessage("op", "unset-breakpoint-condition");
            Integer breakpointNumber = request.getIntValue("breakpoint-id");
            if (breakpointNumber == null) {
                return 26.finishReplyFailed(message, "missing breakpoint number");
            }
            message.put("breakpoint-id", Integer.toString(breakpointNumber));
            REPLServer.BreakpointInfo breakpointInfo = replServer.findBreakpoint(breakpointNumber);
            if (breakpointInfo == null) {
                return 26.finishReplyFailed(message, "no breakpoint number " + breakpointNumber);
            }
            try {
                breakpointInfo.setCondition(null);
            }
            catch (Exception ex) {
                return 26.finishReplyFailed(message, ex);
            }
            return 26.finishReplySucceeded(message, "Breakpoint " + breakpointNumber + " condition cleared");
        }
    };
    public static final REPLHandler TRUFFLE_NODE_HANDLER = new REPLHandler("truffle-node"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            ASTPrinter astPrinter = replServer.getVisualizer().getASTPrinter();
            Node node = replServer.getCurrentContext().getNodeAtHalt();
            if (node == null) {
                return 27.finishReplyFailed(reply, "no current AST node");
            }
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(astPrinter.printNodeWithInstrumentation(node));
                SourceSection sourceSection = node.getSourceSection();
                if (sourceSection != null) {
                    String code = sourceSection.getCode();
                    sb.append(" \"");
                    sb.append(code.substring(0, Math.min(code.length(), 15)));
                    sb.append("...\"");
                }
                return 27.finishReplySucceeded(reply, sb.toString());
            }
            catch (Exception ex) {
                return 27.finishReplyFailed(reply, ex);
            }
        }
    };

    protected REPLHandler(String op) {
        this.op = op;
    }

    final String getOp() {
        return this.op;
    }

    abstract REPLMessage[] receive(REPLMessage var1, REPLServer var2);

    REPLMessage createReply() {
        return new REPLMessage("op", this.op);
    }

    protected static final REPLMessage[] finishReplySucceeded(REPLMessage reply, String explanation) {
        reply.put("status", "succeeded");
        reply.put("displayable-message", explanation);
        REPLMessage[] replies = new REPLMessage[]{reply};
        return replies;
    }

    protected static final REPLMessage[] finishReplyFailed(REPLMessage reply, String explanation) {
        reply.put("status", "failed");
        reply.put("displayable-message", explanation);
        REPLMessage[] replies = new REPLMessage[]{reply};
        return replies;
    }

    protected static final REPLMessage[] finishReplyFailed(REPLMessage reply, Exception ex) {
        reply.put("status", "failed");
        String message = ex.getMessage();
        reply.put("displayable-message", message == null ? ex.getClass().getSimpleName() : message);
        REPLMessage[] replies = new REPLMessage[]{reply};
        return replies;
    }

    protected static final REPLMessage createBreakpointInfoMessage(REPLServer.BreakpointInfo info) {
        REPLMessage infoMessage = new REPLMessage("op", "breakpoint-info");
        infoMessage.put("breakpoint-id", Integer.toString(info.getID()));
        infoMessage.put("breakpoint-state", info.describeState());
        infoMessage.put("breakpoint-hit-count", Integer.toString(info.getHitCount()));
        infoMessage.put("breakpoint-ignore-count", Integer.toString(info.getIgnoreCount()));
        infoMessage.put("info-value", info.describeLocation());
        if (info.getCondition() != null) {
            infoMessage.put("breakpoint-condition", info.getCondition());
        }
        infoMessage.put("status", "succeeded");
        return infoMessage;
    }

    protected static final REPLMessage createFrameInfoMessage(REPLServer replServer, int number, Node node) {
        Visualizer visualizer = replServer.getVisualizer();
        REPLMessage infoMessage = new REPLMessage("op", "frame-info");
        infoMessage.put("frame-number", Integer.toString(number));
        infoMessage.put("source-location", visualizer.displaySourceLocation(node));
        infoMessage.put("method-name", visualizer.displayMethodName(node));
        if (node != null) {
            SourceSection section = node.getSourceSection();
            if (section == null) {
                section = node.getEncapsulatingSourceSection();
            }
            if (section != null && section.getSource() != null) {
                infoMessage.put("path", section.getSource().getPath());
                infoMessage.put("line-number", Integer.toString(section.getStartLine()));
                infoMessage.put("source-line-text", section.getSource().getCode(section.getStartLine()));
            }
        }
        infoMessage.put("status", "succeeded");
        return infoMessage;
    }

    private static REPLMessage btMessage(int index, Node node, Visualizer visualizer) {
        REPLMessage btMessage = new REPLMessage("op", "backtrace");
        btMessage.put("frame-number", Integer.toString(index));
        if (node != null) {
            btMessage.put("source-location", visualizer.displaySourceLocation(node));
            btMessage.put("method-name", visualizer.displayMethodName(node));
            SourceSection section = node.getSourceSection();
            if (section == null) {
                section = node.getEncapsulatingSourceSection();
            }
            if (section != null && section.getSource() != null) {
                btMessage.put("path", section.getSource().getPath());
                btMessage.put("line-number", Integer.toString(section.getStartLine()));
                btMessage.put("source-line-text", section.getSource().getCode(section.getStartLine()));
            }
            btMessage.put("status", "succeeded");
        }
        return btMessage;
    }
}

