/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.read;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.util.Arrays;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.nodes.SourceNode;
import org.jruby.truffle.format.runtime.MissingValue;
import org.jruby.truffle.runtime.RubyContext;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadBytesNode
extends PackNode {
    private final int count;
    private final boolean consumePartial;

    public ReadBytesNode(RubyContext context, int count, boolean consumePartial) {
        super(context);
        this.count = count;
        this.consumePartial = consumePartial;
    }

    @Specialization(guards={"isNull(source)"})
    public void read(VirtualFrame frame, Object source) {
        CompilerDirectives.transferToInterpreter();
        this.advanceSourcePosition(frame, this.count);
        throw new IllegalStateException();
    }

    @Specialization
    public Object read(VirtualFrame frame, byte[] source) {
        int index = this.advanceSourcePositionNoThrow(frame, this.count, this.consumePartial);
        if (index == -1) {
            if (this.consumePartial) {
                return MissingValue.INSTANCE;
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return Arrays.copyOfRange(source, index, index + this.count);
    }
}

