/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.charset.StandardCharsets;
import jnr.ffi.Pointer;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;

@NodeChild(value="value", type=RubyNode.class)
public abstract class WriteProgramNameNode
extends RubyNode {
    private static final int MAX_PROGRAM_NAME_LENGTH = 40;

    public WriteProgramNameNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isRubyString(value)"})
    protected Object writeProgramName(DynamicObject value) {
        if (this.getContext().getCrtExterns() != null) {
            String valueString = value.toString();
            Pointer programNameAddress = this.getContext().getCrtExterns()._NSGetArgv().getPointer(0L).getPointer(0L);
            programNameAddress.putString(0L, valueString, 40, StandardCharsets.UTF_8);
        }
        return value;
    }
}

