/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.util.ArrayUtils;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ArrayJavaProxy
extends JavaProxy {
    private final JavaUtil.JavaConverter converter;

    public ArrayJavaProxy(Ruby runtime, RubyClass klazz, Object array) {
        this(runtime, klazz, array, JavaUtil.getJavaConverter(array.getClass().getComponentType()));
    }

    public ArrayJavaProxy(Ruby runtime, RubyClass klazz, Object array, JavaUtil.JavaConverter converter) {
        super(runtime, klazz, array);
        this.converter = converter;
    }

    public static RubyClass createArrayJavaProxy(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyClass arrayJavaProxy = runtime.defineClass("ArrayJavaProxy", runtime.getJavaSupport().getJavaProxyClass(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass singleton = arrayJavaProxy.getSingletonClass();
        singleton.addMethod("new", new ArrayNewMethod(singleton, Visibility.PUBLIC));
        arrayJavaProxy.defineAnnotatedMethods(ArrayJavaProxy.class);
        arrayJavaProxy.includeModule(runtime.getEnumerable());
        return arrayJavaProxy;
    }

    static ArrayJavaProxy newArray(Ruby runtime, Class<?> elementType, int ... dimensions2) {
        Object array;
        try {
            array = Array.newInstance(elementType, dimensions2);
        }
        catch (IllegalArgumentException e) {
            throw runtime.newArgumentError("can not create " + dimensions2.length + " dimensional array");
        }
        return new ArrayJavaProxy(runtime, Java.getProxyClassForObject(runtime, array), array);
    }

    public JavaArray getJavaArray() {
        JavaArray javaArray = (JavaArray)this.dataGetStruct();
        if (javaArray == null) {
            javaArray = new JavaArray(this.getRuntime(), this.getObject());
            this.dataWrapStruct(javaArray);
        }
        return javaArray;
    }

    @JRubyMethod(name={"length", "size"})
    public RubyFixnum length(ThreadContext context) {
        return context.runtime.newFixnum(Array.getLength(this.getObject()));
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        return context.runtime.newBoolean(Array.getLength(this.getObject()) == 0);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof RubyRange) {
            return this.arrayRange(context, (RubyRange)arg2);
        }
        int i2 = ArrayJavaProxy.convertArrayIndex(arg2);
        return ArrayUtils.arefDirect(context.runtime, this.getObject(), this.converter, i2);
    }

    @JRubyMethod(name={"[]"}, required=1, rest=true)
    public IRubyObject op_aref(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 1) {
            return this.op_aref(context, args2[0]);
        }
        return this.getRange(context, args2);
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject op_aset(ThreadContext context, IRubyObject index2, IRubyObject value2) {
        int i2 = ArrayJavaProxy.convertArrayIndex(index2);
        return ArrayUtils.asetDirect(context.runtime, this.getObject(), this.converter, i2, value2);
    }

    private static int convertArrayIndex(IRubyObject index2) {
        if (index2 instanceof RubyInteger) {
            return (int)((RubyInteger)index2).getLongValue();
        }
        if (index2 instanceof JavaProxy) {
            return (Integer)index2.toJava(Integer.class);
        }
        return (int)index2.convertToInteger().getLongValue();
    }

    @JRubyMethod
    public IRubyObject at(ThreadContext context, IRubyObject index2) {
        Ruby runtime = context.runtime;
        Object array = this.getObject();
        int length2 = Array.getLength(array);
        int i2 = ArrayJavaProxy.convertArrayIndex(index2);
        if (i2 < 0) {
            i2 += length2;
        }
        if (i2 >= 0 && i2 < length2) {
            return ArrayUtils.arefDirect(runtime, array, this.converter, i2);
        }
        return context.nil;
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        Object array = this.getObject();
        if (other instanceof ArrayJavaProxy) {
            Object otherArray = ((ArrayJavaProxy)other).getObject();
            Class<?> componentType = array.getClass().getComponentType();
            if (componentType.isAssignableFrom(otherArray.getClass().getComponentType())) {
                return ArrayUtils.concatArraysDirect(context, array, otherArray);
            }
        }
        return ArrayUtils.concatArraysDirect(context, array, other);
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        Object array = this.getObject();
        int length2 = Array.getLength(array);
        for (int i2 = 0; i2 < length2; ++i2) {
            IRubyObject element = ArrayUtils.arefDirect(runtime, array, this.converter, i2);
            block.yield(context, element);
        }
        return this;
    }

    @JRubyMethod(name={"to_a", "to_ary"})
    public RubyArray to_a(ThreadContext context) {
        Object array = this.getObject();
        return JavaUtil.convertJavaArrayToRubyWithNesting(context, array);
    }

    @JRubyMethod(name={"component_type"})
    public IRubyObject component_type(ThreadContext context) {
        Class<?> componentType = this.getObject().getClass().getComponentType();
        JavaClass javaClass = JavaClass.get(context.runtime, componentType);
        return Java.getProxyClass(context.runtime, javaClass);
    }

    @JRubyMethod
    public RubyString inspect(ThreadContext context) {
        StringBuilder buffer = new StringBuilder();
        Class<?> componentClass = this.getObject().getClass().getComponentType();
        buffer.append(componentClass.getName());
        if (componentClass.isPrimitive()) {
            switch (componentClass.getName().charAt(0)) {
                case 'b': {
                    if (componentClass == Byte.TYPE) {
                        buffer.append(Arrays.toString((byte[])this.getObject()));
                    }
                    if (componentClass != Boolean.TYPE) break;
                    buffer.append(Arrays.toString((boolean[])this.getObject()));
                    break;
                }
                case 's': {
                    if (componentClass != Short.TYPE) break;
                    buffer.append(Arrays.toString((short[])this.getObject()));
                    break;
                }
                case 'c': {
                    if (componentClass != Character.TYPE) break;
                    buffer.append(Arrays.toString((char[])this.getObject()));
                    break;
                }
                case 'i': {
                    if (componentClass != Integer.TYPE) break;
                    buffer.append(Arrays.toString((int[])this.getObject()));
                    break;
                }
                case 'l': {
                    if (componentClass != Long.TYPE) break;
                    buffer.append(Arrays.toString((long[])this.getObject()));
                    break;
                }
                case 'f': {
                    if (componentClass != Float.TYPE) break;
                    buffer.append(Arrays.toString((float[])this.getObject()));
                    break;
                }
                case 'd': {
                    if (componentClass != Double.TYPE) break;
                    buffer.append(Arrays.toString((double[])this.getObject()));
                }
            }
        } else {
            buffer.append(Arrays.toString((Object[])this.getObject()));
        }
        buffer.append('@').append(Integer.toHexString(this.inspectHashCode()));
        return RubyString.newString(context.runtime, buffer.toString());
    }

    @Override
    @JRubyMethod(name={"=="})
    public RubyBoolean op_eqq(ThreadContext context, IRubyObject other) {
        return this.eql_p(context, other);
    }

    @JRubyMethod(name={"eql?"})
    public RubyBoolean eql_p(ThreadContext context, IRubyObject obj) {
        boolean equals = false;
        if (obj instanceof ArrayJavaProxy) {
            ArrayJavaProxy that = (ArrayJavaProxy)obj;
            equals = ArrayJavaProxy.arraysEquals(this.getObject(), that.getObject());
        }
        if (obj.getClass().isArray()) {
            equals = ArrayJavaProxy.arraysEquals(this.getObject(), obj);
        }
        return context.runtime.newBoolean(equals);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ArrayJavaProxy) {
            ArrayJavaProxy that = (ArrayJavaProxy)obj;
            Object thisArray = this.getObject();
            Object thatArray = that.getObject();
            return ArrayJavaProxy.arraysEquals(thisArray, thatArray);
        }
        return false;
    }

    private static boolean arraysEquals(Object thisArray, Object thatArray) {
        Class<?> componentType = thisArray.getClass().getComponentType();
        if (!componentType.equals(thatArray.getClass().getComponentType())) {
            return false;
        }
        if (componentType.isPrimitive()) {
            switch (componentType.getName().charAt(0)) {
                case 'b': {
                    if (componentType == Byte.TYPE) {
                        return Arrays.equals((byte[])thisArray, (byte[])thatArray);
                    }
                    if (componentType == Boolean.TYPE) {
                        return Arrays.equals((boolean[])thisArray, (boolean[])thatArray);
                    }
                }
                case 's': {
                    if (componentType == Short.TYPE) {
                        return Arrays.equals((short[])thisArray, (short[])thatArray);
                    }
                }
                case 'c': {
                    if (componentType == Character.TYPE) {
                        return Arrays.equals((char[])thisArray, (char[])thatArray);
                    }
                }
                case 'i': {
                    if (componentType == Integer.TYPE) {
                        return Arrays.equals((int[])thisArray, (int[])thatArray);
                    }
                }
                case 'l': {
                    if (componentType == Long.TYPE) {
                        return Arrays.equals((long[])thisArray, (long[])thatArray);
                    }
                }
                case 'f': {
                    if (componentType == Float.TYPE) {
                        return Arrays.equals((float[])thisArray, (float[])thatArray);
                    }
                }
                case 'd': {
                    if (componentType != Double.TYPE) break;
                    return Arrays.equals((double[])thisArray, (double[])thatArray);
                }
            }
        }
        return Arrays.equals((Object[])thisArray, (Object[])thatArray);
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    public int hashCode() {
        Object array = this.getObject();
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            switch (componentType.getName().charAt(0)) {
                case 'b': {
                    if (componentType == Byte.TYPE) {
                        return 11 * Arrays.hashCode((byte[])array);
                    }
                    if (componentType == Boolean.TYPE) {
                        return 11 * Arrays.hashCode((boolean[])array);
                    }
                }
                case 's': {
                    if (componentType == Short.TYPE) {
                        return 11 * Arrays.hashCode((short[])array);
                    }
                }
                case 'c': {
                    if (componentType == Character.TYPE) {
                        return 11 * Arrays.hashCode((char[])array);
                    }
                }
                case 'i': {
                    if (componentType == Integer.TYPE) {
                        return 11 * Arrays.hashCode((int[])array);
                    }
                }
                case 'l': {
                    if (componentType == Long.TYPE) {
                        return 11 * Arrays.hashCode((long[])array);
                    }
                }
                case 'f': {
                    if (componentType == Float.TYPE) {
                        return 11 * Arrays.hashCode((float[])array);
                    }
                }
                case 'd': {
                    if (componentType != Double.TYPE) break;
                    return 11 * Arrays.hashCode((double[])array);
                }
            }
        }
        return 11 * Arrays.hashCode((Object[])array);
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 1) {
            return this.getRange(context, args2[0]);
        }
        if (args2.length == 2) {
            return this.getRange(context, args2[0], args2[1]);
        }
        throw context.runtime.newArgumentError(args2.length, 1);
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject arg0) {
        if (arg0 instanceof RubyRange) {
            return this.arrayRange(context, (RubyRange)arg0);
        }
        throw context.runtime.newTypeError(arg0, context.runtime.getRange());
    }

    private IRubyObject arrayRange(ThreadContext context, RubyRange range) {
        Object array = this.getObject();
        int arrayLength = Array.getLength(array);
        IRubyObject rFirst = range.first(context);
        IRubyObject rLast = range.last(context);
        if (rFirst instanceof RubyFixnum && rLast instanceof RubyFixnum) {
            int first2 = (int)((RubyFixnum)rFirst).getLongValue();
            int last2 = (int)((RubyFixnum)rLast).getLongValue();
            first2 = first2 >= 0 ? first2 : arrayLength + first2;
            last2 = last2 >= 0 ? last2 : arrayLength + last2;
            int newLength = last2 - first2;
            if (range.exclude_end_p().isFalse()) {
                ++newLength;
            }
            if (newLength <= 0) {
                return ArrayUtils.emptyJavaArrayDirect(context, array.getClass().getComponentType());
            }
            return ArrayUtils.javaArraySubarrayDirect(context, array, first2, newLength);
        }
        throw context.runtime.newTypeError("only Fixnum ranges supported");
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject first2, IRubyObject length2) {
        return this.arrayRange(context, first2, length2);
    }

    private IRubyObject arrayRange(ThreadContext context, IRubyObject rFirst, IRubyObject rLength) {
        Object array = this.getObject();
        int arrayLength = Array.getLength(array);
        if (rFirst instanceof RubyFixnum && rLength instanceof RubyFixnum) {
            int first2 = (int)((RubyFixnum)rFirst).getLongValue();
            int length2 = (int)((RubyFixnum)rLength).getLongValue();
            if (length2 > arrayLength) {
                throw context.runtime.newIndexError("length specifed is longer than array");
            }
            if (length2 <= 0) {
                return ArrayUtils.emptyJavaArrayDirect(context, array.getClass().getComponentType());
            }
            first2 = first2 >= 0 ? first2 : arrayLength + first2;
            return ArrayUtils.javaArraySubarrayDirect(context, array, first2, length2);
        }
        throw context.runtime.newTypeError("only Fixnum ranges supported");
    }

    public static class ArrayNewMethod
    extends JavaMethod.JavaMethodOne {
        private final DynamicMethod newMethod;

        ArrayNewMethod(RubyModule implClass, Visibility visibility) {
            this(implClass, visibility, implClass.searchMethod("new"));
        }

        public ArrayNewMethod(RubyModule implClass, Visibility visibility, DynamicMethod oldNew) {
            super(implClass, visibility);
            this.newMethod = oldNew;
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0) {
            Ruby runtime = context.runtime;
            if (!(arg0 instanceof JavaArray)) {
                throw runtime.newTypeError(arg0, runtime.getJavaSupport().getJavaArrayClass());
            }
            IRubyObject proxy2 = this.newMethod.call(context, self2, clazz, "new_proxy");
            proxy2.dataWrapStruct(arg0);
            return proxy2;
        }
    }
}

