/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import junit.framework.TestCase;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.RuleMatch;

public class DoublePunctuationRuleTest
extends TestCase {
    public void testRule() throws IOException {
        DoublePunctuationRule rule = new DoublePunctuationRule(TestTools.getEnglishMessages());
        JLanguageTool langTool = new JLanguageTool(TestTools.getDemoLanguage());
        RuleMatch[] matches = rule.match(langTool.getAnalyzedSentence("This is a test sentence..."));
        DoublePunctuationRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\u042d\u0442\u043e \u0442\u0435\u0441\u0442\u043e\u0432\u043e\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435?.."));
        DoublePunctuationRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\u042d\u0442\u043e \u0442\u0435\u0441\u0442\u043e\u0432\u043e\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435!.."));
        DoublePunctuationRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This is a test sentence... More stuff...."));
        DoublePunctuationRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This is a test sentence..... More stuff...."));
        DoublePunctuationRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This, is, a test sentence."));
        DoublePunctuationRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This,, is a test sentence."));
        DoublePunctuationRuleTest.assertEquals((int)1, (int)matches.length);
        DoublePunctuationRuleTest.assertEquals((int)4, (int)matches[0].getFromPos());
        DoublePunctuationRuleTest.assertEquals((int)6, (int)matches[0].getToPos());
        matches = rule.match(langTool.getAnalyzedSentence("This is a test sentence.. Another sentence"));
        DoublePunctuationRuleTest.assertEquals((int)1, (int)matches.length);
        DoublePunctuationRuleTest.assertEquals((int)23, (int)matches[0].getFromPos());
        DoublePunctuationRuleTest.assertEquals((int)25, (int)matches[0].getToPos());
    }
}

