/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RegexPatternRule;

public class RegexPatternRuleTest {
    @Test
    public void testMatch() throws IOException {
        RegexPatternRule rule = new RegexPatternRule("ID", "desc", "msg: <suggestion>a suggestion \\1</suggestion>", "<suggestion>another suggestion \\2</suggestion>", TestTools.getDemoLanguage(), Pattern.compile("(fo.) (bar)"), 0);
        JLanguageTool lt = new JLanguageTool(TestTools.getDemoLanguage());
        RuleMatch[] matches1 = rule.match(lt.getAnalyzedSentence("This is a test"));
        Assert.assertThat((Object)matches1.length, (Matcher)Is.is((Object)0));
        RuleMatch[] matches2 = rule.match(lt.getAnalyzedSentence("This is foo bar"));
        Assert.assertThat((Object)matches2.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)matches2[0].getFromPos(), (Matcher)Is.is((Object)8));
        Assert.assertThat((Object)matches2[0].getToPos(), (Matcher)Is.is((Object)15));
        RuleMatch[] matches3 = rule.match(lt.getAnalyzedSentence("This is foo bar and fou bar"));
        Assert.assertThat((Object)matches3.length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)matches3[0].getFromPos(), (Matcher)Is.is((Object)8));
        Assert.assertThat((Object)matches3[0].getToPos(), (Matcher)Is.is((Object)15));
        Assert.assertThat((Object)matches3[0].getMessage(), (Matcher)Is.is((Object)"msg: <suggestion>a suggestion foo</suggestion>"));
        Assert.assertThat((Object)matches3[0].getSuggestedReplacements().toString(), (Matcher)Is.is((Object)"[a suggestion foo, another suggestion bar]"));
        Assert.assertThat((Object)matches3[1].getFromPos(), (Matcher)Is.is((Object)20));
        Assert.assertThat((Object)matches3[1].getToPos(), (Matcher)Is.is((Object)27));
        Assert.assertThat((Object)matches3[1].getMessage(), (Matcher)Is.is((Object)"msg: <suggestion>a suggestion fou</suggestion>"));
        Assert.assertThat((Object)matches3[1].getSuggestedReplacements().toString(), (Matcher)Is.is((Object)"[a suggestion fou, another suggestion bar]"));
    }

    @Test
    public void testMatchWithMark() throws IOException {
        RegexPatternRule rule = new RegexPatternRule("ID", "desc", "msg: <suggestion>a suggestion \\1</suggestion>", "<suggestion>another suggestion \\2</suggestion>", TestTools.getDemoLanguage(), Pattern.compile("(fo.) (bar)"), 1);
        JLanguageTool lt = new JLanguageTool(TestTools.getDemoLanguage());
        RuleMatch[] matches2 = rule.match(lt.getAnalyzedSentence("This is foo bar"));
        Assert.assertThat((Object)matches2.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)matches2[0].getFromPos(), (Matcher)Is.is((Object)8));
        Assert.assertThat((Object)matches2[0].getToPos(), (Matcher)Is.is((Object)11));
    }
}

