/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanScorer;
import org.apache.lucene.search.BooleanTopLevelScorers;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConjunctionScorer;
import org.apache.lucene.search.DisjunctionSumScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MinShouldMatchSumScorer;
import org.apache.lucene.search.ReqExclScorer;
import org.apache.lucene.search.ReqOptSumScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;

public class BooleanWeight
extends Weight {
    protected Similarity similarity;
    protected final BooleanQuery query;
    protected ArrayList<Weight> weights;
    protected int maxCoord;
    private final boolean disableCoord;
    private final boolean needsScores;
    private final float[] coords;

    public BooleanWeight(BooleanQuery query, IndexSearcher searcher, boolean needsScores, boolean disableCoord) throws IOException {
        super(query);
        this.query = query;
        this.needsScores = needsScores;
        this.similarity = searcher.getSimilarity(needsScores);
        this.weights = new ArrayList(query.clauses().size());
        for (int i = 0; i < query.clauses().size(); ++i) {
            BooleanClause c = query.clauses().get(i);
            Weight w = searcher.createWeight(c.getQuery(), needsScores && c.isScoring());
            this.weights.add(w);
            if (!c.isScoring()) continue;
            ++this.maxCoord;
        }
        this.coords = new float[this.maxCoord + 1];
        Arrays.fill(this.coords, 1.0f);
        this.coords[0] = 0.0f;
        if (this.maxCoord > 0 && needsScores && !disableCoord) {
            boolean seenActualCoord = false;
            for (int i = 1; i < this.coords.length; ++i) {
                this.coords[i] = this.coord(i, this.maxCoord);
                seenActualCoord |= this.coords[i] != 1.0f;
            }
            this.disableCoord = !seenActualCoord;
        } else {
            this.disableCoord = true;
        }
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        int i = 0;
        for (BooleanClause clause : this.query.clauses()) {
            if (clause.isScoring() || !this.needsScores && !clause.isProhibited()) {
                this.weights.get(i).extractTerms(terms);
            }
            ++i;
        }
    }

    @Override
    public float getValueForNormalization() throws IOException {
        float sum = 0.0f;
        for (int i = 0; i < this.weights.size(); ++i) {
            float s = this.weights.get(i).getValueForNormalization();
            if (!this.query.clauses().get(i).isScoring()) continue;
            sum += s;
        }
        return sum *= this.query.getBoost() * this.query.getBoost();
    }

    public float coord(int overlap, int maxOverlap) {
        if (overlap == 0) {
            return 0.0f;
        }
        if (maxOverlap == 1) {
            return 1.0f;
        }
        return this.similarity.coord(overlap, maxOverlap);
    }

    @Override
    public void normalize(float norm, float topLevelBoost) {
        topLevelBoost *= this.query.getBoost();
        for (Weight w : this.weights) {
            w.normalize(norm, topLevelBoost);
        }
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        float coordFactor;
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        int coord = 0;
        float sum = 0.0f;
        boolean fail = false;
        int matchCount = 0;
        int shouldMatchCount = 0;
        Iterator<BooleanClause> cIter = this.query.clauses().iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            Explanation e = w.explain(context, doc);
            if (e.isMatch()) {
                if (c.isScoring()) {
                    subs.add(e);
                    sum += e.getValue();
                    ++coord;
                } else if (c.isRequired()) {
                    subs.add(Explanation.match(0.0f, "match on required clause, product of:", Explanation.match(0.0f, (Object)((Object)BooleanClause.Occur.FILTER) + " clause", new Explanation[0]), e));
                } else if (c.isProhibited()) {
                    subs.add(Explanation.noMatch("match on prohibited clause (" + c.getQuery().toString() + ")", e));
                    fail = true;
                }
                if (!c.isProhibited()) {
                    ++matchCount;
                }
                if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
                ++shouldMatchCount;
                continue;
            }
            if (!c.isRequired()) continue;
            subs.add(Explanation.noMatch("no match on required clause (" + c.getQuery().toString() + ")", e));
            fail = true;
        }
        if (fail) {
            return Explanation.noMatch("Failure to meet condition(s) of required/prohibited clause(s)", subs);
        }
        if (matchCount == 0) {
            return Explanation.noMatch("No matching clauses", subs);
        }
        if (shouldMatchCount < minShouldMatch) {
            return Explanation.noMatch("Failure to match minimum number of optional clauses: " + minShouldMatch, subs);
        }
        Explanation result = Explanation.match(sum, "sum of:", subs);
        float f = coordFactor = this.disableCoord ? 1.0f : this.coord(coord, this.maxCoord);
        if (coordFactor != 1.0f) {
            result = Explanation.match(sum * coordFactor, "product of:", result, Explanation.match(coordFactor, "coord(" + coord + "/" + this.maxCoord + ")", new Explanation[0]));
        }
        return result;
    }

    BooleanScorer booleanScorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
        ArrayList<BulkScorer> optional = new ArrayList<BulkScorer>();
        Iterator<BooleanClause> cIter = this.query.clauses().iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            BulkScorer subScorer = w.bulkScorer(context, acceptDocs);
            if (subScorer == null) {
                if (!c.isRequired()) continue;
                return null;
            }
            if (c.isRequired()) {
                return null;
            }
            if (c.isProhibited()) {
                return null;
            }
            optional.add(subScorer);
        }
        if (optional.size() == 0) {
            return null;
        }
        if (this.query.minNrShouldMatch > optional.size()) {
            return null;
        }
        return new BooleanScorer(this, this.disableCoord, this.maxCoord, optional, Math.max(1, this.query.minNrShouldMatch), this.needsScores);
    }

    @Override
    public BulkScorer bulkScorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
        BooleanScorer bulkScorer = this.booleanScorer(context, acceptDocs);
        if (bulkScorer != null) {
            long costThreshold = this.query.minNrShouldMatch <= 1 ? -1L : (long)(context.reader().maxDoc() / 3);
            if (bulkScorer.cost() > costThreshold) {
                return bulkScorer;
            }
        }
        return super.bulkScorer(context, acceptDocs);
    }

    @Override
    public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
        int minShouldMatch = this.query.minNrShouldMatch;
        ArrayList<Scorer> required = new ArrayList<Scorer>();
        ArrayList<Scorer> requiredScoring = new ArrayList<Scorer>();
        ArrayList<Scorer> prohibited = new ArrayList<Scorer>();
        ArrayList<Scorer> optional = new ArrayList<Scorer>();
        Iterator<BooleanClause> cIter = this.query.clauses().iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            Scorer subScorer = w.scorer(context, acceptDocs);
            if (subScorer == null) {
                if (!c.isRequired()) continue;
                return null;
            }
            if (c.isRequired()) {
                required.add(subScorer);
                if (!c.isScoring()) continue;
                requiredScoring.add(subScorer);
                continue;
            }
            if (c.isProhibited()) {
                prohibited.add(subScorer);
                continue;
            }
            optional.add(subScorer);
        }
        if (optional.size() == minShouldMatch) {
            required.addAll(optional);
            requiredScoring.addAll(optional);
            optional.clear();
            minShouldMatch = 0;
        }
        if (required.isEmpty() && optional.isEmpty()) {
            return null;
        }
        if (optional.size() < minShouldMatch) {
            return null;
        }
        if (!this.needsScores && minShouldMatch == 0 && required.size() > 0) {
            optional.clear();
        }
        if (optional.isEmpty()) {
            return this.excl(this.req(required, requiredScoring, this.disableCoord), prohibited);
        }
        if (required.isEmpty()) {
            return this.excl(this.opt(optional, minShouldMatch, this.disableCoord), prohibited);
        }
        Scorer req = this.excl(this.req(required, requiredScoring, true), prohibited);
        Scorer opt = this.opt(optional, minShouldMatch, true);
        if (this.disableCoord) {
            if (minShouldMatch > 0) {
                return new ConjunctionScorer(this, Arrays.asList(req, opt), Arrays.asList(req, opt), 1.0f);
            }
            return new ReqOptSumScorer(req, opt);
        }
        if (optional.size() == 1) {
            if (minShouldMatch > 0) {
                return new ConjunctionScorer(this, Arrays.asList(req, opt), Arrays.asList(req, opt), this.coord(requiredScoring.size() + 1, this.maxCoord));
            }
            float coordReq = this.coord(requiredScoring.size(), this.maxCoord);
            float coordBoth = this.coord(requiredScoring.size() + 1, this.maxCoord);
            return new BooleanTopLevelScorers.ReqSingleOptScorer(req, opt, coordReq, coordBoth);
        }
        if (minShouldMatch > 0) {
            return new BooleanTopLevelScorers.CoordinatingConjunctionScorer(this, this.coords, req, requiredScoring.size(), opt);
        }
        return new BooleanTopLevelScorers.ReqMultiOptScorer(req, opt, requiredScoring.size(), this.coords);
    }

    private Scorer req(List<Scorer> required, List<Scorer> requiredScoring, boolean disableCoord) {
        if (required.size() == 1) {
            Scorer req = required.get(0);
            if (!this.needsScores || requiredScoring.size() == 1 && (disableCoord || this.maxCoord == 1)) {
                return req;
            }
            return new BooleanTopLevelScorers.BoostedScorer(req, this.coord(requiredScoring.size(), this.maxCoord));
        }
        return new ConjunctionScorer(this, required, requiredScoring, disableCoord ? 1.0f : this.coord(requiredScoring.size(), this.maxCoord));
    }

    private Scorer excl(Scorer main, List<Scorer> prohibited) throws IOException {
        if (prohibited.isEmpty()) {
            return main;
        }
        if (prohibited.size() == 1) {
            return new ReqExclScorer(main, prohibited.get(0));
        }
        float[] coords = new float[prohibited.size() + 1];
        Arrays.fill(coords, 1.0f);
        return new ReqExclScorer(main, new DisjunctionSumScorer(this, prohibited, coords, false));
    }

    private Scorer opt(List<Scorer> optional, int minShouldMatch, boolean disableCoord) throws IOException {
        float[] coords;
        if (optional.size() == 1) {
            Scorer opt = optional.get(0);
            if (!disableCoord && this.maxCoord > 1) {
                return new BooleanTopLevelScorers.BoostedScorer(opt, this.coord(1, this.maxCoord));
            }
            return opt;
        }
        if (disableCoord) {
            coords = new float[optional.size() + 1];
            Arrays.fill(coords, 1.0f);
        } else {
            coords = this.coords;
        }
        if (minShouldMatch > 1) {
            return new MinShouldMatchSumScorer(this, optional, minShouldMatch, coords);
        }
        return new DisjunctionSumScorer(this, optional, coords, this.needsScores);
    }
}

