/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.banner;

import java.io.File;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.io.FileType;
import org.pdfsam.ui.RecentWorkspacesService;
import org.pdfsam.ui.banner.WorkspaceMenuItem;
import org.pdfsam.ui.io.FileChoosers;
import org.pdfsam.ui.io.RememberingLatestFileChooserWrapper;
import org.pdfsam.ui.workspace.LoadWorkspaceEvent;
import org.pdfsam.ui.workspace.SaveWorkspaceEvent;
import org.pdfsam.ui.workspace.WorkspaceLoadedEvent;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;

@Named
class WorkspaceMenu
extends Menu {
    private RecentWorkspacesService service;
    private Menu recent;

    @Inject
    public WorkspaceMenu(RecentWorkspacesService service) {
        super(DefaultI18nContext.getInstance().i18n("_Workspace"));
        this.service = service;
        this.setId("workspaceMenu");
        MenuItem load = new MenuItem(DefaultI18nContext.getInstance().i18n("_Load"));
        load.setId("loadWorkspace");
        load.setOnAction(e -> this.loadWorkspace());
        MenuItem save = new MenuItem(DefaultI18nContext.getInstance().i18n("_Save"));
        save.setOnAction(e -> this.saveWorkspace());
        save.setId("saveWorkspace");
        this.recent = new Menu(DefaultI18nContext.getInstance().i18n("Recen_t"));
        this.recent.setId("recentWorkspace");
        service.getRecentlyUsedWorkspaces().stream().map(WorkspaceMenuItem::new).forEach(arg_0 -> this.recent.getItems().add(arg_0));
        this.getItems().addAll((Object[])new MenuItem[]{load, save, new SeparatorMenuItem(), this.recent});
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    public void saveWorkspace() {
        RememberingLatestFileChooserWrapper fileChooser = FileChoosers.getFileChooser(FileType.JSON, DefaultI18nContext.getInstance().i18n("Select the workspace file to save"));
        fileChooser.setInitialFileName("PDFsam_workspace.json");
        File chosenFile = fileChooser.showDialog(RememberingLatestFileChooserWrapper.OpenType.SAVE);
        if (chosenFile != null) {
            StaticStudio.eventStudio().broadcast(new SaveWorkspaceEvent(chosenFile));
        }
    }

    public void loadWorkspace() {
        RememberingLatestFileChooserWrapper fileChooser = FileChoosers.getFileChooser(FileType.JSON, DefaultI18nContext.getInstance().i18n("Select the workspace to load"));
        File chosenFile = fileChooser.showDialog(RememberingLatestFileChooserWrapper.OpenType.OPEN);
        if (chosenFile != null) {
            StaticStudio.eventStudio().broadcast(new LoadWorkspaceEvent(chosenFile));
        }
    }

    @EventListener
    public void onWorkspaceLoaded(WorkspaceLoadedEvent e) {
        this.recent.getItems().clear();
        this.service.getRecentlyUsedWorkspaces().stream().map(WorkspaceMenuItem::new).forEach(arg_0 -> this.recent.getItems().add(arg_0));
    }
}

