/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dialog;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.ui.commons.NonExistingOutputDirectoryEvent;
import org.pdfsam.ui.dialog.CreateOutputDirectoryConfirmationDialog;
import org.pdfsam.ui.dialog.OverwriteDialogController;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class CreateOutputDirectoryDialogController {
    private static final Logger LOG = LoggerFactory.getLogger(OverwriteDialogController.class);
    private CreateOutputDirectoryConfirmationDialog dialog;

    @Inject
    public CreateOutputDirectoryDialogController(CreateOutputDirectoryConfirmationDialog dialog) {
        this.dialog = dialog;
        StaticStudio.eventStudio().addAnnotatedListeners(this);
    }

    @EventListener
    public void request(NonExistingOutputDirectoryEvent event) {
        try {
            if (this.dialog.response()) {
                Files.createDirectories(event.outputDirectory, new FileAttribute[0]);
                LOG.debug("Created output directory {}", (Object)event.outputDirectory);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to create output directory", e);
        }
    }
}

