/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import java.util.Collections;
import java.util.Set;
import javafx.beans.property.SimpleStringProperty;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.conversion.AdapterUtils;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.pdf.page.PageRange;

public final class SelectionTableRowData {
    private PdfDocumentDescriptor descriptor;
    private SimpleStringProperty pageSelection = new SimpleStringProperty("");

    public SelectionTableRowData(PdfDocumentDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public SelectionTableRowData(PdfDocumentDescriptor descriptor, String pageSelection) {
        this(descriptor);
        this.pageSelection.set(StringUtils.defaultString(pageSelection));
    }

    public String getPageSelection() {
        return this.pageSelection.get();
    }

    public void setPageSelection(String pageSelection) {
        this.pageSelection.set(StringUtils.defaultString(pageSelection));
    }

    public SimpleStringProperty pageSelectionProperty() {
        return this.pageSelection;
    }

    public SelectionTableRowData duplicate() {
        this.descriptor.retain();
        return new SelectionTableRowData(this.descriptor, this.pageSelection.get());
    }

    public PdfDocumentDescriptor descriptor() {
        return this.descriptor;
    }

    public void invalidate() {
        this.descriptor.release();
    }

    public Set<PageRange> toPageRangeSet() throws ConversionException {
        if (StringUtils.isNotBlank(this.pageSelection.get())) {
            String[] tokens;
            NullSafeSet<PageRange> pageRangeSet = new NullSafeSet<PageRange>();
            for (String current : tokens = AdapterUtils.splitAndTrim(this.pageSelection.get(), ",")) {
                PageRange range = this.toPageRange(current);
                if (range.getEnd() < range.getStart()) {
                    throw new ConversionException(DefaultI18nContext.getInstance().i18n("Invalid range: {0}.", range.toString()));
                }
                pageRangeSet.add(range);
            }
            return pageRangeSet;
        }
        return Collections.emptySet();
    }

    private PageRange toPageRange(String value) throws ConversionException {
        String[] limits = AdapterUtils.splitAndTrim(value, "-");
        if (limits.length > 2) {
            throw new ConversionException(DefaultI18nContext.getInstance().i18n("Ambiguous page range definition: {0}. Use following formats: [n] or [n1-n2] or [-n] or [n-]", value));
        }
        if (limits.length == 1) {
            int limitNumber = this.parsePageNumber(limits[0]);
            if (value.endsWith("-")) {
                return new PageRange(limitNumber);
            }
            if (value.startsWith("-")) {
                return new PageRange(1, limitNumber);
            }
            return new PageRange(limitNumber, limitNumber);
        }
        return new PageRange(this.parsePageNumber(limits[0]), this.parsePageNumber(limits[1]));
    }

    private int parsePageNumber(String value) throws ConversionException {
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ConversionException(DefaultI18nContext.getInstance().i18n("Invalid number: {0}.", value));
        }
    }
}

