/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.sejda.impl.sambox.component.OutlineItem;
import org.sejda.impl.sambox.component.OutlineUtils;
import org.sejda.model.outline.OutlineExtractPageDestinations;
import org.sejda.model.outline.OutlineLevelsHandler;
import org.sejda.model.outline.OutlinePageDestinations;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;

public class SamboxOutlineLevelsHandler
implements OutlineLevelsHandler {
    private Pattern titleMatchingPattern = Pattern.compile(".+");
    private PDDocument document;
    private PDPageTree pages;

    public SamboxOutlineLevelsHandler(PDDocument document, String matchingTitleRegEx) {
        Objects.requireNonNull(document, "Unable to retrieve bookmarks from a null document.");
        this.document = document;
        this.pages = document.getPages();
        if (StringUtils.isNotBlank(matchingTitleRegEx)) {
            this.titleMatchingPattern = Pattern.compile(matchingTitleRegEx);
        }
    }

    @Override
    public int getMaxOutlineDepth() {
        return OutlineUtils.getMaxOutlineLevel(this.document);
    }

    @Override
    public OutlinePageDestinations getPageDestinationsForLevel(int level) {
        OutlinePageDestinations destinations = new OutlinePageDestinations();
        this.addPageIfOutlineLevel(this.document.getDocumentCatalog().getDocumentOutline(), 1, destinations, level);
        return destinations;
    }

    private void addPageIfOutlineLevel(PDOutlineNode outline, int currentLevel, OutlinePageDestinations destinations, int levelToAdd) {
        if (outline != null) {
            for (PDOutlineItem current : outline.children()) {
                if (currentLevel > levelToAdd) continue;
                OutlineUtils.toPageDestination(current, this.document.getDocumentCatalog()).ifPresent(d -> {
                    if (this.isLevelToBeAdded(currentLevel, levelToAdd)) {
                        this.addPageIfValid(destinations, (PDPageDestination)d, current.getTitle());
                    } else {
                        this.addPageIfOutlineLevel(current, currentLevel + 1, destinations, levelToAdd);
                    }
                });
            }
        }
    }

    private boolean isLevelToBeAdded(int currentLevel, int levelToAdd) {
        return currentLevel == levelToAdd;
    }

    private void addPageIfValid(OutlinePageDestinations destinations, PDPageDestination destination, String title) {
        Matcher matcher;
        if (StringUtils.isNotBlank(title) && (matcher = this.titleMatchingPattern.matcher(title)).matches()) {
            destinations.addPage(this.pages.indexOf(destination.getPage()) + 1, title);
        }
    }

    @Override
    public OutlineExtractPageDestinations getExtractPageDestinations(int level) {
        OutlineExtractPageDestinations destinations = new OutlineExtractPageDestinations();
        List<OutlineItem> flatOutline = this.getFlatOutline();
        for (int i = 0; i < flatOutline.size(); ++i) {
            OutlineItem item = flatOutline.get(i);
            if (item.level != level) continue;
            int startPage = item.page;
            String title = item.title;
            if (!StringUtils.isNotBlank(title) || !this.titleMatchingPattern.matcher(title).matches()) continue;
            int endPage = this.document.getNumberOfPages();
            for (int j = i + 1; j < flatOutline.size(); ++j) {
                OutlineItem after = flatOutline.get(j);
                if (after.level > item.level) continue;
                endPage = after.page;
                break;
            }
            destinations.add(startPage, title, endPage);
        }
        return destinations;
    }

    private List<OutlineItem> getFlatOutline() {
        PDDocumentOutline outline = this.document.getDocumentCatalog().getDocumentOutline();
        if (outline == null) {
            return new ArrayList<OutlineItem>();
        }
        List<OutlineItem> result = this.recurseFlatOutline(outline.children(), 1);
        Collections.sort(result);
        return result;
    }

    private List<OutlineItem> recurseFlatOutline(Iterable<PDOutlineItem> items, int level) {
        ArrayList<OutlineItem> result = new ArrayList<OutlineItem>();
        for (PDOutlineItem item : items) {
            OutlineUtils.toPageDestination(item, this.document.getDocumentCatalog()).ifPresent(d -> {
                PDPage page = d.getPage();
                int pageNumber = page != null ? this.pages.indexOf(page) + 1 : d.getPageNumber();
                boolean specificLocation = d instanceof PDPageXYZDestination;
                result.add(new OutlineItem(item.getTitle(), pageNumber, level, specificLocation));
            });
            result.addAll(this.recurseFlatOutline(item.children(), level + 1));
        }
        return result;
    }
}

