/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.optimizaton;

import java.util.function.Consumer;
import org.sejda.impl.sambox.component.optimizaton.ResourceDictionaryCleaner;
import org.sejda.model.optimization.Optimization;
import org.sejda.model.parameter.OptimizeParameters;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;

final class Optimizers {
    private Optimizers() {
    }

    static Consumer<PDDocument> documentOptimizer(Optimization optimization) {
        switch (optimization) {
            case DISCARD_METADATA: {
                return d -> d.getDocumentCatalog().getCOSObject().removeItem(COSName.METADATA);
            }
            case DISCARD_THREADS: {
                return d -> d.getDocumentCatalog().getCOSObject().removeItem(COSName.THREADS);
            }
            case DISCARD_OUTLINE: {
                return d -> d.getDocumentCatalog().getCOSObject().removeItem(COSName.OUTLINES);
            }
            case DISCARD_SPIDER_INFO: {
                return d -> d.getDocumentCatalog().getCOSObject().removeItem(COSName.getPDFName("SpiderInfo"));
            }
            case DISCARD_PIECE_INFO: {
                return d -> d.getDocumentCatalog().getCOSObject().removeItem(COSName.PIECE_INFO);
            }
            case DISCARD_STRUCTURE_TREE: {
                return d -> d.getDocumentCatalog().getCOSObject().removeItem(COSName.STRUCT_TREE_ROOT);
            }
            case DISCARD_UNUSED_IMAGES: {
                return new ResourceDictionaryCleaner();
            }
        }
        return null;
    }

    static Consumer<PDPage> pageOptimizer(Optimization optimization, OptimizeParameters parameters) {
        switch (optimization) {
            case DISCARD_PIECE_INFO: {
                return p -> p.getCOSObject().removeItem(COSName.getPDFName("PieceInfo"));
            }
            case DISCARD_THUMBNAILS: {
                return p -> p.getCOSObject().removeItem(COSName.getPDFName("Thumb"));
            }
            case DISCARD_MC_PROPERTIES: {
                return p -> p.getResources().getCOSObject().removeItem(COSName.PROPERTIES);
            }
        }
        return null;
    }
}

