/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.input.PdfSource;
import org.sejda.model.output.MultipleTaskOutput;
import org.sejda.model.parameter.base.AbstractParameters;
import org.sejda.model.parameter.base.MultipleOutputTaskParameters;
import org.sejda.model.parameter.base.MultiplePdfSourceTaskParameters;
import org.sejda.model.validation.constraint.NotEmpty;

public class ExtractTextParameters
extends AbstractParameters
implements MultiplePdfSourceTaskParameters,
MultipleOutputTaskParameters {
    private String outputPrefix = "";
    @Valid
    @NotNull
    private MultipleTaskOutput<?> output;
    @NotEmpty
    @Valid
    private List<PdfSource<?>> sourceList = new ArrayList();
    @NotEmpty
    private String textEncoding = "UTF-8";

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(String textEncoding) {
        this.textEncoding = textEncoding;
    }

    public MultipleTaskOutput<?> getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(MultipleTaskOutput<?> output) {
        this.output = output;
    }

    @Override
    public String getOutputPrefix() {
        return this.outputPrefix;
    }

    @Override
    public void setOutputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    @Override
    public void addSource(PdfSource<?> input) {
        this.sourceList.add(input);
    }

    @Override
    public List<PdfSource<?>> getSourceList() {
        return Collections.unmodifiableList(this.sourceList);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.output).append(this.sourceList).append(this.textEncoding).append(this.outputPrefix).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExtractTextParameters)) {
            return false;
        }
        ExtractTextParameters parameter = (ExtractTextParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.output, parameter.output).append(this.sourceList, parameter.sourceList).append(this.textEncoding, parameter.textEncoding).append(this.outputPrefix, parameter.outputPrefix).isEquals();
    }
}

