/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.model.parameter.base.MultiplePdfSourceMultipleOutputParameters;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PageRangeSelection;
import org.sejda.model.pdf.page.PagesSelection;
import org.sejda.model.pdf.page.PredefinedSetOfPages;
import org.sejda.model.rotation.Rotation;

public class RotateParameters
extends MultiplePdfSourceMultipleOutputParameters
implements PagesSelection,
PageRangeSelection {
    @Valid
    @NotNull
    private Rotation rotation = null;
    @NotNull
    private PredefinedSetOfPages predefinedSetOfPages;
    @Valid
    private final Map<PageRange, Rotation> pageSelection = new HashMap<PageRange, Rotation>();

    public RotateParameters(Rotation rotation, PredefinedSetOfPages predefinedSetOfPages) {
        this.rotation = rotation;
        this.predefinedSetOfPages = predefinedSetOfPages;
    }

    public RotateParameters(Rotation rotation) {
        this(rotation, PredefinedSetOfPages.NONE);
    }

    public RotateParameters() {
        this(Rotation.DEGREES_0);
    }

    @Deprecated
    public Rotation getRotation() {
        return this.rotation;
    }

    public Rotation getRotation(int page) {
        return this.pageSelection.keySet().stream().filter(range -> range.contains(page)).findFirst().map(this.pageSelection::get).orElse(this.rotation);
    }

    public void addPageRange(PageRange range) {
        this.pageSelection.put(range, this.rotation);
    }

    public void addPageRange(PageRange range, Rotation rotation) {
        this.pageSelection.put(range, rotation);
    }

    public void addAllPageRanges(Collection<PageRange> ranges) {
        ranges.forEach(this::addPageRange);
    }

    public PredefinedSetOfPages getPredefinedSetOfPages() {
        return this.predefinedSetOfPages;
    }

    @Override
    public Set<PageRange> getPageSelection() {
        return Collections.unmodifiableSet(this.pageSelection.keySet());
    }

    @Override
    public Set<Integer> getPages(int upperLimit) {
        if (this.predefinedSetOfPages != PredefinedSetOfPages.NONE) {
            return this.predefinedSetOfPages.getPages(upperLimit);
        }
        NullSafeSet<Integer> retSet = new NullSafeSet<Integer>();
        for (PageRange range : this.getPageSelection()) {
            retSet.addAll(range.getPages(upperLimit));
        }
        return retSet;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.rotation).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RotateParameters)) {
            return false;
        }
        RotateParameters parameter = (RotateParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.rotation, parameter.getRotation()).isEquals();
    }
}

