/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.pdf.label;

import java.security.InvalidParameterException;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.model.pdf.label.PdfLabelNumberingStyle;

public final class PdfPageLabel {
    @NotNull
    private String labelPrefix;
    @NotNull
    private PdfLabelNumberingStyle numberingStyle;
    @Min(value=1L)
    private int logicalPageNumber;

    private PdfPageLabel(String labelPrefix, PdfLabelNumberingStyle numberingStyle, int logicalPageNumber) {
        this.labelPrefix = labelPrefix;
        this.numberingStyle = numberingStyle;
        this.logicalPageNumber = logicalPageNumber;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public PdfLabelNumberingStyle getNumberingStyle() {
        return this.numberingStyle;
    }

    public int getLogicalPageNumber() {
        return this.logicalPageNumber;
    }

    public String toString() {
        return new ToStringBuilder(this).append(this.labelPrefix).append(this.numberingStyle).append("logicalPageNumber", this.logicalPageNumber).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.labelPrefix).append(this.numberingStyle).append(this.logicalPageNumber).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PdfPageLabel)) {
            return false;
        }
        PdfPageLabel pageLabel = (PdfPageLabel)other;
        return new EqualsBuilder().append(this.labelPrefix, pageLabel.getLabelPrefix()).append(this.numberingStyle, pageLabel.getNumberingStyle()).append(this.logicalPageNumber, pageLabel.getLogicalPageNumber()).isEquals();
    }

    public static PdfPageLabel newInstanceWithoutLabel(PdfLabelNumberingStyle numberingStyle, int logicalPageNumber) {
        return PdfPageLabel.newInstanceWithLabel("", numberingStyle, logicalPageNumber);
    }

    public static PdfPageLabel newInstanceWithLabel(String label, PdfLabelNumberingStyle numberingStyle, int logicalPageNumber) {
        if (logicalPageNumber < 1) {
            throw new InvalidParameterException("Input page number must be positive.");
        }
        if (label == null) {
            throw new InvalidParameterException("Input label cannot be null.");
        }
        if (numberingStyle == null) {
            throw new InvalidParameterException("Input numbering style cannot be null.");
        }
        return new PdfPageLabel(label, numberingStyle, logicalPageNumber);
    }
}

