/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.IOException;
import java.util.Optional;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSVisitor;
import org.sejda.util.RequireUtils;

public class COSDocument
extends COSBase {
    private String headerVersion;
    private COSDictionary trailer;

    public COSDocument() {
        this(new COSDictionary(), "1.4");
        COSDictionary catalog = new COSDictionary();
        catalog.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        this.trailer.setItem(COSName.ROOT, (COSBase)catalog);
    }

    public COSDocument(COSDictionary trailer) {
        this(trailer, "1.4");
    }

    public COSDocument(COSDictionary trailer, String headerVersion) {
        RequireUtils.requireNotNullArg(trailer, "Trailer cannot be null");
        RequireUtils.requireNotBlank(headerVersion, "Header version cannot be blank");
        this.trailer = trailer;
        this.headerVersion = headerVersion;
        Optional.ofNullable(this.trailer.getDictionaryObject(COSName.ROOT)).filter(c -> c instanceof COSDictionary).map(c -> (COSDictionary)c).ifPresent(d -> d.setItem(COSName.TYPE, (COSBase)COSName.CATALOG));
    }

    public void setHeaderVersion(String headerVersion) {
        RequireUtils.requireNotBlank(headerVersion, "Header version cannot be null");
        this.headerVersion = headerVersion;
    }

    public String getHeaderVersion() {
        return this.headerVersion;
    }

    public boolean isEncrypted() {
        return this.trailer.getDictionaryObject(COSName.ENCRYPT) != null;
    }

    public COSDictionary getEncryptionDictionary() {
        return (COSDictionary)this.trailer.getDictionaryObject(COSName.ENCRYPT);
    }

    public void setEncryptionDictionary(COSDictionary dictionary) {
        this.trailer.setItem(COSName.ENCRYPT, (COSBase)dictionary);
    }

    public COSArray getDocumentID() {
        return (COSArray)this.trailer.getDictionaryObject(COSName.ID);
    }

    public void setDocumentID(COSArray id) {
        this.trailer.setItem(COSName.ID, (COSBase)id);
    }

    public COSDictionary getCatalog() {
        return (COSDictionary)Optional.ofNullable(this.trailer.getDictionaryObject(COSName.ROOT)).orElseThrow(() -> new IllegalStateException("Catalog cannot be found"));
    }

    public COSDictionary getTrailer() {
        return this.trailer;
    }

    @Override
    public void accept(COSVisitor visitor) throws IOException {
        visitor.visit(this);
    }
}

