/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.util.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class PDXFAResource
implements COSObjectable {
    private static final int BUFFER_SIZE = 1024;
    private COSBase xfa;

    public PDXFAResource(COSBase xfaBase) {
        this.xfa = xfaBase;
    }

    @Override
    public COSBase getCOSObject() {
        return this.xfa;
    }

    /*
     * Loose catch block
     */
    public byte[] getBytes() throws IOException {
        InputStream is = null;
        byte[] xfaBytes = null;
        try {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                if (this.getCOSObject() instanceof COSArray) {
                    xfaBytes = new byte[1024];
                    COSArray cosArray = (COSArray)this.getCOSObject();
                    for (int i = 1; i < cosArray.size(); i += 2) {
                        COSBase cosObj = cosArray.getObject(i);
                        if (!(cosObj instanceof COSStream)) continue;
                        is = ((COSStream)cosObj).getUnfilteredStream();
                        int nRead = 0;
                        while ((nRead = is.read(xfaBytes, 0, xfaBytes.length)) != -1) {
                            baos.write(xfaBytes, 0, nRead);
                        }
                        baos.flush();
                    }
                } else if (this.xfa.getCOSObject() instanceof COSStream) {
                    xfaBytes = new byte[1024];
                    is = ((COSStream)this.xfa.getCOSObject()).getUnfilteredStream();
                    int nRead = 0;
                    while ((nRead = is.read(xfaBytes, 0, xfaBytes.length)) != -1) {
                        baos.write(xfaBytes, 0, nRead);
                    }
                    baos.flush();
                }
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.close(is);
        }
    }

    public Document getDocument() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(this.getBytes()));
    }
}

