// emacs edit mode for this file is -*- C++ -*-
/****************************************
*  Computer Algebra System SINGULAR     *
****************************************/
/*
* ABSTRACT: interface between Singular and factory
*/


#ifndef INCL_FACTORYSING_H
#define INCL_FACTORYSING_H

#include <singular/structs.h>
#include <singular/polys.h>
#include <singular/ideals.h>
#include <singular/intvec.h>
#include <singular/matpol.h>
#include <singular/longtrans.h>

poly singclap_gcd ( poly f, poly g );
poly singclap_gcd_r ( poly f, poly g, const ring r );
napoly singclap_alglcm ( napoly f, napoly g );
void singclap_algdividecontent ( napoly f, napoly g, napoly &ff, napoly &gg );

poly singclap_resultant ( poly f, poly g , poly x);

BOOLEAN singclap_extgcd ( poly f, poly g, poly &res, poly &pa, poly &pb );
BOOLEAN singclap_extgcd_r ( poly f, poly g, poly &res, poly &pa, poly &pb, const ring r );

poly singclap_pdivide ( poly f, poly g );
poly singclap_pdivide_r ( poly f, poly g, const ring r );

void singclap_divide_content ( poly f );

ideal singclap_factorize ( poly f, intvec ** v , int with_exps);

ideal singclap_sqrfree ( poly f, intvec ** v, int with_exps);

matrix singclap_irrCharSeries ( ideal I);

#ifdef HAVE_NTL
matrix singntl_HNF(matrix A);
intvec* singntl_HNF(intvec* A);
matrix singntl_LLL(matrix A);
intvec* singntl_LLL(intvec* A);
ideal singclap_absFactorize ( poly f, ideal & mipos, intvec ** exps, int & n);
#endif

BOOLEAN singclap_isSqrFree(poly f);

char* singclap_neworder ( ideal I);

poly singclap_det( const matrix m );
int singclap_det_i( intvec * m );
number singclap_det_bi( bigintmat * m);

BOOLEAN jjRESULTANT(leftv res, leftv u, leftv v, leftv w);
BOOLEAN jjCHARSERIES(leftv res, leftv u);
#if 0
BOOLEAN jjIS_SQR_FREE(leftv res, leftv u);
#endif

#endif /* INCL_FACTORYSING_H */

