/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.tomcat.util.res.StringManager;

@Deprecated
public abstract class MessageInbound
extends StreamInbound {
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.websocket");
    private int byteBufferMaxSize = 0x200000;
    private int charBufferMaxSize = 0x200000;
    private ByteBuffer bb = ByteBuffer.allocate(8192);
    private CharBuffer cb = CharBuffer.allocate(8192);

    @Override
    protected final void onBinaryData(InputStream is) throws IOException {
        int read = 0;
        while (read > -1) {
            this.bb.position(this.bb.position() + read);
            if (this.bb.remaining() == 0) {
                this.resizeByteBuffer();
            }
            read = is.read(this.bb.array(), this.bb.position(), this.bb.remaining());
        }
        this.bb.flip();
        this.onBinaryMessage(this.bb);
        this.bb.clear();
    }

    @Override
    protected final void onTextData(Reader r) throws IOException {
        int read = 0;
        while (read > -1) {
            this.cb.position(this.cb.position() + read);
            if (this.cb.remaining() == 0) {
                this.resizeCharBuffer();
            }
            read = r.read(this.cb.array(), this.cb.position(), this.cb.remaining());
        }
        this.cb.flip();
        this.onTextMessage(this.cb);
        this.cb.clear();
    }

    private void resizeByteBuffer() throws IOException {
        int maxSize = this.getByteBufferMaxSize();
        if (this.bb.limit() >= maxSize) {
            throw new IOException(sm.getString("message.bufferTooSmall"));
        }
        long newSize = this.bb.limit() * 2;
        if (newSize > (long)maxSize) {
            newSize = maxSize;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate((int)newSize);
        this.bb.rewind();
        newBuffer.put(this.bb);
        this.bb = newBuffer;
    }

    private void resizeCharBuffer() throws IOException {
        int maxSize = this.getCharBufferMaxSize();
        if (this.cb.limit() >= maxSize) {
            throw new IOException(sm.getString("message.bufferTooSmall"));
        }
        long newSize = this.cb.limit() * 2;
        if (newSize > (long)maxSize) {
            newSize = maxSize;
        }
        CharBuffer newBuffer = CharBuffer.allocate((int)newSize);
        this.cb.rewind();
        newBuffer.put(this.cb);
        this.cb = newBuffer;
    }

    public final int getByteBufferMaxSize() {
        return this.byteBufferMaxSize;
    }

    public final void setByteBufferMaxSize(int byteBufferMaxSize) {
        this.byteBufferMaxSize = byteBufferMaxSize;
    }

    public final int getCharBufferMaxSize() {
        return this.charBufferMaxSize;
    }

    public final void setCharBufferMaxSize(int charBufferMaxSize) {
        this.charBufferMaxSize = charBufferMaxSize;
    }

    protected abstract void onBinaryMessage(ByteBuffer var1) throws IOException;

    protected abstract void onTextMessage(CharBuffer var1) throws IOException;
}

