define([
    'jquery',
    'msg/Msg',
    'unifi/service/location/locationService',
    //non-exporting
    'foundation'
], function (
    $,
    Msg,
    locationService
) {
    'use strict';
    $(function () {
        $(document).foundation();

        var $loginForm = $('#LoginForm'),
            $errorMessage = $('.error-message');

        var siteName = locationService.getSiteName();

        // hotspot login
        var $LoginDescription = $('#HotspotLogin').find('#LoginDescription'),
            $ErrorMessage     = $('#HotspotLogin').find('.error-message'),
            $LoginButton      = $('#HotspotLogin').find('#LoginButton'),
            // ie8 modal 
            $IE8Header        = $('.ie8-header'),
            $IE8Message       = $('.ie8-message'),
            $IE8Chrome        = $('.link-chrome'),
            $IE8FireFox       = $('.link-firefox'),
            //nosite modal
            $nositeHeader        = $('.nosite-header'),
            $nositeMessage       = $('.nosite-message')
        ;
        
        $LoginDescription.find('h1').text(Msg.G_HotspotManagerLogin);
        $ErrorMessage.text(Msg.E_InvalidUNPW);
        $LoginButton.text(Msg.G_HotspotLogin);

        // ie8 modal
        $IE8Header.text(Msg.N_IE8IsntGoingWork);
        $IE8Message.text(Msg.N_IE8NonCompatible);
        $IE8Chrome.find('label').text(Msg.G_HotspotChrome);
        $IE8FireFox.find('label').text(Msg.G_HotspotFirefox);
        
        // ie8 modal
        $nositeHeader.text(Msg.N_IE8IsntGoingWork);
        $nositeMessage.text(Msg.E_InvalidSite);

        if (!siteName) {
            $('.nosite-hotspot-login').show();
            return;
        }

        $loginForm.on('submit', function() {
            $.ajax({
                url: '/api/login',
                type: 'POST',
                data: JSON.stringify({
                    username: $('#LoginUsername').val(),
                    password: $('#LoginPassword').val(),
                    for_hotspot: true,
                    site_name: siteName,
                    strict: true
                }),
                success: function(data, textStatus, xhr) {
                    $errorMessage.hide();

                    if(textStatus && textStatus === 'success' && xhr && xhr.status === 200) {
                        locationService.gotoHotspotPage(siteName);
                    }
                },
                error: function(xhr, textStatus, errorThrown) {
                    $errorMessage.show();
                }
            });

            return false;
        });
    });
});
