/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class InstrumentMethodGroupData {
    protected int[] instrMethodClassLoaderIds;
    protected String[] instrMethodClasses;
    protected boolean[] instrMethodLeaf;
    protected byte[][] replacementClassFileBytes;
    protected int addInfo;
    protected int nClasses;
    protected int nMethods;

    public InstrumentMethodGroupData(String[] stringArray, int[] nArray, byte[][] byArray, boolean[] blArray, int n) {
        this.nClasses = stringArray.length;
        this.nMethods = blArray != null ? blArray.length : 0;
        this.instrMethodClasses = stringArray;
        this.instrMethodClassLoaderIds = nArray;
        this.replacementClassFileBytes = byArray;
        this.addInfo = n;
    }

    InstrumentMethodGroupData() {
    }

    public int getAddInfo() {
        return this.addInfo;
    }

    public int[] getClassLoaderIds() {
        return this.instrMethodClassLoaderIds;
    }

    public boolean[] getInstrMethodLeaf() {
        return this.instrMethodLeaf;
    }

    public String[] getMethodClasses() {
        return this.instrMethodClasses;
    }

    public int getNClasses() {
        return this.nClasses;
    }

    public int getNMethods() {
        return this.nMethods;
    }

    public byte[][] getReplacementClassFileBytes() {
        return this.replacementClassFileBytes;
    }

    public void dump() {
        if (this.instrMethodClasses == null) {
            System.err.println("0 classes --");
            return;
        }
        if (this.instrMethodClasses[0].startsWith("*FAKE")) {
            System.err.println("Fake InstrMethodGroupBase --");
            return;
        }
        System.err.println(this.nClasses + " classes, " + this.nMethods + " methods --");
        boolean bl = false;
        for (int i = 0; i < this.nClasses; ++i) {
            System.err.print("--Class " + this.instrMethodClasses[i] + "," + this.instrMethodClassLoaderIds[i]);
            System.err.println();
        }
    }

    public String toString() {
        return (this.instrMethodClasses != null ? this.instrMethodClasses.length : 0) + " classes.";
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n;
        int n2;
        this.nClasses = objectInputStream.readInt();
        if (this.nClasses == 0) {
            return;
        }
        if (this.instrMethodClasses == null || this.nClasses > this.instrMethodClasses.length) {
            this.instrMethodClasses = new String[this.nClasses];
            this.instrMethodClassLoaderIds = new int[this.nClasses];
        }
        for (n2 = 0; n2 < this.nClasses; ++n2) {
            this.instrMethodClasses[n2] = objectInputStream.readUTF();
            this.instrMethodClassLoaderIds[n2] = objectInputStream.readInt();
        }
        this.nMethods = objectInputStream.readInt();
        n2 = objectInputStream.read();
        if (n2 != 0) {
            if (this.instrMethodLeaf == null || this.nMethods > this.instrMethodLeaf.length) {
                this.instrMethodLeaf = new boolean[this.nMethods];
            }
            for (n = 0; n < this.nMethods; ++n) {
                this.instrMethodLeaf[n] = objectInputStream.readBoolean();
            }
        } else {
            this.instrMethodLeaf = null;
        }
        this.addInfo = objectInputStream.readInt();
        if (this.replacementClassFileBytes == null || this.nClasses > this.replacementClassFileBytes.length) {
            this.replacementClassFileBytes = new byte[this.nClasses][];
        }
        for (n = 0; n < this.nClasses; ++n) {
            int n3 = objectInputStream.readInt();
            if (n3 <= 0) continue;
            this.replacementClassFileBytes[n] = new byte[n3];
            objectInputStream.readFully(this.replacementClassFileBytes[n]);
        }
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        if (this.instrMethodClasses == null) {
            objectOutputStream.writeInt(0);
            return;
        }
        objectOutputStream.writeInt(this.nClasses);
        for (n = 0; n < this.nClasses; ++n) {
            objectOutputStream.writeUTF(this.instrMethodClasses[n]);
            objectOutputStream.writeInt(this.instrMethodClassLoaderIds[n]);
        }
        objectOutputStream.writeInt(this.nMethods);
        if (this.instrMethodLeaf != null) {
            objectOutputStream.write(1);
            for (n = 0; n < this.nMethods; ++n) {
                objectOutputStream.writeBoolean(this.instrMethodLeaf[n]);
            }
        } else {
            objectOutputStream.write(0);
        }
        objectOutputStream.writeInt(this.addInfo);
        for (n = 0; n < this.nClasses; ++n) {
            if (this.replacementClassFileBytes[n] == null) {
                objectOutputStream.writeInt(0);
                continue;
            }
            objectOutputStream.writeInt(this.replacementClassFileBytes[n].length);
            objectOutputStream.write(this.replacementClassFileBytes[n]);
        }
        this.instrMethodClasses = null;
        this.instrMethodClassLoaderIds = null;
        this.instrMethodLeaf = null;
        this.replacementClassFileBytes = null;
    }
}

