/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.attach;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.attach.AttachModelImpl;
import com.sun.tools.visualvm.attach.JRockitAttachModelImpl;
import com.sun.tools.visualvm.attach.OracleJRockitAttachModelImpl;
import com.sun.tools.visualvm.core.model.AbstractModelProvider;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.tools.attach.AttachModel;
import com.sun.tools.visualvm.tools.jvmstat.JvmJvmstatModel;
import com.sun.tools.visualvm.tools.jvmstat.JvmJvmstatModelFactory;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttachModelProvider
extends AbstractModelProvider<AttachModel, Application> {
    AttachModelProvider() {
    }

    public AttachModel createModelFor(Application app) {
        JvmJvmstatModel jvmstat;
        if (Host.LOCALHOST.equals((Object)app.getHost()) && (jvmstat = JvmJvmstatModelFactory.getJvmstatModelFor((Application)app)) != null && jvmstat.isAttachable()) {
            if (Utilities.isWindows()) {
                Boolean this64bitArch = AttachModelProvider.is64BitArchitecture();
                Boolean app64bitArch = AttachModelProvider.is64BitArchitecture(jvmstat);
                if (this64bitArch != null && app64bitArch != null && !this64bitArch.equals(app64bitArch)) {
                    return null;
                }
            }
            String pid = String.valueOf(app.getPid());
            for (VirtualMachineDescriptor descr : VirtualMachine.list()) {
                if (!pid.equals(descr.id())) continue;
                String vmName = jvmstat.getVmName();
                if (vmName != null) {
                    if ("BEA JRockit(R)".equals(vmName)) {
                        return new JRockitAttachModelImpl(app);
                    }
                    if ("Oracle JRockit(R)".equals(vmName)) {
                        return new OracleJRockitAttachModelImpl(app);
                    }
                }
                return new AttachModelImpl(app);
            }
        }
        return null;
    }

    private static Boolean is64BitArchitecture(JvmJvmstatModel jvmstat) {
        String name = jvmstat.getVmName();
        if (name != null) {
            return name.toLowerCase().contains("64-bit");
        }
        return null;
    }

    private static Boolean is64BitArchitecture() {
        String thisArch = System.getProperty("sun.arch.data.model");
        if (thisArch != null) {
            return "64".equals(thisArch);
        }
        return null;
    }
}

