/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.model;

import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.io.IOUtils;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ImageOptimizer {
    private static final Logger LOG = LoggerFactory.getLogger(ImageOptimizer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File optimize(BufferedImage bufferedImage, float quality, int dpi, int maxWidthOrHeight) throws IOException {
        File outputFile = File.createTempFile("pdfimage", ".jpeg");
        outputFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(outputFile);
        try {
            if (bufferedImage.getHeight() > maxWidthOrHeight || bufferedImage.getWidth() > maxWidthOrHeight) {
                bufferedImage = Scalr.resize(bufferedImage, Scalr.Method.AUTOMATIC, maxWidthOrHeight, new BufferedImageOp[0]);
            }
            BufferedImage imageRGB = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
            imageRGB.createGraphics().drawImage(bufferedImage, 0, 0, Color.WHITE, null);
            JPEGImageWriter imageWriter = (JPEGImageWriter)ImageIO.getImageWritersBySuffix("jpeg").next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(fos);
            imageWriter.setOutput(ios);
            IIOMetadata imageMetaData = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(imageRGB), null);
            try {
                Element tree = (Element)imageMetaData.getAsTree("javax_imageio_jpeg_image_1.0");
                Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
                jfif.setAttribute("Xdensity", Integer.toString(dpi));
                jfif.setAttribute("Ydensity", Integer.toString(dpi));
            }
            catch (Exception e) {
                LOG.warn("Failed to set DPI for image, metadata manipulation failed", e);
            }
            JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
            jpegParams.setCompressionMode(2);
            jpegParams.setCompressionQuality(quality);
            try {
                imageWriter.write(imageMetaData, new IIOImage(imageRGB, null, null), jpegParams);
            }
            finally {
                IOUtils.closeQuietly(ios);
                imageWriter.dispose();
            }
            File file = outputFile;
            return file;
        }
        finally {
            IOUtils.closeQuietly(fos);
            bufferedImage.flush();
        }
    }
}

